/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.bean.ConfigCheckerEntity;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.mapper.ApplyMapper;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.business.op.service.IConfigCheckerService;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ApplyReportVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="applyService")
public class ApplyServiceImpl
extends BaseServiceImpl<ApplyMapper, ApplyEntity>
implements IApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "CSCEC5B_OP_APPLY";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConfigCheckerService configCheckerService;
    @Autowired
    private IGuardUserService guardUserService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public ApplyVO getBaseInfo(Long orgId, String openid) {
        ApplyEntity apply = new ApplyEntity();
        CommonResponse response = this.iOrgApi.getOneById(orgId);
        apply.setParentOrgId(((OrgVO)response.getData()).getParentId());
        apply.setOrgName(((OrgVO)response.getData()).getName());
        CommonResponse commonResponse = this.projectApi.queryProjectByProjectDepartmentId(String.valueOf(orgId));
        ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)commonResponse.getData();
        apply.setOrgId(orgId);
        apply.setProjectId(projectRegisterVO.getId());
        apply.setProjectName(projectRegisterVO.getName());
        apply.setBranchCorpId(projectRegisterVO.getRealCorpId());
        apply.setBranchCorpName(projectRegisterVO.getRealCorpName());
        apply.setOpenId(openid);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ApplyEntity::getOrgId, (Object)orgId);
        queryWrapper.eq(ApplyEntity::getOpenId, (Object)openid);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List applyList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)applyList)) {
            apply.setApplyUser(((ApplyEntity)((Object)applyList.get(0))).getApplyUser());
            apply.setApplyDept(((ApplyEntity)((Object)applyList.get(0))).getApplyDept());
            apply.setTel(((ApplyEntity)((Object)applyList.get(0))).getTel());
        }
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)apply), ApplyVO.class));
    }

    @Override
    public ApplyVO insertOrUpdate(ApplyVO applyVO) {
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)((Object)applyVO), ApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        ApplyVO vo = (ApplyVO)((Object)BeanMapper.map((Object)((Object)entity), ApplyVO.class));
        return vo;
    }

    @Override
    public ApplyVO selectDetail(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyEntity.getOpStatus())) {
            Integer lasttime = Integer.parseInt(((ApplyMapper)this.baseMapper).selectCfgUrl("lasttime"));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(applyEntity.getCheckTime());
            ((Calendar)calendar).add(12, lasttime);
            if (1 == new Date().compareTo(calendar.getTime())) {
                applyEntity.setOpStatus(OpStatusEnum.EXPIRE.getCode());
                this.updateById((Object)applyEntity);
            }
        }
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class));
    }

    @Override
    public Boolean getPower(ApplyVO applyVO) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(applyVO.getId()));
        if (OpStatusEnum.WAIT_CHECK.getCode().equals(applyEntity.getOpStatus())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ConfigCheckerEntity::getProjectId, (Object)applyEntity.getProjectId());
            wrapper.eq(ConfigCheckerEntity::getUserId, (Object)InvocationInfoProxy.getUserid());
            return this.configCheckerService.count((Wrapper)wrapper) > 0;
        }
        if (OpStatusEnum.WAIT_CONFIRM.getCode().equals(applyEntity.getOpStatus())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(GuardUserEntity::getProjectId, (Object)applyEntity.getProjectId());
            wrapper.eq(GuardUserEntity::getOpenId, (Object)applyVO.getOpenId());
            return this.guardUserService.count((Wrapper)wrapper) > 0;
        }
        throw new BusinessException("\u8be5\u5355\u636e\u72b6\u6001\u65e0\u626b\u7801\u7ed3\u679c");
    }

    @Override
    public ApplyVO createQRCode(Long id) {
        String accessroken = "";
        if (null == this.redisTemplate.opsForValue().get((Object)"op_access_token")) {
            accessroken = this.weChatUtil.getAccesstoken();
            if (!StringUtils.isEmpty((CharSequence)accessroken)) {
                this.redisTemplate.opsForValue().set((Object)"op_access_token", (Object)accessroken, 90L, TimeUnit.MINUTES);
            }
            this.logger.info("\u83b7\u53d6accessroken:" + accessroken);
        } else {
            accessroken = this.redisTemplate.opsForValue().get((Object)"op_access_token").toString();
            this.logger.info("\u83b7\u53d6accessroken:=====" + accessroken);
        }
        String baseAddr = null;
        if (this.baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        } else if (this.baseHost.contains("9082")) {
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        } else if (this.baseHost.contains("9080")) {
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        String path = "permit/card";
        String multipartFile = this.weChatUtil.createShortQRCodeStr(path, String.valueOf(id), applyEntity.getBillCode(), accessroken);
        applyEntity.setQrcode(baseAddr + this.dealImg(multipartFile, applyEntity));
        this.saveOrUpdate((Object)applyEntity, false);
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class));
    }

    @Override
    public List<ApplyReportVO> queryReportPage(Page<ApplyReportVO> page, QueryWrapper wrapper) {
        return ((ApplyMapper)this.baseMapper).queryReportPage(page, wrapper);
    }

    private String dealImg(String file, ApplyEntity applyEntity) {
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202209000018");
        attachmentVO.setSourceId(String.valueOf(applyEntity.getId()));
        attachmentVO.setSourceType("EJCBT202209000018");
        attachmentVO.setFileList(Arrays.asList(file));
        this.logger.info(JSON.toJSONString((Object)attachmentVO));
        CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
        this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return ((AttachmentVO)((List)listCommonResponse.getData()).get(0)).getFilePath();
        }
        return null;
    }
}

