package com.ejianc.business.op.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 * 配置实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("config")
public class ConfigController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IConfigService configService;

    @Autowired
    private IProjectApi projectApi;

    @RequestMapping(value = "/createQRCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigVO> createQRCode() {
        return CommonResponse.success("生成二维码成功", configService.createQRCode(InvocationInfoProxy.getOrgId()));
    }

    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigVO> queryDetail() {
        LambdaQueryWrapper<ConfigEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConfigEntity::getOrgId, InvocationInfoProxy.getOrgId());
        ConfigEntity config = configService.getOne(queryWrapper, false);
        if (null != config) {
            return CommonResponse.success("查询详情成功", BeanMapper.map(config, ConfigVO.class));
        }
        return CommonResponse.error("当前项目部组织未做过出门证设置");
    }

    @RequestMapping(value = "/queryDetailByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigVO> queryDetailByOrgId(@RequestParam(value = "orgId") String orgId) {
        //五局老数据传的orgId可能是NC项目主键
        CommonResponse<ProjectRegisterVO> response = projectApi.queryProjectBySourceId(orgId);
        ProjectRegisterVO projectRegisterVO = null;
        if (response.isSuccess() && null != response.getData() && null != response.getData().getId()) {
            projectRegisterVO = response.getData();
        } else {
            CommonResponse<ProjectRegisterVO> commonResponse = projectApi.queryProjectByProjectDepartmentId(orgId);
            projectRegisterVO = commonResponse.getData();
        }
        LambdaQueryWrapper<ConfigEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConfigEntity::getOrgId, projectRegisterVO.getProjectDepartmentId());
        ConfigEntity config = configService.getOne(queryWrapper, false);
        if (null != config) {
            return CommonResponse.success("查询详情成功", BeanMapper.map(config, ConfigVO.class));
        }
        return CommonResponse.error("当前项目未做过出门证设置");
    }

    @RequestMapping(value = "/updateConfig", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> close(@RequestBody ConfigVO configVO) {
        LambdaUpdateWrapper<ConfigEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(ConfigEntity::getOrgId, InvocationInfoProxy.getOrgId());
        wrapper.set(null != configVO.getCloseStatus(), ConfigEntity::getCloseStatus, configVO.getCloseStatus());
        wrapper.set(null != configVO.getPhotoStatus(), ConfigEntity::getPhotoStatus, configVO.getPhotoStatus());
        wrapper.set(null != configVO.getGuardStatus(), ConfigEntity::getGuardStatus, configVO.getGuardStatus());
        configService.update(wrapper);
        return CommonResponse.success("更新成功");
    }
}
