package com.ejianc.business.op.service.impl;

import com.ejianc.business.op.bean.ApplyEntity;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.business.op.util.TemplateDatas;
import com.ejianc.business.op.util.TemplateMsgApi;
import com.ejianc.business.op.util.WeChatUtil;
import com.jfinal.weixin.sdk.api.ApiResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.concurrent.TimeUnit;

@Service("apply")
public class ApplyBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IApplyService applyService;

	@Value("${wechat.tmpId}")
    private String tmpId;

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Autowired
	private WeChatUtil weChatUtil;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("beforeSubmitProcessor billId " + billId + "state  " + state  + "billTypeCode" + billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("afterSubmitProcessor billId " + billId + "state  " + state  + "billTypeCode" + billTypeCode);
		ApplyEntity applyEntity = applyService.selectById(billId);
		applyEntity.setOpStatus(OpStatusEnum.APPROVING.getCode());
		applyService.saveOrUpdate(applyEntity);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("beforeHasBpmBack billId " + billId + "state  " + state  + "billTypeCode" + billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("afterHasBpmBack billId " + billId + "state  " + state  + "billTypeCode" + billTypeCode);
        ApplyEntity applyEntity = applyService.selectById(billId);
        applyEntity.setOpStatus(OpStatusEnum.REFUSE.getCode());
        applyService.saveOrUpdate(applyEntity);
		sendWxMsg(billId, false);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		logger.info("beforeInApprovalBack billId " + billId + "state  " + state  + "billTypeCode" + billTypeCode);
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("beforeApprovalProcessor billId " + billId + "state  " + state  + "billTypeCode" + billTypeCode);
//		if(state == 0 || state == 2) {
//			ApplyEntity applyEntity = applyService.selectById(billId);
//			applyEntity.setOpStatus(OpStatusEnum.APPROVING.getCode());
//			applyService.saveOrUpdate(applyEntity);
//		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		applyService.createQRCode(billId);
		sendWxMsg(billId, true);
		return CommonResponse.success();
	}

	private void sendWxMsg(Long billId, Boolean isPass){
		ApplyEntity entity = applyService.selectById(billId);
		String accessroken =  null;
		if(null == redisTemplate.opsForValue().get("op_access_token")){
			accessroken = weChatUtil.getAccesstoken();
			if(!StringUtils.isEmpty(accessroken)){
				redisTemplate.opsForValue().set("op_access_token", accessroken, 90, TimeUnit.MINUTES);
			}
			logger.info("获取accessroken:"+accessroken);
		}else{
			accessroken = redisTemplate.opsForValue().get("op_access_token").toString();
			logger.info("获取accessroken:=====" + accessroken);
		}
		if(!StringUtils.isEmpty(accessroken)){
			String openid = entity.getOpenId();// 获取公众号openid
			if (StringUtils.isNotEmpty(openid)) {
				String path = "pages/index/index";//// 跳转路径
				logger.error("pagepath:" + path);
				String json = TemplateDatas.New().setTouser(openid).setTemplate_id(tmpId).setPage(path).setMiniprogram_state("formal")
						.add("character_string19", entity.getBillCode(), "#743A3A")
						.add("phrase5", isPass ? "通过" : "驳回", "#743A3A")
						.add("thing4", "申请单审核完成，点击查看详情", "#0000FF").build();
				logger.debug("发送消息信息：" + json);
				ApiResult result = TemplateMsgApi.send(accessroken, json);
				logger.debug("发送公众号消息返回结果+" + result.getJson());
			}
		}
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("beforeAbstainingProcessor billId " + billId + "state  " + state  + "billTypeCode" + billTypeCode);
		ApplyEntity applyEntity = applyService.selectById(billId);
		applyEntity.setOpStatus(OpStatusEnum.SAVE.getCode());
		applyService.saveOrUpdate(applyEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		logger.info("afterAbstainingProcessor billId " + billId + "state  " + state  + "billTypeCode" + billTypeCode);
		return CommonResponse.success();
	}

}
