/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.bean.MaterialSpecEntity;
import com.ejianc.business.op.service.IMaterialSpecService;
import com.ejianc.business.op.vo.MaterialSpecVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialSpec"})
public class MaterialSpecController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IMaterialSpecService materialSpecService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialSpecVO> saveOrUpdate(@RequestBody MaterialSpecVO saveOrUpdateVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MaterialSpecEntity::getOpMaterialId, (Object)saveOrUpdateVO.getOpMaterialId());
        queryWrapper.eq(MaterialSpecEntity::getName, (Object)saveOrUpdateVO.getName());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        if (this.materialSpecService.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u540c\u4e00\u5206\u7c7b\u4e0b\u89c4\u683c\u578b\u53f7\u91cd\u590d\uff01");
        }
        MaterialSpecEntity entity = (MaterialSpecEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MaterialSpecEntity.class));
        this.materialSpecService.saveOrUpdate((Object)entity, false);
        MaterialSpecVO vo = (MaterialSpecVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialSpecVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialSpecVO> queryDetail(Long id) {
        MaterialSpecEntity entity = (MaterialSpecEntity)((Object)this.materialSpecService.selectById(id));
        MaterialSpecVO vo = (MaterialSpecVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialSpecVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialSpecVO> vos) {
        this.materialSpecService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialSpecVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.materialSpecService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialSpecVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/opMaterialSpecRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialSpecVO>> contractRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionMap.get("opMaterialId")) {
                return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u4e2d\u7269\u8d44\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long opMaterialId = Long.valueOf(conditionMap.get("opMaterialId").toString());
        queryParam.getParams().put("opMaterialId", new Parameter("eq", (Object)opMaterialId));
        IPage pageData = this.materialSpecService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), MaterialSpecVO.class));
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }
}

