/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.util;

import com.ejianc.foundation.usercenter.vo.UserVO;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;

public class PasswordUtils {
    public static final int HASH_INTERATIONS = 1;
    private static final int SALT_SIZE = 8;

    public static String encodebyUserCode(UserVO user) {
        String userCode = user.getUserCode();
        if (StringUtils.isNotBlank((String)userCode)) {
            String hashUserCode = PasswordUtils.encodePasswordUsingSHA(userCode);
            byte[] hashPassword = Digests.sha1((byte[])(user.getPassword() + hashUserCode).getBytes(), (byte[])Encodes.decodeHex((String)user.getSalt()), (int)1);
            return Encodes.encodeHex((byte[])hashPassword);
        }
        byte[] hashPassword = Digests.sha1((byte[])user.getPassword().getBytes(), (byte[])Encodes.decodeHex((String)user.getSalt()), (int)1);
        return Encodes.encodeHex((byte[])hashPassword);
    }

    public static void setSalt(UserVO user) {
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.encodeHex((byte[])salt));
    }

    public static String encodePassword(String password, String salt) {
        byte[] hashPassword = Digests.sha1((byte[])password.getBytes(), (byte[])Encodes.decodeHex((String)salt), (int)1);
        return Encodes.encodeHex((byte[])hashPassword);
    }

    public static String encodePasswordByUserCode(String password, String salt, String userCode) {
        if (StringUtils.isNotBlank((String)userCode)) {
            String hashUserCode = PasswordUtils.encodePasswordUsingSHA(userCode);
            byte[] hashPassword = Digests.sha1((byte[])(password + hashUserCode).getBytes(), (byte[])Encodes.decodeHex((String)salt), (int)1);
            return Encodes.encodeHex((byte[])hashPassword);
        }
        byte[] hashPassword = Digests.sha1((byte[])password.getBytes(), (byte[])Encodes.decodeHex((String)salt), (int)1);
        return Encodes.encodeHex((byte[])hashPassword);
    }

    public static String encodePasswordUsingSHA(String password) {
        byte[] hashPassword = Digests.sha1((byte[])password.getBytes());
        String result = Encodes.encodeHex((byte[])hashPassword);
        return result;
    }

    public static String encodePasswordUsingSHA(String password, String salt) {
        byte[] hashPassword = Digests.sha1((byte[])password.getBytes());
        String shaResult = Encodes.encodeHex((byte[])hashPassword);
        byte[] encrytyPassword = Digests.sha1((byte[])shaResult.getBytes(), (byte[])Encodes.decodeHex((String)salt), (int)1);
        return Encodes.encodeHex((byte[])encrytyPassword);
    }

    public static String getSalt() {
        byte[] salt = Digests.generateSalt((int)8);
        return Encodes.encodeHex((byte[])salt);
    }

    public static void main(String[] args) throws ParseException {
        String salt = "49ba97d3d32d092a";
        String shaPassword = PasswordUtils.encodePasswordUsingSHA("adminzzyj2021");
        String password = PasswordUtils.encodePasswordByUserCode(shaPassword, salt, "adminzzyj");
        System.out.println("\u5bc6\u7801\uff1a" + password);
    }
}

