package com.ejianc.business.sync.api;

import com.ejianc.business.sync.hystrix.OddSynvHystrix;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.business.sync.vo.OddVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "cscec5b-sync-web", url = "${common.env.feign-client-url}", path = "cscec5b-sync-web", fallback = OddSynvHystrix.class)
public interface IOddSyncApi {
    //同步nc
    @PostMapping(value = "/sync/syncOdd")
    public CommonResponse<String> syncOdd(@RequestBody OddVO oddVO);
    //查看是否结算
    @GetMapping("/sync/syncFlag")
    public CommonResponse<Boolean> syncFlag(@RequestParam("id")Long id);
    //删除中间表
    @GetMapping("/sync/delSync")
    public CommonResponse<Boolean> delSync(@RequestParam("id")Long id);
    @GetMapping("/sync/updatestatus")
    public CommonResponse<OddSyncVo> updateStatus(@RequestParam("day")Integer day);

    //同步nc
    @PostMapping(value = "/sync/syncOddImport")
    public CommonResponse<String> syncOddImport(@RequestBody OddVO oddVO);
}
