package com.ejianc.business.sync.api;

import com.ejianc.business.sync.hystrix.CalculateSyncHystrix;
import com.ejianc.business.sync.vo.CalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "cscec5b-sync-web", url="${common.env.feign-client-url}", path="cscec5b-sync-web", fallback = CalculateSyncHystrix.class)
public interface ICalculateSyncApi {

	/**
	 * 同步至nc中间表
	 * @param calculateVOList
	 * @return
	 */
	@PostMapping(value = "/api/calcsync/sync")
	public CommonResponse<String> sync(@RequestBody List<CalculateVO> calculateVOList);

	/**
	 * 删除NC中间表
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/calcsync/delSync")
	public CommonResponse<String> delSync(@RequestParam("id") Long id);

	/**
	 * 结算标识查询
	 * @return
	 */
	@GetMapping(value = "/api/calcsync/settleFlagSync")
	public CommonResponse<List<CalculateVO>> queryNCInvclByTs(@RequestParam("ts") String ts);
}
