package com.ejianc.business.sync.controller;

import com.ejianc.business.sync.serv.ICmSubListService;
import com.ejianc.business.sync.vo.OddVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

@Controller
@RequestMapping("sync")
public class SyncController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICmSubListService cmSubListService;

    /**
     * 零星用工同步至nc中间表
     * @param oddVO
     * @return
     */
    @RequestMapping(value = "/syncOdd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncOdd(@RequestBody OddVO oddVO) {
        return cmSubListService.syncOdd(oddVO);
    }

    @GetMapping("updatestatus")
    public void updateStatus(Integer day) {
        day = 2; // NC没有维护ts 先按照入的ts取最近2个月的数据更新
        try {
            cmSubListService.updateNcFlag(day);
        } catch (Exception e) {
            logger.error(e.toString());
        }
    }
}
