package com.ejianc.business.sync.mapper;

import com.ejianc.business.sync.bean.CmSubList;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
@Mapper
public interface CmSubListMapper extends BaseCrudMapper<CmSubList> {

    @Select("select pk_wbsdef from jzpm_cm_sublist where pk_contract = #{pk_contract} and nvl(dr,0)=0 and rownum=1")
    String selectPkWbs(String pk_contract);

    @Select("select pk_measdoc from bd_measdoc where measname like #{infoUnit} and nvl(dr,0)=0 and rownum=1")
    String selectPkMeasdoc(String infoUnit);

    @Update("update jzpm_cm_contract set ts=#{ts} where pk_contract = #{pk_contract} and nvl(dr,0)=0")
    void updateContractTs(String pk_contract, String ts);

    @Update("update jzpm_cm_sublist set dr=1 where pk_contract = #{pk_contract} and vreserve9 = #{pkodd}")
    void deleteContractSublist(String pk_contract, String pkodd);
}
