package com.ejianc.business.sync.controller;

import com.ejianc.business.sync.service.ICmSubListService;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.business.sync.vo.OddVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

@Controller
@RequestMapping("sync")
public class SyncController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICmSubListService cmSubListService;

    /**
     * 零星用工同步至nc中间表
     * @param oddVO
     * @return
     */
    @RequestMapping(value = "/syncOdd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncOdd(@RequestBody OddVO oddVO) {
        logger.debug("------零星用工同步至nc中间表");
        return cmSubListService.syncOdd(oddVO);
    }

    @GetMapping("updatestatus")
    public CommonResponse<OddSyncVo> updateStatus() {
        Integer day = 2; // NC没有维护ts 先按照入的ts取最近2个月的数据更新
        return cmSubListService.updateNcFlag(day);

    }

    /**
     * 查看nc是否同步
     * @param id
     * @return
     */
    @GetMapping("syncFlag")
    public CommonResponse<Boolean> syncFlag(Long id) {
        logger.debug("------查看nc是否同步");
        return cmSubListService.syncFlag(id);
    }

    /**
     * 删除同步的中间表
     * @param id
     * @return
     */
    @GetMapping("delSync")
    public CommonResponse<Boolean> delSync(Long id) {
        logger.debug("------删除同步的中间表");
        return cmSubListService.delSync(id);
    }
}
