package com.ejianc.business.sync.service.impl;

import com.ejianc.business.sync.bean.BuckleDetail;
import com.ejianc.business.sync.bean.OutContract;
import com.ejianc.business.sync.cons.ModelCodeCons;
import com.ejianc.business.sync.mapper.BuckleDetailMapper;
import com.ejianc.business.sync.service.IBuckleDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service
public class BuckleDetailServiceImpl extends BaseServiceImpl<BuckleDetailMapper, BuckleDetail> implements IBuckleDetailService {

    @Autowired
    private BuckleDetailMapper baseMapper;
    @Override
    public boolean batchInsert(List<BuckleDetail> buckleDetailList, List<OutContract> outContractList) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String ts = sdf.format(new Date());
        for (int j = 0; j < outContractList.size(); j++) {
            OutContract outContract = outContractList.get(j);
            outContract.setTs(ts);
            baseMapper.insertOutContract(outContract);
        }
        for (int i = 0; i < buckleDetailList.size(); i++) {
            buckleDetailList.get(i).setTs(ts);
        }
        for (int i = 0; i < buckleDetailList.size(); i++) {
            baseMapper.batchInsert(buckleDetailList.get(i));
        }
        return true;
    }

    @Override
    public List selectStatus(Integer day) {
        return baseMapper.selectStatus(day);
    }

    @Override
    public List select() {
        return baseMapper.select();
    }

    @Override
    public Integer getOutContract(String pkOdd) {
        return baseMapper.getOutContract(ModelCodeCons.NC_JD+pkOdd);
    }

    @Override
    public Integer getBuckleList(String pkOdd) {
        return baseMapper.getBuckleList(ModelCodeCons.NC_JD+pkOdd);
    }

    @Override
    public void delOutContract(String pkOdd) {
        baseMapper.delOutContract(ModelCodeCons.NC_JD+pkOdd);
    }

    @Override
    public void delBuckleList(String pkOdd) {
        baseMapper.delBuckleList(ModelCodeCons.NC_JD+pkOdd);
    }
    //查转扣
    @Override
    public List selectRedirect(Integer day) {
        return baseMapper.selectRedirect(day);
    }
}
