package com.ejianc.business.sync.service.impl;

import com.ejianc.business.sync.bean.BuckleDetail;
import com.ejianc.business.sync.bean.CmSubList;
import com.ejianc.business.sync.bean.OutContract;
import com.ejianc.business.sync.cons.ModelCodeCons;
import com.ejianc.business.sync.mapper.CmSubListMapper;
import com.ejianc.business.sync.service.IBuckleDetailService;
import com.ejianc.business.sync.service.ICmSubListService;
import com.ejianc.business.sync.vo.OddInfoVO;
import com.ejianc.business.sync.vo.OddRedirectVO;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.business.sync.vo.OddVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class CmSubListServiceImpl extends BaseServiceImpl<CmSubListMapper, CmSubList> implements ICmSubListService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBuckleDetailService buckleDetailService;
    @Override
    public CommonResponse<String> syncOdd(OddVO oddVO) {
        //先往NC数据库插入手动新增的清单
        syncSubList(oddVO);
        //往中间表同步数据
        syncCenterOdd(oddVO);
        return CommonResponse.success("nc数据同步成功！");
    }

    @Override
    public CommonResponse<OddSyncVo> updateNcFlag(Integer day) {
        OddSyncVo vo=new OddSyncVo();
        // 合同清单
        List<Map> list = buckleDetailService.selectStatus(day);
        List<Long> nlist = new ArrayList();
        List<Long> ylist = new ArrayList();
        for (int i = 0; i < list.size(); i++) {
            if(null!=list.get(i).get("PK_BUCKLEDETAIL")){
                String pk=list.get(i).get("PK_BUCKLEDETAIL").toString().replaceAll(ModelCodeCons.NC_JD,"");
                list.get(i).put("PK_BUCKLEDETAIL",pk);
                if (list.get(i).get("BISSETTLE") != null && list.get(i).get("BISSETTLE").equals("Y")) {
                    ylist.add(Long.valueOf(pk));
                } else if (list.get(i).get("BISSETTLE") != null && list.get(i).get("BISSETTLE").equals("N")) {
                    nlist.add(Long.valueOf(pk));
                }
            }else{
                continue;
            }
        }
        if (ylist != null && ylist.size() > 0) {
            //baseMapper.updateOddStatusY(ylist);
            vo.setYinfo(ylist);
        }
        if (nlist != null && nlist.size() > 0) {
            //baseMapper.updateOddStatusN(nlist);
            vo.setNinfo(nlist);
        }
        // 合同转扣
        List<Map> rlist = buckleDetailService.selectRedirect(day);
        List<Long> tlist = new ArrayList();
        List<Long> flist = new ArrayList();
        for (int i = 0; i < rlist.size(); i++) {
            if(null!=rlist.get(i).get("PK_OUTCONTRACT")){
                String pk=rlist.get(i).get("PK_OUTCONTRACT").toString().replaceAll(ModelCodeCons.NC_JD,"");
                rlist.get(i).put("PK_OUTCONTRACT",pk);
                if (rlist.get(i).get("BISSETTLE") != null && rlist.get(i).get("BISSETTLE").equals("Y")) {
                    tlist.add(Long.valueOf(pk));
                } else if (rlist.get(i).get("BISSETTLE") != null && rlist.get(i).get("BISSETTLE").equals("N")) {
                    flist.add(Long.valueOf(pk));
                }
            }else{
                continue;
            }
        }
        if (tlist != null && tlist.size() > 0) {
            //baseMapper.updateOddStatusY(ylist);
            vo.setYredirect(tlist);
        }
        if (flist != null && flist.size() > 0) {
            //baseMapper.updateOddStatusN(nlist);
            vo.setNredirect(flist);
        }
        return CommonResponse.success("同步成功",vo);
    }

    @Override
    public CommonResponse<Boolean> syncFlag(Long id) {
        Integer getOutContract=buckleDetailService.getOutContract(String.valueOf(id));
		Integer getBuckleList=buckleDetailService.getBuckleList(String.valueOf(id));
		if(getOutContract>0||getBuckleList>0){
//			throw new ApplicationException(StatusCode.BAD_REQUEST.getCode(),
//					"数据在NC已结算，无法弃审");
            logger.debug("数据在NC已结算，无法弃审");
            return CommonResponse.success("数据在NC已结算，无法弃审",true);
		}
        logger.debug("数据在NC未结算");
        return CommonResponse.success("数据在NC未结算！",false);
    }

    @Override
    public CommonResponse<Boolean> delSync(Long id) {
        buckleDetailService.delOutContract(String.valueOf(id));
        buckleDetailService.delBuckleList(String.valueOf(id));
        return CommonResponse.success("删除中间表成功！",true);
    }

    // 同步手动新增的清单
    private void syncSubList(OddVO odd) {
        List<OddInfoVO> manualOddInfoList = odd.getOddInfoEntities();
        //List<OddInfoResponse> manualOddInfoList
        if (manualOddInfoList == null || manualOddInfoList.isEmpty()) {
            return;
        }
        List<CmSubList> toAddLists = new ArrayList<CmSubList>();
        CmSubList sublist = null;
        // String pk_project = odd.getPkProject();
        String pk_contract = odd.getContractId();
        String pk_corp = odd.getCropSourceId();
        //String ts = getTs();
        for (OddInfoVO info : manualOddInfoList) {
            logger.debug("只插入手动新增的清单");
            if (info.getSourceType() == 1) {
                sublist = new CmSubList();
                sublist.setBiscurrentlist("Y");
                sublist.setPk_measdoc(this.baseMapper.selectPkMeasdoc("%" + info.getInfoUnit() + "%"));
                sublist.setDr(0);
                //sublist.setTs(new Date());
                sublist.setTs(getTs());
                sublist.setPk_contract(pk_contract);
                sublist.setPk_sublist(generateNCPK(pk_corp));
                sublist.setPk_wbsdef(this.baseMapper.selectPkWbs(pk_contract));
                sublist.setIlistsource(2);
                sublist.setVlistcode(info.getCode());
                sublist.setVlistname(info.getName());
                sublist.setVmemo("轻量化平台推送");
                sublist.setNnum(info.getReviewNum());
                sublist.setNprice(info.getReviewPrice());
                sublist.setNfinishsumnum(info.getReviewNum());
                sublist.setNfinishsumoriginmny(info.getReviewPrice());
                sublist.setNtotaloriginmny(info.getReviewMny());
                sublist.setIattribute(0); //行属性为本单清单明细
                // todo 来源是否加标识
                sublist.setVreserve9(String.valueOf(odd.getId()));
                toAddLists.add(sublist);
            }
        }
        if (toAddLists != null && toAddLists.size() > 0) {
            //插入数据
            super.saveBatch(toAddLists);
            //刷一下合同ts
            baseMapper.updateContractTs(pk_contract, getTs());
        }
    }

    private String generateNCPK(String pk_corp) {
        //return id.toString();
        String uid = UUID.randomUUID().toString();
        uid = uid.replace("-", "");
        uid = uid.substring(0, 16);
        if (pk_corp == null) {
            pk_corp = "0001";
        }
        return pk_corp + uid;
    }

    private String getTs() {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);// 默认当前系统时间
    }
    //往中间表同步数据
    private boolean syncCenterOdd(OddVO odd) {
        //, List<OddInfoResponse> oddInfoList
        List<OddInfoVO> oddInfoList = odd.getOddInfoEntities();
        try {
            List<BuckleDetail> buckleDetailList = new ArrayList<>();
            for (int i = 0; i < oddInfoList.size(); i++) {
                OddInfoVO oddInfo = oddInfoList.get(i);
                BuckleDetail buckleDetail = new BuckleDetail();
                buckleDetail.setPkBuckleDetail(ModelCodeCons.NC_JD+String.valueOf(oddInfo.getId()));
                buckleDetail.setPkCorp(odd.getCropSourceId());
                buckleDetail.setPkProject(odd.getProjectSourceId());
                buckleDetail.setCsrcbId(String.valueOf(ModelCodeCons.NC_JD+oddInfo.getId()));
                buckleDetail.setDDeductDate("");
                buckleDetail.setBisSettle("N");
                buckleDetail.setCsrcId(String.valueOf(ModelCodeCons.NC_JD+odd.getId()));
                buckleDetail.setNsettlecount(oddInfo.getReviewNum());
                buckleDetail.setNsettleprice(oddInfo.getReviewPrice());
                buckleDetail.setNsettlesum(oddInfo.getReviewMny());
                buckleDetail.setPkContractA(odd.getContractId());
                buckleDetail.setVSettleCostItem(oddInfo.getName());
                buckleDetail.setReporter(odd.getCreateName());
                buckleDetail.setDmakedate(new SimpleDateFormat("yyyy-MM-dd").format(odd.getCreateDate()));
                buckleDetailList.add(buckleDetail);
            }
            logger.debug("buckleDetailList:" + buckleDetailList);
            List<OutContract> outContractList = new ArrayList<>();
            for (int i = 0; i < oddInfoList.size(); i++) {
                OddInfoVO oddInfo = oddInfoList.get(i);
                if (oddInfo.getOddRedirectEntities() != null && oddInfo.getOddRedirectEntities().size() > 0) {
                    for (int j = 0; j < oddInfo.getOddRedirectEntities().size(); j++) {
                        OutContract outContract = new OutContract();
                        OddRedirectVO oddRedirect = oddInfo.getOddRedirectEntities().get(j);
                        outContract.setPkOutContract(ModelCodeCons.NC_JD+String.valueOf(oddRedirect.getId()));
                        outContract.setPkContract(oddRedirect.getContractId());
                        outContract.setNDeductOriginMny(oddRedirect.getMny());
                        outContract.setPkCorp(odd.getCropSourceId());
                        outContract.setPkProject(odd.getProjectSourceId());
                        outContract.setCsrcbId(String.valueOf(ModelCodeCons.NC_JD+oddInfo.getId()));
                        outContract.setDDeductDate("");
                        outContract.setBisSettle("N");
                        outContract.setCsrcId(String.valueOf(ModelCodeCons.NC_JD+odd.getId()));
                        outContract.setReporter(odd.getCreateName());
                        outContract.setDmakedate(new SimpleDateFormat("yyyy-MM-dd").format(odd.getCreateDate()));
                        outContract.setDr(0);
                        outContractList.add(outContract);
                    }
                }
            }
            logger.debug("同步开始");
            buckleDetailService.batchInsert(buckleDetailList, outContractList);
            //buckleDetailService.insertOutContract(outContract);
        } catch (Exception e) {
            logger.error(e.toString());
            throw new BusinessException("零星用工插入NC库失败");
        }
        return true;
    }

}
