/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sync.service.impl;

import com.ejianc.business.sync.bean.BuckleDetail;
import com.ejianc.business.sync.bean.OutContract;
import com.ejianc.business.sync.mapper.BuckleDetailMapper;
import com.ejianc.business.sync.service.IBuckleDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BuckleDetailServiceImpl
extends BaseServiceImpl<BuckleDetailMapper, BuckleDetail>
implements IBuckleDetailService {
    @Autowired
    private BuckleDetailMapper baseMapper;

    @Override
    public boolean batchInsert(List<BuckleDetail> buckleDetailList, List<OutContract> outContractList) throws Exception {
        int i;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String ts = sdf.format(new Date());
        for (int j = 0; j < outContractList.size(); ++j) {
            OutContract outContract = outContractList.get(j);
            outContract.setTs(ts);
            this.baseMapper.insertOutContract(outContract);
        }
        for (i = 0; i < buckleDetailList.size(); ++i) {
            buckleDetailList.get(i).setTs(ts);
        }
        for (i = 0; i < buckleDetailList.size(); ++i) {
            this.baseMapper.delById(buckleDetailList.get(i).getPkBuckleDetail());
            this.baseMapper.batchInsert(buckleDetailList.get(i));
        }
        return true;
    }

    @Override
    public List selectStatus(Integer day, String cons) {
        return this.baseMapper.selectStatus(day, cons);
    }

    @Override
    public List select() {
        return this.baseMapper.select();
    }

    @Override
    public Integer getOutContract(String pkOdd) {
        return this.baseMapper.getOutContract("ST-" + pkOdd);
    }

    @Override
    public Integer getBuckleList(String pkOdd) {
        return this.baseMapper.getBuckleList("ST-" + pkOdd);
    }

    @Override
    public void delOutContract(String pkOdd) {
        this.baseMapper.delOutContract("ST-" + pkOdd);
    }

    @Override
    public void delBuckleList(String pkOdd) {
        this.baseMapper.delBuckleList("ST-" + pkOdd);
    }

    @Override
    public List selectRedirect(Integer day, String cons) {
        return this.baseMapper.selectRedirect(day, cons);
    }
}

