/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sync.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.sync.bean.BuckleDetail;
import com.ejianc.business.sync.bean.CmSubList;
import com.ejianc.business.sync.bean.OutContract;
import com.ejianc.business.sync.mapper.CmSubListMapper;
import com.ejianc.business.sync.service.IBuckleDetailService;
import com.ejianc.business.sync.service.ICmSubListService;
import com.ejianc.business.sync.vo.OddInfoVO;
import com.ejianc.business.sync.vo.OddRedirectVO;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.business.sync.vo.OddVO;
import com.ejianc.business.sync.vo.SyncOddInfoVO;
import com.ejianc.business.sync.vo.SyncOddVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CmSubListServiceImpl
extends BaseServiceImpl<CmSubListMapper, CmSubList>
implements ICmSubListService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${nc.sysOddInfo}")
    private String sysOddInfoUrl;
    @Autowired
    private IBuckleDetailService buckleDetailService;

    @Override
    public CommonResponse<OddVO> syncOdd(OddVO oddVO) {
        System.out.println("\u6765\u6e90\uff1a" + oddVO.getOddSource());
        this.logger.info("\u4e3b\u8868\u6765\u6e90\uff1a" + oddVO.getOddSource());
        if (oddVO.getOddSource() != null && oddVO.getOddSource() != 1) {
            this.logger.info("\u5148\u5f80NC\u6570\u636e\u5e93\u63d2\u5165\u624b\u52a8\u65b0\u589e\u7684\u6e05\u5355");
            oddVO = this.syncOddInfoToNc(oddVO);
        }
        this.syncCenterOdd(oddVO);
        return CommonResponse.success((String)"nc\u6570\u636e\u540c\u6b65\u6210\u529f\uff01", (Object)oddVO);
    }

    @Override
    public CommonResponse<OddSyncVo> updateNcFlag(Integer day) {
        this.logger.info("updateNcFlag\u5f00\u59cb");
        OddSyncVo vo = new OddSyncVo();
        List list = this.buckleDetailService.selectStatus(day, "ST-");
        ArrayList<Long> nlist = new ArrayList<Long>();
        ArrayList<Long> ylist = new ArrayList<Long>();
        for (int i = 0; i < list.size(); ++i) {
            if (null == ((Map)list.get(i)).get("PK_BUCKLEDETAIL")) continue;
            String pk = ((Map)list.get(i)).get("PK_BUCKLEDETAIL").toString().replaceAll("ST-", "");
            ((Map)list.get(i)).put("PK_BUCKLEDETAIL", pk);
            if (((Map)list.get(i)).get("BISSETTLE") != null && ((Map)list.get(i)).get("BISSETTLE").equals("Y")) {
                ylist.add(Long.valueOf(pk));
                continue;
            }
            if (((Map)list.get(i)).get("BISSETTLE") == null || !((Map)list.get(i)).get("BISSETTLE").equals("N")) continue;
            nlist.add(Long.valueOf(pk));
        }
        if (ylist != null && ylist.size() > 0) {
            vo.setYinfo(ylist);
        }
        if (nlist != null && nlist.size() > 0) {
            vo.setNinfo(nlist);
        }
        List rlist = this.buckleDetailService.selectRedirect(day, "ST-");
        ArrayList<Long> tlist = new ArrayList<Long>();
        ArrayList<Long> flist = new ArrayList<Long>();
        for (int i = 0; i < rlist.size(); ++i) {
            if (null == ((Map)rlist.get(i)).get("PK_OUTCONTRACT")) continue;
            String pk = ((Map)rlist.get(i)).get("PK_OUTCONTRACT").toString().replaceAll("ST-", "");
            ((Map)rlist.get(i)).put("PK_OUTCONTRACT", pk);
            if (((Map)rlist.get(i)).get("BISSETTLE") != null && ((Map)rlist.get(i)).get("BISSETTLE").equals("Y")) {
                tlist.add(Long.valueOf(pk));
                continue;
            }
            if (((Map)rlist.get(i)).get("BISSETTLE") == null || !((Map)rlist.get(i)).get("BISSETTLE").equals("N")) continue;
            flist.add(Long.valueOf(pk));
        }
        if (tlist != null && tlist.size() > 0) {
            vo.setYredirect(tlist);
        }
        if (flist != null && flist.size() > 0) {
            vo.setNredirect(flist);
        }
        this.logger.info("updateNcFlag\u56de\u53c2\uff1a" + JSONObject.toJSONString((Object)vo));
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f", (Object)vo);
    }

    @Override
    public CommonResponse<Boolean> syncFlag(Long id) {
        Integer getOutContract = this.buckleDetailService.getOutContract(String.valueOf(id));
        Integer getBuckleList = this.buckleDetailService.getBuckleList(String.valueOf(id));
        if (getOutContract > 0 || getBuckleList > 0) {
            this.logger.debug("\u6570\u636e\u5728NC\u5df2\u7ed3\u7b97\uff0c\u65e0\u6cd5\u5f03\u5ba1");
            return CommonResponse.success((String)"\u6570\u636e\u5728NC\u5df2\u7ed3\u7b97\uff0c\u65e0\u6cd5\u5f03\u5ba1", (Object)true);
        }
        this.logger.debug("\u6570\u636e\u5728NC\u672a\u7ed3\u7b97");
        return CommonResponse.success((String)"\u6570\u636e\u5728NC\u672a\u7ed3\u7b97\uff01", (Object)false);
    }

    @Override
    public CommonResponse<Boolean> delSync(Long id) {
        this.buckleDetailService.delOutContract(String.valueOf(id));
        this.buckleDetailService.delBuckleList(String.valueOf(id));
        return CommonResponse.success((String)"\u5220\u9664\u4e2d\u95f4\u8868\u6210\u529f\uff01", (Object)true);
    }

    @Override
    public CommonResponse<String> syncOddImport(OddVO oddVO) {
        System.out.println("\u6765\u6e90\uff1a" + oddVO.getOddSource());
        this.logger.info("\u4e3b\u8868\u6765\u6e90\uff1a" + oddVO.getOddSource());
        this.syncCenterOdd(oddVO);
        return CommonResponse.success((String)"nc\u6570\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> nameContain(OddVO oddVO) {
        List manualOddInfoList = oddVO.getOddInfoEntities();
        if (manualOddInfoList == null || manualOddInfoList.isEmpty()) {
            return null;
        }
        ArrayList<String> codeList = new ArrayList<String>();
        for (OddInfoVO info : manualOddInfoList) {
            if (info.getSourceType() != 1) continue;
            codeList.add(info.getCode());
        }
        if (CollectionUtils.isNotEmpty(codeList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(CmSubList::getPk_contract, (Object)oddVO.getContractId());
            queryWrapper.in(CmSubList::getVlistcode, codeList);
            if (this.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u8be5\u5355\u636e\u65b0\u589e\u6e05\u5355\u7f16\u7801\u5728\u5bf9\u5e94NC\u5408\u540c\u4e2d\u5df2\u5b58\u5728\uff01");
            }
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> codeContain(String pkContract, String pkAmountlist) {
        List codeList;
        this.logger.info("codeContain\u5f00\u59cb");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CmSubList::getPk_contract, (Object)pkContract);
        queryWrapper.eq(CmSubList::getPk_amountlist, (Object)pkAmountlist);
        List cmSubLists = ((CmSubListMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        this.logger.info("codeContain\u67e5\u8be2NC\u6e05\u5355\u8868\u7ed3\u679c\uff1a" + cmSubLists);
        if (CollectionUtils.isNotEmpty((Collection)cmSubLists) && (codeList = cmSubLists.stream().map(CmSubList::getVlistcode).collect(Collectors.toList())).size() != new HashSet(codeList).size()) {
            String repeatCode = codeList.stream().filter(code -> codeList.stream().filter(c -> c.equals(code)).count() > 1L).findFirst().get();
            return CommonResponse.error((String)("\u8be5\u5355\u636e\u65b0\u589e\u6e05\u5355\u7f16\u7801\u5728\u5bf9\u5e94NC\u5408\u540c\u4e2d\u5df2\u5b58\u5728\uff01\u91cd\u590d\u7f16\u7801\uff1a" + repeatCode));
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01");
    }

    private OddVO syncSubList(OddVO odd) {
        List manualOddInfoList = odd.getOddInfoEntities();
        if (manualOddInfoList == null || manualOddInfoList.isEmpty()) {
            return null;
        }
        ArrayList<CmSubList> toAddLists = new ArrayList<CmSubList>();
        CmSubList sublist = null;
        String pk_contract = odd.getContractId();
        String pk_corp = odd.getCropSourceId();
        for (OddInfoVO info : manualOddInfoList) {
            this.logger.debug("\u53ea\u63d2\u5165\u624b\u52a8\u65b0\u589e\u7684\u6e05\u5355");
            if (info.getSourceType() != 1) continue;
            sublist = new CmSubList();
            sublist.setBiscurrentlist("Y");
            String pkMeasdoc = ((CmSubListMapper)this.baseMapper).selectPkMeasdoc(info.getInfoUnit().trim());
            if (null != pkMeasdoc) {
                sublist.setPk_measdoc(pkMeasdoc);
            } else {
                sublist.setPk_measdoc("");
            }
            sublist.setDr(0);
            sublist.setTs(this.getTs());
            sublist.setPk_contract(pk_contract);
            String pkContractInfo = this.generateNCPK(pk_corp);
            sublist.setPk_sublist(pkContractInfo);
            info.setSourceId(pkContractInfo);
            String pkWbsdef = ((CmSubListMapper)this.baseMapper).selectPkWbs(pk_contract);
            if (StringUtils.isBlank((CharSequence)pkWbsdef)) {
                sublist.setPk_wbsdef(odd.getProjectSourceId());
            } else {
                sublist.setPk_wbsdef(pkWbsdef);
            }
            sublist.setIlistsource(2);
            sublist.setVlistcode(info.getCode());
            sublist.setVlistname(info.getName());
            sublist.setVmemo("\u8f7b\u91cf\u5316\u5e73\u53f0\u63a8\u9001");
            sublist.setNnum(info.getReviewNum());
            sublist.setNprice(info.getReviewPrice());
            sublist.setNfinishsumnum(info.getReviewNum());
            sublist.setNfinishsumoriginmny(info.getReviewPrice());
            sublist.setNtotaloriginmny(info.getReviewMny());
            sublist.setPk_amountlist(info.getPkAmountlist());
            sublist.setIattribute(0);
            sublist.setVreserve9(String.valueOf(odd.getId()));
            if (odd.getUseType().toString() == "1330815360484229121") {
                sublist.setV_type_b("14");
            } else if (odd.getUseType().toString() == "1330815434631135234") {
                sublist.setV_type_b("15");
            } else {
                sublist.setV_type_b("16");
            }
            sublist.setVdef5(info.getFirstApply().toString());
            toAddLists.add(sublist);
        }
        if (toAddLists != null && toAddLists.size() > 0) {
            super.saveBatch(toAddLists);
            ((CmSubListMapper)this.baseMapper).updateContractTs(pk_contract, this.getTs());
        }
        odd.setOddInfoEntities(manualOddInfoList);
        return odd;
    }

    private String generateNCPK(String pk_corp) {
        String uid = UUID.randomUUID().toString();
        uid = uid.replace("-", "");
        uid = uid.substring(0, 16);
        if (pk_corp == null) {
            pk_corp = "0001";
        }
        return pk_corp + uid;
    }

    private String getTs() {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    private boolean syncCenterOdd(OddVO odd) {
        this.logger.info("\u4e3b\u8868\u6570\u636eodd\uff1a" + odd);
        this.logger.info("\u63d2\u5165\u4e2d\u95f4\u8868\u5f00\u59cb");
        List oddInfoList = odd.getOddInfoEntities();
        try {
            ArrayList<BuckleDetail> buckleDetailList = new ArrayList<BuckleDetail>();
            for (int i = 0; i < oddInfoList.size(); ++i) {
                OddInfoVO oddInfo = (OddInfoVO)oddInfoList.get(i);
                BuckleDetail buckleDetail = new BuckleDetail();
                buckleDetail.setPkBuckleDetail("ST-" + String.valueOf(oddInfo.getId()));
                buckleDetail.setPkCorp(odd.getCropSourceId());
                buckleDetail.setPkProject(odd.getProjectSourceId());
                buckleDetail.setCsrcbId(String.valueOf("ST-" + oddInfo.getId()));
                buckleDetail.setPkSublist(oddInfo.getSourceId());
                buckleDetail.setDDeductDate("");
                buckleDetail.setBisSettle("N");
                buckleDetail.setCsrcId(String.valueOf("ST-" + odd.getId()));
                buckleDetail.setNsettlecount(oddInfo.getReviewNum());
                buckleDetail.setNsettleprice(oddInfo.getReviewPrice());
                buckleDetail.setNsettlesum(oddInfo.getReviewMny());
                buckleDetail.setPkContractA(odd.getContractId());
                buckleDetail.setVSettleCostItem(oddInfo.getName());
                buckleDetail.setReporter(odd.getCreateName());
                buckleDetail.setDmakedate(new SimpleDateFormat("yyyy-MM-dd").format(odd.getCreateDate()));
                buckleDetail.setPkContractB(StringUtils.isNotBlank((CharSequence)oddInfo.getSourceId()) ? oddInfo.getSourceId() : "ST-" + String.valueOf(oddInfo.getId()));
                buckleDetail.setDetailName(oddInfo.getName());
                buckleDetail.setDetailCode(oddInfo.getCode());
                buckleDetail.setVbillno(odd.getBillCode());
                this.logger.info("------ buckleDetail\u4e2d\u95f4\u8868\u5355\u636e\u7f16\u7801\uff1a" + buckleDetail.getVbillno());
                buckleDetailList.add(buckleDetail);
            }
            this.logger.info("buckleDetailList:" + buckleDetailList);
            ArrayList<OutContract> outContractList = new ArrayList<OutContract>();
            for (int i = 0; i < oddInfoList.size(); ++i) {
                OddInfoVO oddInfo = (OddInfoVO)oddInfoList.get(i);
                if (oddInfo.getOddRedirectEntities() == null || oddInfo.getOddRedirectEntities().size() <= 0) continue;
                for (int j = 0; j < oddInfo.getOddRedirectEntities().size(); ++j) {
                    OutContract outContract = new OutContract();
                    OddRedirectVO oddRedirect = (OddRedirectVO)oddInfo.getOddRedirectEntities().get(j);
                    outContract.setPkOutContract("ST-" + String.valueOf(oddRedirect.getId()));
                    outContract.setPkContract(oddRedirect.getContractId());
                    outContract.setNDeductOriginMny(oddRedirect.getMny());
                    outContract.setPkCorp(odd.getCropSourceId());
                    outContract.setPkProject(odd.getProjectSourceId());
                    outContract.setCsrcbId(String.valueOf("ST-" + oddInfo.getId()));
                    outContract.setDDeductDate("");
                    outContract.setBisSettle("N");
                    outContract.setCsrcId(String.valueOf("ST-" + odd.getId()));
                    outContract.setReporter(odd.getCreateName());
                    outContract.setDmakedate(new SimpleDateFormat("yyyy-MM-dd").format(odd.getCreateDate()));
                    outContract.setDr(0);
                    outContractList.add(outContract);
                }
            }
            this.logger.debug("\u540c\u6b65\u5f00\u59cb");
            this.buckleDetailService.batchInsert(buckleDetailList, outContractList);
        }
        catch (Exception e) {
            this.logger.info(e.toString());
            throw new BusinessException("\u96f6\u661f\u7528\u5de5\u63d2\u5165NC\u5e93\u5931\u8d25");
        }
        return true;
    }

    private OddVO syncOddInfoToNc(OddVO odd) {
        Map map;
        block16: {
            this.logger.info("\u8c03\u7528\u63a5\u53e3\u540c\u6b65\u4e3b\u8868\u6570\u636eodd\uff1a" + odd);
            SyncOddVO syncOddVO = new SyncOddVO();
            syncOddVO.setVtype("richiehe00001");
            List manualOddInfoList = odd.getOddInfoEntities();
            if (manualOddInfoList == null || manualOddInfoList.isEmpty()) {
                return null;
            }
            map = manualOddInfoList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
            ArrayList<SyncOddInfoVO> toAddLists = new ArrayList<SyncOddInfoVO>();
            String pk_contract = odd.getContractId();
            for (OddInfoVO info : manualOddInfoList) {
                if (info.getSourceType() != 1) continue;
                SyncOddInfoVO syncOddInfoVO = new SyncOddInfoVO();
                if (StringUtils.isNotBlank((CharSequence)info.getPkMeasdoc())) {
                    syncOddInfoVO.setPk_measdoc(info.getPkMeasdoc());
                } else {
                    String pkMeasdoc = ((CmSubListMapper)this.baseMapper).selectPkMeasdoc(info.getInfoUnit().trim());
                    if (null != pkMeasdoc) {
                        syncOddInfoVO.setPk_measdoc(pkMeasdoc);
                    } else {
                        syncOddInfoVO.setPk_measdoc("");
                    }
                }
                syncOddInfoVO.setPk_contract(pk_contract);
                syncOddInfoVO.setPk_qinglianghua(String.valueOf(info.getId()));
                syncOddInfoVO.setVlistcode(info.getCode());
                syncOddInfoVO.setVlistname(info.getName());
                syncOddInfoVO.setNnum(info.getReviewNum());
                syncOddInfoVO.setNprice(info.getReviewPrice());
                syncOddInfoVO.setNtotaloriginmny(info.getReviewMny());
                syncOddInfoVO.setPk_amountlist(info.getPkAmountlist());
                if (odd.getUseType().toString() == "1330815360484229121") {
                    syncOddInfoVO.setV_type_b("14");
                } else if (odd.getUseType().toString() == "1330815434631135234") {
                    syncOddInfoVO.setV_type_b("15");
                } else {
                    syncOddInfoVO.setV_type_b("16");
                }
                syncOddInfoVO.setVdef5(info.getFirstApply() != null ? info.getFirstApply().toString() : "2");
                toAddLists.add(syncOddInfoVO);
            }
            if (CollectionUtils.isNotEmpty(toAddLists)) {
                this.logger.info("\u5f85\u63d2\u5165\u6e05\u5355\uff1a" + JSONObject.toJSONString(toAddLists));
                syncOddVO.setData(toAddLists);
                try {
                    String back = HttpTookit.postByJson((String)this.sysOddInfoUrl, (String)JSONObject.toJSON((Object)syncOddVO).toString());
                    JSONObject jsonBack = JSONObject.parseObject((String)back);
                    this.logger.info("---\u56de\u53c2:" + jsonBack);
                    if ("0".equals(jsonBack.getString("code"))) {
                        JSONArray data = jsonBack.getJSONArray("data");
                        if (null != data) {
                            for (int i = 0; i < data.size(); ++i) {
                                JSONObject jsonObject = data.getJSONObject(i);
                                Long oddInfoId = jsonObject.getLong("pk_qinglianghua");
                                if (!map.containsKey(oddInfoId)) continue;
                                ((OddInfoVO)map.get(oddInfoId)).setSourceId(jsonObject.getString("pk_sublist"));
                            }
                        }
                        break block16;
                    }
                    throw new BusinessException(jsonBack.getString("message"));
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    throw new BusinessException(e.getMessage());
                }
            }
        }
        odd.setOddInfoEntities(new ArrayList(map.values()));
        return odd;
    }
}

