package com.ejianc.business.test.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.test.bean.TenderEntity;
import com.ejianc.business.test.service.IGraphTenderService;
import com.ejianc.business.test.service.ITenderService;
import com.ejianc.business.test.vo.ReportVO;
import com.ejianc.business.test.vo.TenderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 工程业绩实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("graphTender")
public class GraphTenderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITenderService tenderService;
    @Autowired
    private IGraphTenderService service;

    /**
     * @Description querySaBoard 查询指标
     * @param param
     */
    @RequestMapping(value = "/getBar4Period", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ReportVO>> getBar4Period(@RequestBody QueryParam param) {

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReportVO> res = service.getBar4Period(wrapper);
        return CommonResponse.success("查询详情数据成功！",res);
    }

    @RequestMapping(value = "/getPie4Corp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ReportVO>> getPie4Corp(@RequestBody QueryParam param) {

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReportVO> res = service.getPie4Corp(wrapper);
        return CommonResponse.success("查询详情数据成功！",res);
    }
}
