package com.ejianc.business.test.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.bpmana.api.IUserBApi;
import com.ejianc.business.bpmana.vo.UserRoleVO;
import com.ejianc.business.test.service.ISettingService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 工程业绩实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("setting")
public class SettingController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IUserBApi userBApi;

    @Autowired
    private ISettingService settingService;

    /**
     * @Description isUserListByTbyjgl 判断是否权限内用户
     * @param userId
     */
    @RequestMapping(value = "/isUserListByTbyjgl", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> isUserListByTbyjgl(Long userId) {
        List<Long> roleList = Arrays.asList(400686077121396769L);       // 投标业绩管理角色
        List<Long> orgList = Arrays.asList(1328246322863542273L);       // 根组织ID
        List<RoleUserRelationVO> roleUserRelationVOList = roleApi.getRoleUser(roleList, orgList).getData();
        List<Long> userIdList = roleUserRelationVOList.stream().map(RoleUserRelationVO::getUserId).collect(Collectors.toList());
        return CommonResponse.success("查询详情数据成功！",userIdList.contains(userId));
    }

    /**
     * @Description getRoleUserList 查询用户角色
     * @param param
     */
    @RequestMapping(value = "/getRoleUserList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserRoleVO>> getRoleUserList(@RequestBody QueryParam param) {

        List<Long> adminList = Arrays.asList(1328676492690853890L,      // 孙琪、肖子沐、孙雅琴、肖珂、刘骁
                                            1351212786989318145L,
                                            1328663385885118465L,
                                            1328680101516152833L,
                                            1328676480170856449L);       // 可以看到[权限设置]的用户
        if (!adminList.contains(InvocationInfoProxy.getUserid())) {
            return CommonResponse.error("当前用户无权限访问，仅限局统一分配用户！");
        }
        IPage<UserRoleVO> roleUserRelationVOList = userBApi.queryUserByRole(param.getPageIndex(), param.getPageSize(), param.getSearchText()).getData();
        return CommonResponse.success("查询详情数据成功！",roleUserRelationVOList);
    }

    /**
     * 更新业绩库的读写权限
     * @return @
     */
    @RequestMapping(value = "/updateUserAuth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> updateUserAuth(String userId, String status) {
        return userBApi.updateUserAuth(userId, status);
    }


}
