package com.ejianc.business.test.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.test.bean.TenderEntity;
import com.ejianc.business.test.service.ITenderService;
import com.ejianc.business.test.vo.ReportVO;
import com.ejianc.business.test.vo.TenderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 工程业绩实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("tender")
public class TenderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITenderService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description importSave 批量录入
     */
    @RequestMapping(value = "/saveBatchList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TenderVO> saveBatchList(@RequestBody List<TenderVO> tenderVOList) {
        service.saveBatch(BeanMapper.mapList(tenderVOList, TenderEntity.class));
    	return CommonResponse.success("保存数据成功！");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TenderVO> saveOrUpdate(@RequestBody TenderVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TenderVO> queryDetail(Long id) {
    	TenderEntity entity = service.selectById(id);
    	TenderVO vo = BeanMapper.map(entity, TenderVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TenderVO> vos) {
        service.updateStatus(vos);
//        service.removeByIds(vos.stream().map(TenderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TenderVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));

        IPage<TenderEntity> page = service.queryPage(param,false);
        IPage<TenderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download", method = RequestMethod.GET)
    @ResponseBody
    public void download(String param, HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        if (param.equals("fangjian")) {
            ImportTemplate.templetdownload(request, "fangjian_template.xlsx", "工程业绩库房建版块导入模板");
        } else if (param.equals("jijian")) {
            ImportTemplate.templetdownload(request, "jijian_template.xlsx", "工程业绩库基建版块导入模板");
        } else if (param.equals("sheji")) {
            ImportTemplate.templetdownload(request, "sheji_template.xlsx", "工程业绩库设计版块导入模板");
        } else {
            ImportTemplate.templetdownload(request, "tender-project-template.xlsx", "工程业绩库导入模板");
        }
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TenderEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Tender-export.xlsx", beans, response);
    }

    /**
     * @Description getSumIndex 获取汇总指标数据
     * @Param [ids]
     */
    @RequestMapping(value = "/getSumIndex", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReportVO> getSumIndex(@RequestBody QueryParam param) {

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        ReportVO reportVO = service.getSumIndex(wrapper);
        return CommonResponse.success("查询成功！", reportVO);
    }

    /**
     * @Description getDeleteList
     * @param queryParam
     */
    @RequestMapping(value = "/queryRepeatList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TenderVO>> queryRepeatList(@RequestBody QueryParam queryParam) {
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        Page<TenderVO> page = new Page<>((long) queryParam.getPageIndex(), (long) queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<TenderVO> tenderVOList = service.queryRepeatList(wrapper);
        JSONObject res = new JSONObject();
        res.put("records", tenderVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询详情数据成功！", tenderVOList);
    }

    /**
     * @Description getDeleteList
     * @param param
     */
    @RequestMapping(value = "/queryDeleteList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TenderVO>> queryDeleteList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Page<TenderEntity> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        LambdaQueryWrapper<TenderEntity> queryWrapper = Wrappers.<TenderEntity>lambdaQuery();
        queryWrapper.eq(TenderEntity::getStatus, 1);
        IPage<TenderEntity> entityPage = service.page(page, queryWrapper);
        IPage<TenderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(entityPage.getRecords(), TenderVO.class));
        return CommonResponse.success("查询详情数据成功！", pageData);
    }

    /**
     * @Description recoveryDeleteList
     * @param vos
     */
    @RequestMapping(value = "/recoveryDeleteList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> recoveryDeleteList(@RequestBody List<TenderVO> vos) {
        boolean flag = service.recoveryDeleteList(vos);
        return CommonResponse.success("恢复删除工程业绩成功！", flag);
    }


}
