package com.ejianc.business.test.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.test.bean.TenderEntity;
import com.ejianc.business.test.mapper.TenderMapper;
import com.ejianc.business.test.service.ITenderService;
import com.ejianc.business.test.vo.ReportVO;
import com.ejianc.business.test.vo.TenderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 工程业绩实体
 * 
 * @author generator
 * 
 */
@Service("tenderService")
public class TenderServiceImpl extends BaseServiceImpl<TenderMapper, TenderEntity> implements ITenderService{

    private static final String TENDER_PROJECT_BILL_CODE = "CSCEC5B_TENDER_PROJECT";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;

    @Override
    public TenderVO saveOrUpdate(TenderVO saveOrUpdateVO) {

        /** 租户隔离 */
        Long tenantId = InvocationInfoProxy.getTenantid();

        if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(TENDER_PROJECT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }
        TenderEntity entity = BeanMapper.map(saveOrUpdateVO, TenderEntity.class);
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, TenderVO.class);
    }

    @Override
    public Boolean updateStatus(List<TenderVO> vos) {

        List<Long> ids = vos.stream().map(TenderVO::getId).collect(Collectors.toList());
        LambdaUpdateWrapper<TenderEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(TenderEntity::getId, ids);
        updateWrapper.set(TenderEntity::getStatus, 1);
//        updateWrapper.set(TenderEntity::getDr, 0);
        return update(updateWrapper);
    }

    @Override
    public Boolean recoveryDeleteList(List<TenderVO> vos) {

        List<Long> ids = vos.stream().map(TenderVO::getId).collect(Collectors.toList());
        LambdaUpdateWrapper<TenderEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(TenderEntity::getId, ids);
        updateWrapper.set(TenderEntity::getStatus, 0);
//        updateWrapper.set(TenderEntity::getDr, 0);
        return update(updateWrapper);
    }

    @Override
    public List<TenderVO> queryRepeatList(QueryWrapper queryWrapper) {
        List<TenderVO> tenderList = new ArrayList<TenderVO>();
        List<String> projNameList = baseMapper.getProjNameList(queryWrapper);
        for (int i=0;  i < projNameList.size() ; i++) {
            List<TenderVO> a = baseMapper.getRepeatList(projNameList.get(i));
            tenderList.addAll(a);
        }
        return tenderList;
    }

    @Override
    public ReportVO getSumIndex(QueryWrapper queryWrapper) {
        return baseMapper.getSumIndex(queryWrapper);
    }
}
