package com.ejianc.business.wzxt.api;

import com.ejianc.business.wzxt.hystrix.CheckHystrix;
import com.ejianc.business.wzxt.vo.CheckRestVO;
import com.ejianc.business.wzxt.vo.InstoreVO;
import com.ejianc.business.wzxt.vo.MaterialInRefVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 获取合同参照工厂类方法（外部接口弃用此API）
 *
 * @author yqls
 *
 */
@FeignClient(name= "cscec5b-wzxt-web", url="${common.env.feign-client-url}", path="cscec5b-wzxt-web", fallback = CheckHystrix.class)
//@FeignClient(name= "ejc-wzxt-web", url="${common.env.feign-client-url}", path="ejc-wzxt-web", configuration = {KeepErrMsgConfiguration.class})
public interface ICheckApi {

	/**
	 * 查询未引用验收单参照
	 * @param projectSourceId	水电八局项目主键
	 * @return
	 */
	@GetMapping(value = "/api/check/queryCheckRef")
	public CommonResponse<CheckRestVO> queryCheckRef(
			@RequestParam(value = "projectSourceId", required=false) String projectSourceId);

	/**
	 * 修改验收单引用状态
	 * @param instoreVOList
	 * @return
	 */
	@PostMapping(value = "/api/check/updateUseState")
	public CommonResponse<Boolean> updateUseState(@RequestBody List<InstoreVO> instoreVOList);

	/**
	 * 回写入库单数量
	 * @param instoreVOList
	 * @return
	 */
	@PostMapping(value = "/api/check/updateInstoreNum")
	public CommonResponse<Boolean> updateInstoreNum(@RequestBody List<InstoreVO> instoreVOList);


	/**
	 * 查询项目下累计验收数量
	 * @param projectId	项目主键
	 * @return
	 */
	@GetMapping(value = "/api/check/queryInMaterial")
	public CommonResponse<List<MaterialInRefVO>> queryInMaterial(@RequestParam Long projectId);

}
