package com.ejianc.business.wzxt.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 材料管控变更表
 * 
 * @author generator
 * 
 */
public class MateriaControlChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectSourceId; // 项目来源ID
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgSourceId; // 组织来源ID
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织
    private String parentOrgSourceId; // 上级组织来源ID
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Integer billState; // 单据状态（审批必须字段）
    private Integer versionNumber; // 版本号
    private BigDecimal totalMoney; // 总金额
    private BigDecimal remindValue; // 提醒阈值
    private BigDecimal constraintValue; // 强制阈值
    private String memo; // 备注
    private Integer changeState; // 变更状态
    private Long curChangingReviewId; // 当前对应的变更版本id
    private Long materialControlId; // 变更前id
    private Integer isEffect; // 是否生效 0未生效 1 已生效
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date compileDate; // 编制日期
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getVersionNumber() {
        return versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }
    public BigDecimal getTotalMoney() {
        return totalMoney;
    }

    public void setTotalMoney(BigDecimal totalMoney) {
        this.totalMoney = totalMoney;
    }

    public BigDecimal getRemindValue() {
        return remindValue;
    }

    public void setRemindValue(BigDecimal remindValue) {
        this.remindValue = remindValue;
    }

    public BigDecimal getConstraintValue() {
        return constraintValue;
    }

    public void setConstraintValue(BigDecimal constraintValue) {
        this.constraintValue = constraintValue;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Long getCurChangingReviewId() {
        return curChangingReviewId;
    }

    public void setCurChangingReviewId(Long curChangingReviewId) {
        this.curChangingReviewId = curChangingReviewId;
    }
    public Integer getIsEffect() {
        return isEffect;
    }

    public void setIsEffect(Integer isEffect) {
        this.isEffect = isEffect;
    }
    public Date getCompileDate() {
        return compileDate;
    }

    public void setCompileDate(Date compileDate) {
        this.compileDate = compileDate;
    }

    public Long getMaterialControlId() {
        return materialControlId;
    }

    public void setMaterialControlId(Long materialControlId) {
        this.materialControlId = materialControlId;
    }
}
