package com.ejianc.business.wzxt.api;

import com.ejianc.business.wzxt.hystrix.CoordinationSetHystrix;
import com.ejianc.business.wzxt.vo.CoordinationSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 获取合同参照工厂类方法（外部接口弃用此API）
 *
 * @author yqls
 *
 */
@FeignClient(name= "cscec5b-wzxt-web", url="${common.env.feign-client-url}", path="cscec5b-wzxt-web", fallback = CoordinationSetHystrix.class)
public interface ICoordinationSetApi {

	/**
	 * 查询传入组织最近的开启“废旧物资是否可以直接新增和参照申请单做废旧出场”为“是”的详情
	 * @param orgId	组织主键
	 * @return
	 */
	@GetMapping(value = "/api/coordinationSet/queryCoordinationSet")
	CommonResponse<CoordinationSetVO> queryCoordinationSet(@RequestParam Long orgId);
}
