package com.ejianc.business.wzxt.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 使用计划实体
 *
 * @author generator
 *
 */
public class PlanDetailRefSplitVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long parentId; // parent_id
    private Long tid;
    private String billCode;
    private String planName; // 使用计划名称
    private String planBillCode; // 计划编码
    private String planEmployeeName;//经办人
    private Long planDetailId;//子表明细

    private String billStateName; // 单据名称
    private Long projectId; // 项目
    private Long materialId; // 物资主键
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 计划使用日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 创建日期
    private String construction; // 施工部位
    private String memo; // 备注
    private String materialName; // 物资名称
    private Integer billState; // 单据状态（审批必须字段）
    private Long planId; // 主表主键ID
    private Long materialTypeId; // 物资类别
    private String materialTypeName; // 物资类别名称
    private String materialCode; // 物料编码
    private String unit; // 单位
    private String spec; // 规格型号
    private BigDecimal planNumsSum; // 需求数量
    private BigDecimal occupyNums; // 占用数量
    private BigDecimal surplusNumsSum; // 剩余数量
    private BigDecimal orderNumsSum; // 订单数量
    private String materialSourceId; // 物资来源主键
    private String def1; // 自定义字段
    private String def2; // 自定义字段
    private String def3; // 自定义字段
    private String def4; // 自定义字段
    private String def5; // 自定义字段

    private String sourceName; // 来源

    private String smartStatus;//智能称重标识
    private String originSmartStatus;//智能称重标识
    private Integer sourceType; //
    private String width; // 宽度
    private String height; // 高度
    private String length; // 长度
    private String surface; // 表面处理
    private String color; // 颜色
    private String colorNumber; // 色号
    private String textureMaterial; // 材质状态
    private String wallThickness; // 壁厚要求
    private String buildingNumber; // 栋号

    private String realUnitId; // 实物单位id
    private String realUnitName; // 实物单位名称
    private BigDecimal realTransScale; // 实物单位转换系数
    private BigDecimal realNum; // 实物数量
    private BigDecimal surplusRealNums; // 剩余实物数量
    private BigDecimal planRealNums; // 计划实物数量

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getWidth() {
        return width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getLength() {
        return length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getSurface() {
        return surface;
    }

    public void setSurface(String surface) {
        this.surface = surface;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getColorNumber() {
        return colorNumber;
    }

    public void setColorNumber(String colorNumber) {
        this.colorNumber = colorNumber;
    }

    public String getTextureMaterial() {
        return textureMaterial;
    }

    public void setTextureMaterial(String textureMaterial) {
        this.textureMaterial = textureMaterial;
    }

    public String getWallThickness() {
        return wallThickness;
    }

    public void setWallThickness(String wallThickness) {
        this.wallThickness = wallThickness;
    }

    public String getBuildingNumber() {
        return buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getMaterialSourceId() {
        return materialSourceId;
    }

    public void setMaterialSourceId(String materialSourceId) {
        this.materialSourceId = materialSourceId;
    }

    public String getSmartStatus() {
        return smartStatus;
    }

    public void setSmartStatus(String smartStatus) {
        this.smartStatus = smartStatus;
    }

    public String getOriginSmartStatus() {
        return originSmartStatus;
    }

    public void setOriginSmartStatus(String originSmartStatus) {
        this.originSmartStatus = originSmartStatus;
    }

    public BigDecimal getOrderNumsSum() {
        return orderNumsSum;
    }

    public void setOrderNumsSum(BigDecimal orderNumsSum) {
        this.orderNumsSum = orderNumsSum;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }


    public BigDecimal getOccupyNums() {
        return occupyNums;
    }

    public void setOccupyNums(BigDecimal occupyNums) {
        this.occupyNums = occupyNums;
    }

    public BigDecimal getPlanNumsSum() {
        return planNumsSum;
    }

    public void setPlanNumsSum(BigDecimal planNumsSum) {
        this.planNumsSum = planNumsSum;
    }

    public BigDecimal getSurplusNumsSum() {
        return surplusNumsSum;
    }

    public void setSurplusNumsSum(BigDecimal surplusNumsSum) {
        this.surplusNumsSum = surplusNumsSum;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    // 设备明细子表
    private List<PlanDetailVO> planDetail = new ArrayList<>();

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 使用计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 使用计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public String getPlanBillCode() {
        return planBillCode;
    }

    public void setPlanBillCode(String planBillCode) {
        this.planBillCode = planBillCode;
    }

    public String getPlanEmployeeName() {
        return planEmployeeName;
    }

    public void setPlanEmployeeName(String planEmployeeName) {
        this.planEmployeeName = planEmployeeName;
    }

    public Long getPlanDetailId() {
        return planDetailId;
    }

    public void setPlanDetailId(Long planDetailId) {
        this.planDetailId = planDetailId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 计划使用日期
     */
    public Date getPlanDate() {
        return planDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public List<PlanDetailVO> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<PlanDetailVO> planDetail) {
        this.planDetail = planDetail;
    }

    public String getRealUnitId() {
        return realUnitId;
    }

    public void setRealUnitId(String realUnitId) {
        this.realUnitId = realUnitId;
    }

    public String getRealUnitName() {
        return realUnitName;
    }

    public void setRealUnitName(String realUnitName) {
        this.realUnitName = realUnitName;
    }

    public BigDecimal getRealTransScale() {
        return realTransScale;
    }

    public void setRealTransScale(BigDecimal realTransScale) {
        this.realTransScale = realTransScale;
    }

    public BigDecimal getRealNum() {
        return realNum;
    }

    public void setRealNum(BigDecimal realNum) {
        this.realNum = realNum;
    }

    public BigDecimal getSurplusRealNums() {
        return surplusRealNums;
    }

    public void setSurplusRealNums(BigDecimal surplusRealNums) {
        this.surplusRealNums = surplusRealNums;
    }

    public BigDecimal getPlanRealNums() {
        return planRealNums;
    }

    public void setPlanRealNums(BigDecimal planRealNums) {
        this.planRealNums = planRealNums;
    }
}
