package com.ejianc.business.wzxt.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.wzxt.vo.ReviewDetailVO;

/**
 * 复核实体
 * 
 * @author generator
 * 
 */
@ApiModel("复核实体")
public class ReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目来源ID")
    private String projectSourceId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织来源ID")
    private String orgSourceId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("上级组织")
    private Long parentOrgId;
    @ApiModelProperty("上级组织来源ID")
    private String parentOrgSourceId;
    @ApiModelProperty("复核人")
    private Long employeeId;
    @ApiModelProperty("复核人名称")
    private String employeeName;
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @ApiModelProperty("编制日期")
    private Date createDate;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("变更状态")
    private Integer changeState;
    @ApiModelProperty("当前对应的变更计划Id")
    private Long changeId;
    @ApiModelProperty("创建人名称")
    private String createUserName;
    @ApiModelProperty("修改人名称")
    private String modifyUserName;
    @ApiModelProperty("生效日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;
    @ApiModelProperty("变更版本")
    private Integer changeVersion;
    
    @ApiModelProperty("复核详情实体")
    private List<ReviewDetailVO> reviewDetailList = new ArrayList<>();
    private List<ReviewChangeHisVO> reviewChangeHisList = new ArrayList<>();
    @TableField(value="commit_date")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private java.util.Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="cur_changing_review_id")
    private Long curChangingReviewId; // 当前对应的变更用量复核Id
    @TableField(value="description")
    private String description; // 说明
    private String billStateName; //
    private String changeStateName; //

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<ReviewChangeHisVO> getReviewChangeHisList() {
        return reviewChangeHisList;
    }

    public void setReviewChangeHisList(List<ReviewChangeHisVO> reviewChangeHisList) {
        this.reviewChangeHisList = reviewChangeHisList;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getCurChangingReviewId() {
        return curChangingReviewId;
    }

    public void setCurChangingReviewId(Long curChangingReviewId) {
        this.curChangingReviewId = curChangingReviewId;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 项目来源ID
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源ID
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源ID
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源ID
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 上级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 上级组织来源ID
     */
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    /**
     * 上级组织来源ID
     */
    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    /**
     * 复核人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 复核人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 复核人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 复核人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 变更状态
     */
    public Integer getChangeState() {
        return changeState;
    }

    /**
     * 变更状态
     */
    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    /**
     * 当前对应的变更计划Id
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 当前对应的变更计划Id
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 创建人名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 修改人名称
     */
    public String getModifyUserName() {
        return modifyUserName;
    }

    /**
     * 修改人名称
     */
    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    /**
     * 生效日期
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
     /**
      * 复核详情实体
      */
      public List<ReviewDetailVO> getReviewDetailList() {
         return reviewDetailList;
      }
     /**
      * 复核详情实体
      */
     public void setReviewDetailList(List<ReviewDetailVO> reviewDetailList) {
         this.reviewDetailList = reviewDetailList;
     }
}
