/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.mapper.PlanMapper;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.PlanDetailRefVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanMaterialVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="planService")
public class PlanServiceImpl
extends BaseServiceImpl<PlanMapper, PlanEntity>
implements IPlanService {
    private static final String WZXT_PLAN_BILL_CODE = "CSCEC5B_WZXT_PLAN";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IOrgApi orgApi;
    @Value(value="${mro.addr}")
    private String addr;
    @Autowired
    private ThirdSystemUtils thirdSystemUtils;
    @Autowired
    private IProjectConfigureService projectConfigureService;

    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO planVO) {
        CommonResponse orgParentVo = this.orgApi.getOneById(planVO.getParentOrgId());
        if (!orgParentVo.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u8be6\u60c5\u5931\u8d25\uff01");
        }
        planVO.setParentOrgSourceId(((OrgVO)orgParentVo.getData()).getSourceId());
        planVO.setPlanFlag("1");
        planVO.setUseState(Integer.valueOf(0));
        planVO.setHistoryFlag(Boolean.valueOf(false));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)planVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_PLAN_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                planVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        PlanEntity entity = (PlanEntity)((Object)BeanMapper.map((Object)planVO, PlanEntity.class));
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        String materialName = "";
        if (planDetail != null && planDetail.size() > 0) {
            for (PlanDetailEntity applyDetailEntity : planDetail) {
                materialName = materialName + applyDetailEntity.getMaterialName() + ",";
                if (applyDetailEntity.getNums() == null) continue;
                BigDecimal nums = applyDetailEntity.getNums() == null ? BigDecimal.ZERO : applyDetailEntity.getNums();
                BigDecimal occupyNums = applyDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : applyDetailEntity.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                applyDetailEntity.setSurplusNums(surplusNums);
                applyDetailEntity.setOccupyNums(occupyNums);
                applyDetailEntity.setNums(nums);
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        this.planService.saveOrUpdate((Object)entity, false);
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper queryWrapper) {
        List<PlanDetailRefVO> planVOList = ((PlanMapper)this.baseMapper).getPlanByMaterialId(materialListId, queryWrapper);
        return planVOList;
    }

    @Override
    public CommonResponse<String> pushToMro(Long billId) {
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(billId));
        if (MaterialTypeEnum.MRO.getCode().equals(planEntity.getMaterialType())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ProjectConfigureEntity::getProjectId, (Object)planEntity.getProjectId());
            ProjectConfigureEntity configureEntity = (ProjectConfigureEntity)((Object)this.projectConfigureService.getOne((Wrapper)queryWrapper, false));
            if (null == configureEntity) {
                throw new BusinessException("\u8be5\u9879\u76ee\u672a\u5173\u8054MRO\u9879\u76ee");
            }
            SyncMroPlanVO syncMroPlanVO = this.changePlanToMro(planEntity, configureEntity);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.thirdSystemUtils.getMroSign(headers);
            String mroUrl = this.addr + "/iec/v1/purchase_plan/save";
            try {
                this.logger.info("\u63a8\u9001MRO\u5b9e\u4f53" + JSONObject.toJSON((Object)syncMroPlanVO).toString());
                this.logger.info("\u63a8\u9001MRO\u5934\u90e8" + JSONObject.toJSONString(headers));
                String responseStr = HttpTookit.postByJson(mroUrl, JSONObject.toJSON((Object)syncMroPlanVO).toString(), headers);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                this.logger.info("\u63a8\u9001MRO\u7ed3\u679c" + json.toJSONString());
                if (200 != json.getInteger("code") || !json.getBoolean("success").booleanValue()) {
                    this.logger.info(json.toJSONString());
                    throw new BusinessException("\u63a8\u9001MRO\u5931\u8d25\uff0c" + json.get((Object)"message"));
                }
                String mroId = json.getString("data");
                planEntity.setHistoryId(mroId);
                planEntity.setHistorySystem("MRO");
                this.planService.saveOrUpdate((Object)planEntity);
            }
            catch (Exception e) {
                this.logger.info("\u5f02\u5e38" + e.getMessage());
                throw new BusinessException(e.getMessage());
            }
        }
        return CommonResponse.success();
    }

    private SyncMroPlanVO changePlanToMro(PlanEntity planEntity, ProjectConfigureEntity configureEntity) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+0800");
        SyncMroPlanVO syncMroPlanVO = new SyncMroPlanVO();
        syncMroPlanVO.setCode(planEntity.getBillCode());
        syncMroPlanVO.setProjectId(Long.valueOf(configureEntity.getMroProjectSourceId()));
        syncMroPlanVO.setStatus("ON");
        syncMroPlanVO.setThirdId(planEntity.getId().toString());
        syncMroPlanVO.setDescription(planEntity.getMemo());
        syncMroPlanVO.setCreatedAt(sdf.format(planEntity.getCreateDate()));
        if (null != planEntity.getUpdateTime()) {
            syncMroPlanVO.setUpdatedAt(sdf.format(planEntity.getUpdateTime()));
        }
        if (CollectionUtils.isNotEmpty(planEntity.getPlanDetail())) {
            ArrayList syncMroPlanDetailVOS = new ArrayList();
            planEntity.getPlanDetail().forEach(detail -> {
                SyncMroPlanMaterialVO syncMaterialVO = new SyncMroPlanMaterialVO();
                syncMaterialVO.setCode(detail.getMaterialCode());
                syncMaterialVO.setName(detail.getMaterialName());
                syncMaterialVO.setSpecification(detail.getSpec());
                syncMaterialVO.setUnit(detail.getUnit());
                syncMaterialVO.setThirdId(detail.getMaterialId().toString());
                SyncMroPlanDetailVO syncDetailVO = new SyncMroPlanDetailVO();
                syncDetailVO.setTotalCount(detail.getNums());
                syncDetailVO.setDescription(detail.getMemo());
                syncDetailVO.setThirdId(detail.getId().toString());
                syncDetailVO.setMaterial(syncMaterialVO);
                syncMroPlanDetailVOS.add(syncDetailVO);
            });
            syncMroPlanVO.setDetails(syncMroPlanDetailVOS);
        }
        return syncMroPlanVO;
    }
}

