/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.mapper.WeighMapper;
import com.ejianc.business.wzxt.service.IWeighDetailService;
import com.ejianc.business.wzxt.service.IWeighService;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighInfoVO;
import com.ejianc.business.wzxt.vo.WeighVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weighService")
public class WeighServiceImpl
extends BaseServiceImpl<WeighMapper, WeighEntity>
implements IWeighService {
    @Autowired
    private IWeighDetailService weighDetailService;

    @Override
    public CommonResponse<WeighVO> getWeighByProjectDepartmentId(Long projectDepartmentId) {
        LambdaQueryWrapper queryWrapperWeigh = Wrappers.lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, (Object)projectDepartmentId);
        WeighEntity weigh = (WeighEntity)((Object)super.getOne((Wrapper)queryWrapperWeigh));
        if (weigh != null) {
            WeighVO vo = (WeighVO)BeanMapper.map((Object)((Object)weigh), WeighVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @Override
    public List<WeighDetailVO> getMaterialByOrgId(WeighInfoVO weighInfoVO) {
        WeighDetailVO weighDetailVO;
        List materialIds = weighInfoVO.getMaterialIds();
        ArrayList<Long> materialIdProjectOpen = new ArrayList<Long>();
        ArrayList<Long> materialIdOrgOpen = new ArrayList<Long>();
        ArrayList<WeighDetailVO> weighDetailVOList = new ArrayList<WeighDetailVO>();
        LambdaQueryWrapper queryWrapperWeigh = Wrappers.lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, (Object)weighInfoVO.getProjectDepartmentId());
        queryWrapperWeigh.eq(WeighEntity::getWeighFlag, (Object)"1");
        WeighEntity weigh = (WeighEntity)((Object)super.getOne((Wrapper)queryWrapperWeigh));
        if (weigh != null) {
            LambdaQueryWrapper queryWrapperWeighDetail = Wrappers.lambdaQuery();
            queryWrapperWeighDetail.eq(WeighDetailEntity::getOrgId, (Object)weighInfoVO.getProjectDepartmentId());
            List weighDetailEntityList = this.weighDetailService.list((Wrapper)queryWrapperWeighDetail);
            if (weighDetailEntityList != null && weighDetailEntityList.size() > 0) {
                for (Long materialId : materialIds) {
                    for (WeighDetailEntity weighDetailEntity : weighDetailEntityList) {
                        if (!weighDetailEntity.getMaterialId().equals(materialId)) continue;
                        weighDetailVO = new WeighDetailVO();
                        weighDetailVO.setWeighFlag(weighDetailEntity.getWeighFlag());
                        weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                        weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                        weighDetailVOList.add(weighDetailVO);
                        materialIdProjectOpen.add(materialId);
                    }
                }
            }
            materialIds.removeAll(materialIdProjectOpen);
        }
        LambdaQueryWrapper queryWrapperWeighDetailOrg = Wrappers.lambdaQuery();
        queryWrapperWeighDetailOrg.eq(WeighDetailEntity::getOrgId, (Object)weighInfoVO.getOrgId());
        List weighDetailEntityOrgList = this.weighDetailService.list((Wrapper)queryWrapperWeighDetailOrg);
        if (weighDetailEntityOrgList != null && weighDetailEntityOrgList.size() > 0) {
            for (Long materialId : materialIds) {
                for (WeighDetailEntity weighDetailEntity : weighDetailEntityOrgList) {
                    if (!weighDetailEntity.getMaterialId().equals(materialId)) continue;
                    weighDetailVO = new WeighDetailVO();
                    weighDetailVO.setWeighFlag(weighDetailEntity.getWeighFlag());
                    weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                    weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                    weighDetailVOList.add(weighDetailVO);
                    materialIdOrgOpen.add(materialId);
                }
            }
        }
        materialIds.removeAll(materialIdOrgOpen);
        if (materialIds != null && materialIds.size() > 0) {
            for (Long materialId : materialIds) {
                WeighDetailVO weighDetailVO2 = new WeighDetailVO();
                weighDetailVO2.setWeighFlag("0");
                weighDetailVO2.setMaterialId(materialId);
                weighDetailVOList.add(weighDetailVO2);
            }
        }
        return weighDetailVOList;
    }
}

