/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.YzMaterialEntity;
import com.ejianc.business.wzxt.mapper.YzMaterialMapper;
import com.ejianc.business.wzxt.service.IYzMaterialService;
import com.ejianc.business.wzxt.util.MathUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="yzMaterialService")
public class YzMaterialServiceImpl
extends BaseServiceImpl<YzMaterialMapper, YzMaterialEntity>
implements IYzMaterialService {
    @Override
    public boolean saveList(List<CheckDetailEntity> checkList) {
        ArrayList<YzMaterialEntity> list = new ArrayList<YzMaterialEntity>();
        for (CheckDetailEntity detail : checkList) {
            QueryParam queryParamn = new QueryParam();
            queryParamn.getParams().put("yzMaterialCode", new Parameter("eq", (Object)detail.getYzMaterialCode()));
            List yzMaterialEntityList = this.queryList(queryParamn);
            YzMaterialEntity yzMaterialEntity = yzMaterialEntityList.size() > 0 ? (YzMaterialEntity)((Object)yzMaterialEntityList.get(0)) : new YzMaterialEntity();
            yzMaterialEntity.setYzMaterialCode(detail.getYzMaterialCode());
            yzMaterialEntity.setYzMaterialName(detail.getYzMaterialName());
            yzMaterialEntity.setMaterialId(detail.getMaterialId());
            yzMaterialEntity.setMaterialName(detail.getMaterialName());
            yzMaterialEntity.setMaterialCode(detail.getMaterialCode());
            yzMaterialEntity.setSpec(detail.getSpec());
            yzMaterialEntity.setYzUnit(detail.getYzUnit());
            yzMaterialEntity.setYzCheckNumsSum(detail.getYzCheckNumsSum());
            BigDecimal checkNumsSum = detail.getCheckNumsSum();
            BigDecimal yzCheckNumsSum = detail.getYzCheckNumsSum();
            BigDecimal divide = MathUtil.safeDiv(checkNumsSum, yzCheckNumsSum);
            yzMaterialEntity.setCoefficient(divide);
            list.add(yzMaterialEntity);
        }
        return this.saveOrUpdateBatch(list);
    }

    @Override
    public YzMaterialEntity queryMaterialIdByYzCode(String mateSysNo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(YzMaterialEntity::getYzMaterialCode, (Object)mateSysNo);
        List list = this.list((Wrapper)queryWrapper);
        return CollectionUtils.isNotEmpty((Collection)list) ? (YzMaterialEntity)((Object)list.get(0)) : null;
    }
}

