/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.ProjectWbsEntity;
import com.ejianc.business.wzxt.mapper.ProjectWbsMapper;
import com.ejianc.business.wzxt.service.IProjectWbsService;
import com.ejianc.business.wzxt.util.ExcelImportUtil;
import com.ejianc.business.wzxt.vo.ProjectWbsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="projectWbsService")
public class ProjectWbsServiceImpl
extends BaseServiceImpl<ProjectWbsMapper, ProjectWbsEntity>
implements IProjectWbsService {
    @Autowired
    private IProjectWbsService service;

    @Override
    public CommonResponse<ProjectWbsVO> saveOrUpdate(ProjectWbsVO projectWbsVO) {
        ProjectWbsEntity entity = new ProjectWbsEntity();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("code", new Parameter("eq", (Object)projectWbsVO.getCode()));
        param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        param.getParams().put("projectId", new Parameter("eq", (Object)projectWbsVO.getProjectId()));
        List projectWbsEntities = this.service.queryList(param);
        if (null != projectWbsVO.getId()) {
            entity = (ProjectWbsEntity)((Object)this.service.getById(projectWbsVO.getId()));
            if (!entity.getCode().equals(projectWbsVO.getCode()) && CollectionUtils.isNotEmpty((Collection)projectWbsEntities)) {
                return CommonResponse.error((String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            param.getParams().remove("code");
            param.getParams().put("parentId", new Parameter("eq", (Object)entity.getId()));
            List<ProjectWbsEntity> projectWbsEntityList = this.getChildrenByPid(entity.getId());
            for (ProjectWbsEntity projectWbsEntity : projectWbsEntityList) {
                projectWbsEntity.setEnabled(projectWbsVO.getEnabled());
            }
            for (ProjectWbsEntity projectWbsEntity : projectWbsEntityList) {
                if (!projectWbsEntity.getId().equals(entity.getId())) continue;
                projectWbsEntityList.remove((Object)projectWbsEntity);
                break;
            }
            if (CollectionUtils.isNotEmpty(projectWbsEntityList)) {
                this.saveOrUpdateBatch(projectWbsEntityList);
            }
        } else {
            if (CollectionUtils.isNotEmpty((Collection)projectWbsEntities)) {
                return CommonResponse.error((String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            entity.setId(IdWorker.getId());
        }
        entity.setParentId(projectWbsVO.getParentId());
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        entity.setProjectId(projectWbsVO.getProjectId());
        entity.setName(projectWbsVO.getName());
        entity.setCode(projectWbsVO.getCode());
        entity.setMemo(projectWbsVO.getMemo());
        entity.setEnabled(projectWbsVO.getEnabled());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            ProjectWbsEntity uniqueBean = (ProjectWbsEntity)((Object)((ProjectWbsMapper)this.baseMapper).selectById(entity.getParentId()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectWbsVO vo = (ProjectWbsVO)BeanMapper.map((Object)((Object)entity), ProjectWbsVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Long projectId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap indexMap = new HashMap();
            ArrayList<ProjectWbsVO> projectWbsVOList = new ArrayList<ProjectWbsVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            ArrayList<String> excelCodeList = new ArrayList<String>();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            ArrayList<String> codeList = new ArrayList<String>();
            List oldList = this.service.queryList(queryParam);
            for (ProjectWbsEntity projectWbsEntity : oldList) {
                codeList.add(projectWbsEntity.getCode());
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ProjectWbsVO vo = new ProjectWbsVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String code = (String)datas.get(0);
                vo.setCode(code);
                String parentCode = (String)datas.get(1);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                vo.setTid(id);
                tidMap.put(code, id);
                vo.setTpid(parentCode);
                if (StringUtils.isEmpty((CharSequence)code)) {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    if (codeList.contains(code)) {
                        vo.setCode(code);
                        warnType = warnType + "\u7f16\u7801\u91cd\u590d,";
                        flag = true;
                        parentWarn = true;
                    }
                    if (excelCodeList.contains(code)) {
                        vo.setCode(code);
                        warnType = warnType + "\u6587\u4ef6\u7f16\u7801\u91cd\u590d,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        excelCodeList.add(code);
                    }
                    vo.setCode(code);
                }
                String name = (String)datas.get(2);
                if (StringUtils.isEmpty((CharSequence)name)) {
                    vo.setName(null);
                    warnType = warnType + "\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName(name);
                }
                vo.setMemo((String)datas.get(3));
                vo.setEnabled(Integer.valueOf(1));
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setProjectId(projectId);
                projectWbsVOList.add(vo);
            }
            for (ProjectWbsVO tVo : projectWbsVOList) {
                if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)tidMap.get(tVo.getTpid())))) continue;
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(projectWbsVOList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1), true);
            List<Map<String, Object>> successList = ExcelImportUtil.treeToList(allList.get(0), false);
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<ProjectWbsVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List saveOrUpldates = BeanMapper.mapList(importVOS, ProjectWbsEntity.class);
        this.service.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        if (saveOrUpldates.size() > 0) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ProjectWbsEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ProjectWbsEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) {
                    if (idMap.get(cdEntity.getTpid()) == null) {
                        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                        lambda.eq(ProjectWbsEntity::getCode, (Object)cdEntity.getTpid());
                        ProjectWbsEntity projectWbsEntity = (ProjectWbsEntity)((Object)this.service.getOne((Wrapper)lambda));
                        if (projectWbsEntity != null) {
                            cdEntity.setParentId(projectWbsEntity.getId());
                        }
                    } else {
                        cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                    }
                }
                cdEntity.setOrgId(InvocationInfoProxy.getOrgId());
            }
            for (ProjectWbsEntity projectWbsEntity : saveOrUpldates) {
                if (projectWbsEntity.getParentId() != null && projectWbsEntity.getParentId() > 0L) {
                    ProjectWbsEntity uniqueBean = (ProjectWbsEntity)((Object)((ProjectWbsMapper)this.baseMapper).selectById(projectWbsEntity.getParentId()));
                    projectWbsEntity.setInnerCode(uniqueBean.getInnerCode() + "," + projectWbsEntity.getId());
                } else {
                    projectWbsEntity.setInnerCode(projectWbsEntity.getId().toString());
                }
                this.service.saveOrUpdate((Object)projectWbsEntity);
            }
            this.service.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }

    @Override
    public List<ProjectWbsEntity> getChildrenByPid(Long id) {
        ProjectWbsEntity parent = (ProjectWbsEntity)((Object)this.selectById(id));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter("like_right", (Object)parent.getInnerCode()));
        List list = super.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)list, ProjectWbsEntity.class);
    }
}

