/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.wzxt.bean.ReviewChangeEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailChangeEntity;
import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.mapper.ReviewChangeMapper;
import com.ejianc.business.wzxt.service.IReviewChangeService;
import com.ejianc.business.wzxt.service.IReviewService;
import com.ejianc.business.wzxt.vo.ReviewChangeVO;
import com.ejianc.business.wzxt.vo.ReviewDetailChangeVO;
import com.ejianc.business.wzxt.vo.ReviewDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reviewChangeService")
public class ReviewChangeServiceImpl
extends BaseServiceImpl<ReviewChangeMapper, ReviewChangeEntity>
implements IReviewChangeService {
    @Autowired
    private ReviewChangeMapper reviewChangeMapper;
    @Autowired
    private IReviewService reviewService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<ReviewChangeVO> saveOrUpdatReview(ReviewChangeVO saveOrUpdateVO, boolean b) {
        ReviewEntity reviewEntity = (ReviewEntity)((Object)this.reviewService.selectById(saveOrUpdateVO.getSourceReviewId()));
        UserContext userContext = this.sessionManager.getUserContext();
        ReviewChangeEntity saveEntity = (ReviewChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReviewChangeEntity.class));
        if (null == saveOrUpdateVO.getId()) {
            saveEntity.setId(IdWorker.getId());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(reviewEntity.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setReviewCode(reviewEntity.getBillCode());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity.setModifyUserName(userContext.getUserName());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        ReviewEntity review = (ReviewEntity)((Object)this.reviewService.selectById(saveEntity.getSourceReviewId()));
        if (1 != review.getChangeState()) {
            review.setChangeState(1);
            review.setCurChangingReviewId(saveEntity.getId());
            this.reviewService.saveOrUpdate((Object)review, false);
        }
        List<ReviewDetailChangeEntity> reviewDetailList = saveEntity.getReviewDetailList();
        Map<Long, List<ReviewDetailChangeEntity>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeEntity::getParentId));
        List<ReviewDetailChangeEntity> reviewDetailVOS = reviewDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());
        for (ReviewDetailChangeEntity reviewDetailVO : reviewDetailVOS) {
            List<ReviewDetailChangeEntity> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        saveEntity.setReviewDetailList(reviewDetailVOS);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)saveEntity), ReviewChangeVO.class));
    }

    @Override
    public ReviewChangeEntity getUnFinishedChange(Long sourceReviewId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_review_id", (Object)sourceReviewId);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (ReviewChangeEntity)((Object)this.reviewChangeMapper.selectOne((Wrapper)query));
    }

    @Override
    public ReviewChangeVO queryDetail(Long id) {
        ReviewChangeEntity entity = (ReviewChangeEntity)((Object)super.selectById((Serializable)id));
        ReviewChangeVO vo = (ReviewChangeVO)BeanMapper.map((Object)((Object)entity), ReviewChangeVO.class);
        List reviewDetailList = vo.getReviewDetailList();
        Map<Long, List<ReviewDetailChangeVO>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeVO::getParentId));
        List reviewDetailVOS = reviewDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());
        for (ReviewDetailChangeVO reviewDetailVO : reviewDetailVOS) {
            List<ReviewDetailChangeVO> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        vo.setReviewDetailList(reviewDetailVOS);
        return vo;
    }

    @Override
    public CommonResponse<ReviewChangeVO> getChangeInfo(Long id) {
        ReviewEntity reviewEntity = (ReviewEntity)((Object)this.reviewService.selectById(id));
        ReviewChangeVO reviewChangeVO = new ReviewChangeVO();
        reviewChangeVO.setProjectId(reviewEntity.getProjectId());
        reviewChangeVO.setProjectSourceId(reviewEntity.getProjectSourceId());
        reviewChangeVO.setProjectName(reviewEntity.getProjectName());
        reviewChangeVO.setOrgId(reviewEntity.getOrgId());
        reviewChangeVO.setOrgSourceId(reviewEntity.getOrgSourceId());
        reviewChangeVO.setOrgName(reviewEntity.getOrgName());
        reviewChangeVO.setParentOrgId(reviewEntity.getParentOrgId());
        reviewChangeVO.setParentOrgSourceId(reviewEntity.getParentOrgSourceId());
        reviewChangeVO.setSourceReviewId(reviewEntity.getId());
        UserContext userContext = this.sessionManager.getUserContext();
        reviewChangeVO.setEmployeeId(userContext.getUserId());
        reviewChangeVO.setEmployeeName(userContext.getUserName());
        reviewChangeVO.setCreateDate(new Date());
        CommonResponse<List<ReviewDetailVO>> reviewInfo = this.reviewService.getReviewInfo(reviewEntity.getProjectId(), reviewEntity.getId());
        List data = (List)reviewInfo.getData();
        reviewChangeVO.setReviewDetailInfoList(data);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)reviewChangeVO);
    }
}

