/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ProjectWbsEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailEntity;
import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.enums.ChangeStatusEnum;
import com.ejianc.business.wzxt.service.IProjectWbsService;
import com.ejianc.business.wzxt.service.IReviewDetailService;
import com.ejianc.business.wzxt.service.IReviewService;
import com.ejianc.business.wzxt.vo.ReviewDetailVO;
import com.ejianc.business.wzxt.vo.ReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"review"})
@Api(value="\u590d\u6838\u5b9e\u4f53", tags={"\u590d\u6838\u5b9e\u4f53"})
public class ReviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IReviewService service;
    @Autowired
    private IReviewDetailService reviewDetailService;
    @Autowired
    private IProjectWbsService projectWbsService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReviewVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ReviewVO saveOrUpdateVO) {
        ReviewVO reviewVO = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)reviewVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReviewVO> queryDetail(@RequestParam Long id) {
        ReviewVO reviewVO = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)reviewVO);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReviewVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReviewVO reviewVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReviewVO>> queryList(@RequestBody QueryParam param) {
        boolean mobile;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter wbsPara = (Parameter)param.getParams().get("wbsId");
        if (null != wbsPara) {
            String wbsId = String.valueOf(wbsPara.getValue());
            List<ProjectWbsEntity> wbsEntities = this.projectWbsService.getChildrenByPid(Long.valueOf(wbsId));
            List wbsList = wbsEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(ReviewDetailEntity::getWbsId, wbsList);
            List list = this.reviewDetailService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List idList = list.stream().map(ReviewDetailEntity::getReviewId).collect(Collectors.toList());
                param.getParams().put("id", new Parameter("in", idList));
                param.getParams().remove("wbsId");
            } else {
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L));
            }
        }
        if (!(mobile = param.getParams().containsKey("projectId"))) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/projectReviewCheck"})
    @ResponseBody
    public CommonResponse<String> projectReviewCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        ReviewEntity entityByProject = (ReviewEntity)((Object)this.service.getOne((Wrapper)query));
        if (!(null == entityByProject || null != billId && entityByProject.getId().equals(billId))) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u7528\u91cf\u590d\u6838\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u9002\u7528\u5f53\u524d\u7528\u91cf\u590d\u6838\uff01");
    }

    @RequestMapping(value={"/getReviewInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ReviewDetailVO>> getReviewInfo(@RequestParam(value="projectId", required=false) Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        return this.service.getReviewInfo(projectId, billId);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Parameter wbsPara = (Parameter)param.getParams().get("wbsId");
        if (null != wbsPara) {
            String wbsId = String.valueOf(wbsPara.getValue());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ReviewDetailEntity::getWbsId, (Object)wbsId);
            List list = this.reviewDetailService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Set idSet = list.stream().map(ReviewDetailEntity::getReviewId).collect(Collectors.toSet());
                param.getParams().put("id", new Parameter("in", idSet));
                param.getParams().remove("wbsId");
            } else {
                HashMap beans = new HashMap();
                beans.put("records", new ArrayList());
                ExcelExport.getInstance().export("reviewExport.xlsx", beans, response);
            }
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List reviewVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            reviewVOS = BeanMapper.mapList((Iterable)list, ReviewVO.class);
            for (ReviewVO reviewVO : reviewVOS) {
                reviewVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)reviewVO.getBillState()).getDescription());
                reviewVO.setChangeStateName(ChangeStatusEnum.getEnumByStateCode(reviewVO.getChangeState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", reviewVOS);
        ExcelExport.getInstance().export("reviewExport.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refReviewData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReviewVO>> refReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

