/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.YzMaterialEntity;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.service.IYzMaterialService;
import com.ejianc.business.wzxt.service.IYzSupplierService;
import com.ejianc.business.wzxt.util.MathUtil;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/yzwSyncApi/"})
public class YzwSyncApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectConfigureService projectConfigureService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IYzMaterialService yzMaterialService;
    @Autowired
    private IYzSupplierService yzSupplierService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ThirdSystemUtils thirdSystemUtils;

    @RequestMapping(path={"/syncYzCheck"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncYzCheck(HttpServletRequest request) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String begintime = df.format(calendar.getTime()) + " 00:00:00";
        String endtime = df.format(new Date()) + " 00:00:00";
        if (request.getParameter("beginTime") != null) {
            begintime = request.getParameter("beginTime");
        }
        if (request.getParameter("endTime") != null) {
            endtime = request.getParameter("endTime");
        }
        Map<String, JSONObject> listJsonMap = this.queryYzwCheckList(begintime, endtime, this.thirdSystemUtils);
        this.logger.info("check list size is " + listJsonMap.size());
        if (listJsonMap.isEmpty()) {
            return CommonResponse.success((String)"\u65e0\u6570\u636e");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        JSONObject queryListJson = new JSONObject();
        queryListJson.put("SysNoList", new ArrayList<String>(listJsonMap.keySet()));
        try {
            JSONObject respone = JSONObject.parseObject((String)this.thirdSystemUtils.sendYzw(headers, queryListJson, "BaseData.GetInspectList"));
            if (0 == (Integer)respone.get((Object)"Code") && StringUtils.isNotBlank((CharSequence)respone.getString("Data"))) {
                JSONArray jsonArray = respone.getJSONArray("Data");
                for (Object obj : jsonArray) {
                    JSONObject checkJson = (JSONObject)obj;
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(CheckEntity::getHistoryId, (Object)checkJson.getString("SysNo"));
                    List checkEntities = this.checkService.list((Wrapper)queryWrapper);
                    CheckEntity checkEntity = CollectionUtils.isNotEmpty((Collection)checkEntities) ? (CheckEntity)((Object)this.checkService.selectById(((CheckEntity)((Object)checkEntities.get(0))).getId())) : new CheckEntity();
                    this.syncYzwToCheck(checkJson, listJsonMap, checkEntity);
                }
            }
        }
        catch (IOException e) {
            this.logger.info(e.getMessage());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u9a8c\u6536\u5355\u6210\u529f\uff01");
    }

    private Map<String, JSONObject> queryYzwCheckList(String beginTime, String endTime, ThirdSystemUtils systemUtils) {
        HashMap<String, JSONObject> listJsonMap = new HashMap<String, JSONObject>();
        HashMap<String, String> headers = new HashMap<String, String>();
        JSONObject queryListJson = new JSONObject();
        queryListJson.put("DataDateBegin", (Object)beginTime);
        queryListJson.put("DataDateEnd", (Object)endTime);
        queryListJson.put("LimitRows", (Object)100);
        boolean flag = true;
        int pageNumber = 1;
        try {
            while (flag) {
                queryListJson.put("PageIndex", (Object)pageNumber);
                JSONObject respone = JSONObject.parseObject((String)systemUtils.sendYzw(headers, queryListJson, "BaseData.QueryInspectList"));
                this.logger.info("query check list result is" + respone.toJSONString());
                if (0 == (Integer)respone.get((Object)"Code") && null != respone.getJSONObject("Data").getJSONArray("Rows")) {
                    JSONArray jsonArray = respone.getJSONObject("Data").getJSONArray("Rows");
                    for (Object obj : jsonArray) {
                        JSONObject jsonObject = (JSONObject)obj;
                        listJsonMap.put(jsonObject.getString("SysNo"), jsonObject);
                    }
                    if (jsonArray.size() < 100) {
                        this.logger.info("normal end pageNumber is " + pageNumber);
                        flag = false;
                    }
                } else {
                    flag = false;
                    this.logger.info(respone.toJSONString());
                    this.logger.info("no data pageNumber is " + pageNumber);
                }
                ++pageNumber;
            }
        }
        catch (IOException e) {
            this.logger.info(e.getMessage());
        }
        return listJsonMap;
    }

    private boolean syncYzwToCheck(JSONObject checkJson, Map<String, JSONObject> listJsonMap, CheckEntity checkEntity) {
        CommonResponse supplierVOCommonResponse;
        if (null != checkEntity.getCheckState() && 1 == checkEntity.getCheckState()) {
            this.logger.info("\u5df2\u6709\u8be5\u9a8c\u6536\u5355\u4e14\u9a8c\u6536\u5355\u5df2\u9a8c\u6536");
            return false;
        }
        if (null != checkEntity.getUseState() && 1 == checkEntity.getUseState() && (null == checkEntity.getDrstatus() || 0 == checkEntity.getDrstatus())) {
            this.logger.info("\u5df2\u6709\u8be5\u9a8c\u6536\u5355\u4e14\u9a8c\u6536\u5355\u5df2\u63a8\u9001NC\u672a\u5220\u9664");
            return false;
        }
        String sysNo = checkJson.getString("SysNo");
        JSONObject listJson = listJsonMap.get(sysNo);
        checkEntity.setBillCode(sysNo);
        checkEntity.setYzProjectCode(listJson.getString("ProjectSysNo"));
        checkEntity.setYzProjectName(listJson.getString("ProjectName"));
        Long projectId = this.projectConfigureService.queryProjectIdBySourceId(listJson.getString("ProjectSysNo"));
        if (null != projectId) {
            CommonResponse orgVOCommonResponse;
            ArrayList<Long> projectIdList = new ArrayList<Long>();
            projectIdList.add(projectId);
            CommonResponse project = this.projectApi.queryProjectByIds(projectIdList);
            if (project.isSuccess()) {
                ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)((List)project.getData()).get(0);
                checkEntity.setProjectId(projectRegisterVO.getId());
                checkEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                checkEntity.setProjectName(projectRegisterVO.getName());
                checkEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
                checkEntity.setOrgName(projectRegisterVO.getName());
                checkEntity.setParentOrgId(projectRegisterVO.getOrgId());
            }
            if ((orgVOCommonResponse = this.orgApi.getOneById(checkEntity.getParentOrgId())).isSuccess()) {
                OrgVO orgVO = (OrgVO)orgVOCommonResponse.getData();
                checkEntity.setParentOrgSourceId(orgVO.getSourceId());
            }
        }
        checkEntity.setYzSupplierCode(listJson.getString("SupplierSysNo"));
        checkEntity.setYzSupplierName(listJson.getString("SupplierName"));
        Long supplierId = this.yzSupplierService.querySuplIdByYzCode(listJson.getString("SupplierSysNo"));
        if (null != supplierId && (supplierVOCommonResponse = this.supplierApi.queryById(supplierId)).isSuccess()) {
            SupplierVO supplierVO = (SupplierVO)supplierVOCommonResponse.getData();
            checkEntity.setSupplierId(supplierId);
            checkEntity.setSupplierName(supplierVO.getName());
            checkEntity.setSupplierSourceId(supplierVO.getSourceId());
            checkEntity.setSupplierTenantId(supplierVO.getTenantId());
        }
        checkEntity.setCheckDate(checkJson.getDate("InspectDate"));
        checkEntity.setEmployeeName(checkJson.getString("InspectUserName"));
        checkEntity.setCreateUserName(checkJson.getString("InspectUserName"));
        checkEntity.setCheckType("1");
        checkEntity.setSaveState(1);
        checkEntity.setCheckState(0);
        checkEntity.setIsRequirement("1");
        checkEntity.setIsStandard("1");
        checkEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        checkEntity.setUseState(0);
        checkEntity.setIsaddrecord("0");
        checkEntity.setIsPurchase("0");
        checkEntity.setSmartStatus("0");
        checkEntity.setDrstatus(0);
        checkEntity.setHistoryId(sysNo);
        checkEntity.setHistorySystem("YZW");
        checkEntity.setSourceType("2");
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(checkEntity.getDetailList())) {
            map = checkEntity.getDetailList().stream().collect(Collectors.toMap(CheckDetailEntity::getYzSysNo, Function.identity(), (key1, key2) -> key2));
        }
        ArrayList<CheckDetailEntity> detailList = new ArrayList<CheckDetailEntity>();
        JSONArray jsonArray = checkJson.getJSONArray("DetailList");
        for (Object obj : jsonArray) {
            JSONObject detailJson = (JSONObject)obj;
            CheckDetailEntity detailEntity = null;
            detailEntity = map.containsKey(detailJson.getString("SysNo")) ? (CheckDetailEntity)((Object)map.get(detailJson.getString("SysNo"))) : new CheckDetailEntity();
            detailEntity.setYzSysNo(detailJson.getString("SysNo"));
            detailEntity.setYzMaterialCode(detailJson.getString("MateSysNo"));
            detailEntity.setYzMaterialName(detailJson.getString("ProductCommonName"));
            detailEntity.setYzUnit(detailJson.getString("UnitName"));
            detailEntity.setYzCheckNumsSum(detailJson.getBigDecimal("InspectQuantity"));
            detailEntity.setMemo(detailJson.getString("InspectMemo"));
            YzMaterialEntity yzMaterialEntity = this.yzMaterialService.queryMaterialIdByYzCode(detailJson.getString("MateSysNo"));
            if (null != yzMaterialEntity) {
                ArrayList<Long> materialIdList = new ArrayList<Long>();
                materialIdList.add(yzMaterialEntity.getMaterialId());
                CommonResponse queryMaterialByIds = this.materialApi.queryMaterialByIds(materialIdList);
                if (queryMaterialByIds.isSuccess()) {
                    MaterialVO materialVO = (MaterialVO)((List)queryMaterialByIds.getData()).get(0);
                    detailEntity.setMaterialId(yzMaterialEntity.getMaterialId());
                    detailEntity.setMaterialName(materialVO.getName());
                    detailEntity.setMaterialTypeId(materialVO.getCategoryId());
                    detailEntity.setMaterialTypeName(materialVO.getCategoryName());
                    detailEntity.setMaterialCode(materialVO.getCode());
                    detailEntity.setUnit(materialVO.getUnitName());
                    detailEntity.setSpec(materialVO.getSpec());
                    detailEntity.setMaterialSourceId(materialVO.getSourceId());
                }
                detailEntity.setCheckNumsSum(MathUtil.safeMultiply(detailEntity.getYzCheckNumsSum(), yzMaterialEntity.getCoefficient()));
            }
            detailList.add(detailEntity);
        }
        checkEntity.setDetailList(detailList);
        return this.checkService.saveOrUpdate((Object)checkEntity, false);
    }
}

