/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.bean.WeighReportEntity;
import com.ejianc.business.wzxt.mapper.WeighReportMapper;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IWeighReportService;
import com.ejianc.business.wzxt.service.IWeighService;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighInfoVO;
import com.ejianc.business.wzxt.vo.WeighReportSaveVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weighReportService")
public class WeighReportServiceImpl
extends BaseServiceImpl<WeighReportMapper, WeighReportEntity>
implements IWeighReportService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IWeighService weighService;
    @Autowired
    private IProjectApi projectApi;

    @Override
    public CommonResponse<Boolean> push(WeighReportSaveVO weighReportVO) {
        this.logger.debug(JSONObject.toJSONString((Object)weighReportVO));
        WeighReportEntity weighReport = new WeighReportEntity();
        BeanUtils.copyProperties((Object)weighReportVO, (Object)((Object)weighReport));
        if (StringUtils.isNotBlank((CharSequence)weighReportVO.getPkSrcDelivery())) {
            QueryWrapper deliveryWrapper = new QueryWrapper();
            deliveryWrapper.eq((Object)"history_id", (Object)weighReportVO.getPkSrcDelivery());
            DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getOne((Wrapper)deliveryWrapper, false));
            weighReport.setPkDelivery(delivery.getId());
            weighReport.setDeliveryCode(delivery.getBillCode());
            QueryWrapper deliveryInfoWrapper = new QueryWrapper();
            deliveryInfoWrapper.eq((Object)"history_id", (Object)weighReportVO.getPkSrcDeliveryB());
            DeliveryDetailEntity deliveryInfo = (DeliveryDetailEntity)((Object)this.deliveryDetailService.getOne((Wrapper)deliveryInfoWrapper, false));
            weighReport.setPkDeliveryB(deliveryInfo.getId());
            if (this.isFirstDeliveryInfo(deliveryInfo.getId())) {
                weighReport.setDeliveryNum(deliveryInfo.getDeliverNumsSum());
            }
            OrderEntity purchase = (OrderEntity)((Object)this.orderService.selectById(delivery.getOrderId()));
            weighReport.setProjOrgId(purchase.getOrgId());
            weighReport.setConsigneeUnit(purchase.getProjectName());
            weighReport.setPlanBody(purchase.getConstruction());
            weighReport.setOrderCode(purchase.getBillCode());
            weighReport.setPkProject(purchase.getProjectId());
            weighReport.setConsigneeUnit(purchase.getProjectName());
            weighReport.setPkSupplier(purchase.getSupplierId());
            weighReport.setForwardingUnit(purchase.getSupplierName());
            weighReport.setPkContractPurchase(purchase.getContractId());
            weighReport.setContractPurchaseName(purchase.getContractName());
            weighReport.setContractPurchaseCode(purchase.getContractCode());
            OrderDetailEntity purchaseInfo = (OrderDetailEntity)((Object)this.orderDetailService.selectById(deliveryInfo.getOrderDetailId()));
            weighReport.setPkPurchaseB(purchaseInfo.getId());
            weighReport.setPkMaterial(purchaseInfo.getMaterialId());
            weighReport.setPkMatclass(purchaseInfo.getMaterialTypeId());
            weighReport.setMatclassName(purchaseInfo.getMaterialTypeName());
            weighReport.setMaterialName(purchaseInfo.getMaterialName());
            weighReport.setMaterialSpec(purchaseInfo.getSpec());
            weighReport.setMaterialCode(purchaseInfo.getMaterialCode());
            weighReport.setParentOrgId(purchase.getParentOrgId());
            if (this.isFirstOrderInfo(purchaseInfo.getId())) {
                weighReport.setOrderNum(purchaseInfo.getReceiveNumsSum());
            }
            if (null != weighReport.getPkCheck()) {
                CheckEntity check = (CheckEntity)((Object)this.checkService.selectById(weighReport.getPkCheck()));
                weighReport.setCheckCode(check.getBillCode());
            }
            this.convertUnit(weighReport);
            this.dealMaterialInfo(weighReport, weighReport.getParentOrgId());
        } else {
            weighReport.setPlanBody(weighReportVO.getConstruction());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(WeighEntity::getScsStationCode, (Object)weighReportVO.getWeighStationCode());
            queryWrapper.eq(WeighEntity::getScsTypeId, (Object)"KD-PLATE");
            List weighEntities = this.weighService.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)weighEntities)) {
                this.logger.error("\u8be5\u7ad9\u70b9\u7f16\u53f7\u65e0\u5bf9\u5e94\u9879\u76ee\uff01");
                return CommonResponse.error((int)5006, (String)"\u8be5\u7ad9\u70b9\u7f16\u53f7\u65e0\u5bf9\u5e94\u9879\u76ee\uff01");
            }
            WeighEntity weighEntity = (WeighEntity)((Object)weighEntities.get(0));
            CommonResponse response = this.projectApi.queryProjectByProjectDepartmentId(String.valueOf(weighEntity.getOrgId()));
            ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)response.getData();
            weighReport.setProjOrgId(projectRegisterVO.getProjectDepartmentId());
            weighReport.setPkProject(projectRegisterVO.getId());
            weighReport.setConsigneeUnit(projectRegisterVO.getName());
            weighReport.setParentOrgId(projectRegisterVO.getOrgId());
            if (null != weighReport.getPkCheck()) {
                CheckEntity check = (CheckEntity)((Object)this.checkService.selectById(weighReport.getPkCheck()));
                weighReport.setCheckCode(check.getBillCode());
            }
            this.convertUnit(weighReport);
        }
        if (StringUtils.isNotEmpty((CharSequence)weighReportVO.getOldpk())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"pk_weigh_bill", (Object)weighReportVO.getOldpk());
            super.remove((Wrapper)wrapper, false);
        }
        return CommonResponse.success((Object)super.save((Object)weighReport));
    }

    private boolean isFirstDeliveryInfo(Long pkDeliveryB) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"pk_delivery_b", (Object)pkDeliveryB);
        List list = super.list((Wrapper)wrapper);
        return CollectionUtils.isEmpty((Collection)list);
    }

    private boolean isFirstOrderInfo(Long pkOrderB) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"pk_purchase_b", (Object)pkOrderB);
        List list = super.list((Wrapper)wrapper);
        return CollectionUtils.isEmpty((Collection)list);
    }

    private void convertUnit(WeighReportEntity weighReport) {
        String weightUnit = weighReport.getWeightUnit();
        if ("\u5343\u514b".equals(weightUnit) || "\u516c\u65a4".equals(weightUnit) || "KG".equals(weightUnit) || "Kg".equals(weightUnit) || "kg".equals(weightUnit)) {
            weighReport.setWeightUnit("\u5343\u514b");
        } else if ("\u5428".equals(weightUnit) || "T".equals(weightUnit) || "t".equals(weightUnit)) {
            weighReport.setWeightUnit("\u5343\u514b");
            weighReport.setNetWeight(weighReport.getNetWeight() == null ? BigDecimal.ZERO : weighReport.getNetWeight().multiply(new BigDecimal(1000)));
            weighReport.setGrossWeight(weighReport.getGrossWeight() == null ? BigDecimal.ZERO : weighReport.getGrossWeight().multiply(new BigDecimal(1000)));
            weighReport.setTareWeight(weighReport.getTareWeight() == null ? BigDecimal.ZERO : weighReport.getTareWeight().multiply(new BigDecimal(1000)));
        } else {
            weighReport.setWeightUnit("\u5343\u514b");
        }
    }

    private void dealMaterialInfo(WeighReportEntity weighReport, Long parentOrgId) {
        WeighInfoVO weighInfoVO = new WeighInfoVO();
        weighInfoVO.setOrgId(parentOrgId);
        weighInfoVO.setProjectDepartmentId(weighReport.getProjOrgId());
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(weighReport.getPkMaterial());
        weighInfoVO.setMaterialIds(list);
        List<WeighDetailVO> weighDetailVOS = this.weighService.getMaterialByOrgId(weighInfoVO);
        BigDecimal rate = new BigDecimal(2400);
        if (CollectionUtils.isNotEmpty(weighDetailVOS) && null != weighDetailVOS.get(0).getTransformRate()) {
            rate = weighDetailVOS.get(0).getTransformRate();
        }
        weighReport.setUnitRatio(rate);
        weighReport.setResultNum(weighReport.getNetWeight().divide(rate, 2, 4));
    }
}

