/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.mapper.WeighMapper;
import com.ejianc.business.wzxt.service.IWeighDetailService;
import com.ejianc.business.wzxt.service.IWeighService;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighInfoVO;
import com.ejianc.business.wzxt.vo.WeighVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weighService")
public class WeighServiceImpl
extends BaseServiceImpl<WeighMapper, WeighEntity>
implements IWeighService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWeighDetailService weighDetailService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<WeighVO> getWeighByProjectDepartmentId(Long projectDepartmentId) {
        LambdaQueryWrapper queryWrapperWeigh = Wrappers.lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, (Object)projectDepartmentId);
        WeighEntity weigh = (WeighEntity)((Object)super.getOne((Wrapper)queryWrapperWeigh));
        if (weigh != null) {
            WeighVO vo = (WeighVO)BeanMapper.map((Object)((Object)weigh), WeighVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @Override
    public List<WeighDetailVO> getMaterialByOrgId(WeighInfoVO weighInfoVO) {
        WeighDetailVO weighDetailVO;
        List materialIds = weighInfoVO.getMaterialIds();
        ArrayList<Long> materialIdProjectOpen = new ArrayList<Long>();
        ArrayList<Long> materialIdOrgOpen = new ArrayList<Long>();
        ArrayList<WeighDetailVO> weighDetailVOList = new ArrayList<WeighDetailVO>();
        LambdaQueryWrapper queryWrapperWeigh = Wrappers.lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, (Object)weighInfoVO.getProjectDepartmentId());
        queryWrapperWeigh.eq(WeighEntity::getWeighFlag, (Object)"1");
        WeighEntity weigh = (WeighEntity)((Object)super.getOne((Wrapper)queryWrapperWeigh));
        if (weigh != null) {
            LambdaQueryWrapper queryWrapperWeighDetail = Wrappers.lambdaQuery();
            queryWrapperWeighDetail.eq(WeighDetailEntity::getOrgId, (Object)weighInfoVO.getProjectDepartmentId());
            List weighDetailEntityList = this.weighDetailService.list((Wrapper)queryWrapperWeighDetail);
            if (weighDetailEntityList != null && weighDetailEntityList.size() > 0) {
                for (Long materialId : materialIds) {
                    for (WeighDetailEntity weighDetailEntity : weighDetailEntityList) {
                        if (!weighDetailEntity.getMaterialId().equals(materialId)) continue;
                        weighDetailVO = new WeighDetailVO();
                        weighDetailVO.setWeighFlag(weighDetailEntity.getWeighFlag());
                        weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                        weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                        weighDetailVOList.add(weighDetailVO);
                        materialIdProjectOpen.add(materialId);
                    }
                }
            }
            materialIds.removeAll(materialIdProjectOpen);
        }
        LambdaQueryWrapper queryWrapperWeighDetailOrg = Wrappers.lambdaQuery();
        queryWrapperWeighDetailOrg.eq(WeighDetailEntity::getOrgId, (Object)weighInfoVO.getOrgId());
        List weighDetailEntityOrgList = this.weighDetailService.list((Wrapper)queryWrapperWeighDetailOrg);
        if (weighDetailEntityOrgList != null && weighDetailEntityOrgList.size() > 0) {
            for (Long materialId : materialIds) {
                for (WeighDetailEntity weighDetailEntity : weighDetailEntityOrgList) {
                    if (!weighDetailEntity.getMaterialId().equals(materialId)) continue;
                    weighDetailVO = new WeighDetailVO();
                    weighDetailVO.setWeighFlag(weighDetailEntity.getWeighFlag());
                    weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                    weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                    weighDetailVOList.add(weighDetailVO);
                    materialIdOrgOpen.add(materialId);
                }
            }
        }
        materialIds.removeAll(materialIdOrgOpen);
        if (materialIds != null && materialIds.size() > 0) {
            for (Long materialId : materialIds) {
                WeighDetailVO weighDetailVO2 = new WeighDetailVO();
                weighDetailVO2.setWeighFlag("0");
                weighDetailVO2.setMaterialId(materialId);
                weighDetailVOList.add(weighDetailVO2);
            }
        }
        return weighDetailVOList;
    }

    @Override
    public CommonResponse<WeighVO> getWeighByProjectAndCode(String scsStationCode, String scsTypeId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WeighEntity::getScsStationCode, (Object)scsStationCode);
        queryWrapper.eq(WeighEntity::getScsTypeId, (Object)scsTypeId);
        List weighEntities = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)weighEntities)) {
            WeighEntity weighEntity = (WeighEntity)((Object)weighEntities.get(0));
            WeighVO weighVO = (WeighVO)BeanMapper.map((Object)((Object)weighEntity), WeighVO.class);
            CommonResponse response = this.projectApi.queryProjectByProjectDepartmentId(String.valueOf(weighEntity.getOrgId()));
            weighVO.setProjectId(((ProjectRegisterVO)response.getData()).getId());
            weighVO.setDef5(((OrgVO)this.orgApi.getOneById(weighVO.getOrgId()).getData()).getInnerCode());
            return CommonResponse.success((String)"\u6839\u636e\u7ad9\u70b9\u7f16\u53f7\u548c\u78c5\u7ad9\u7c7b\u578b\u67e5\u8be6\u60c5\u6210\u529f\uff01", (Object)weighVO);
        }
        this.logger.error("\u8be5\u7ad9\u70b9\u7f16\u53f7\u65e0\u5bf9\u5e94\u9879\u76ee\uff01" + scsStationCode);
        return CommonResponse.error((int)5006, (String)"\u8be5\u7ad9\u70b9\u7f16\u53f7\u65e0\u5bf9\u5e94\u9879\u76ee\uff01");
    }
}

