package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ProjectWbsEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailEntity;
import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.enums.ChangeStatusEnum;
import com.ejianc.business.wzxt.service.IProjectWbsService;
import com.ejianc.business.wzxt.service.IReviewDetailService;
import com.ejianc.business.wzxt.service.IReviewService;
import com.ejianc.business.wzxt.vo.ReviewDetailVO;
import com.ejianc.business.wzxt.vo.ReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 复核实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("review")
@Api(value = "复核实体", tags = {"复核实体"})
public class ReviewController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IReviewService service;
    @Autowired
    private IReviewDetailService reviewDetailService;
    @Autowired
    private IProjectWbsService projectWbsService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ReviewVO saveOrUpdateVO) {
        ReviewVO reviewVO = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",reviewVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReviewVO> queryDetail(@RequestParam Long id) {
        ReviewVO reviewVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",reviewVO);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReviewVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ReviewVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ReviewVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Parameter wbsPara = param.getParams().get("wbsId");
        if(null != wbsPara){
            String wbsId = String.valueOf(wbsPara.getValue());
            List<ProjectWbsEntity> wbsEntities = projectWbsService.getChildrenByPid(Long.valueOf(wbsId));
            List<Long> wbsList = wbsEntities.stream().map(ProjectWbsEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<ReviewDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(ReviewDetailEntity::getWbsId, wbsList);
            List<ReviewDetailEntity> list = reviewDetailService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(list)){
                List<Long> idList = list.stream().map(ReviewDetailEntity::getReviewId).collect(Collectors.toList());
                param.getParams().put("id", new Parameter(QueryParam.IN, idList));
                param.getParams().remove("wbsId");
            }else{
                return CommonResponse.success("查询列表数据成功！", new Page<ReviewVO>(param.getPageIndex(), param.getPageSize(), 0));
            }
        }

        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ReviewEntity> page = service.queryPage(param,false);
        IPage<ReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @GetMapping(value = "/projectReviewCheck")
    @ResponseBody
    public CommonResponse<String> projectReviewCheck(@RequestParam(value = "projectId") Long projectId,
                                                   @RequestParam(value = "billId", required = false) Long billId
                                                  ) {
        QueryWrapper<ReviewEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);

        ReviewEntity entityByProject = service.getOne(query);
        if(null != entityByProject && (null == billId || !entityByProject.getId().equals(billId))) {
            return CommonResponse.error("该项目下已存在用量复核！");
        }
        return CommonResponse.success("该项目适用当前用量复核！");
    }
    /**
     * @Description
     *
     */
    @RequestMapping(value = "/getReviewInfo", method = RequestMethod.GET)
    @ResponseBody
        public CommonResponse<List<ReviewDetailVO>> getReviewInfo(@RequestParam(value = "projectId", required = false)Long projectId,@RequestParam(value = "billId", required = false)Long billId) {
        return service.getReviewInfo(projectId,billId);
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter wbsPara = param.getParams().get("wbsId");
        if(null != wbsPara){
            String wbsId = String.valueOf(wbsPara.getValue());
            LambdaQueryWrapper<ReviewDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ReviewDetailEntity::getWbsId, wbsId);
            List<ReviewDetailEntity> list = reviewDetailService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(list)){
                Set<Long> idSet = list.stream().map(ReviewDetailEntity::getReviewId).collect(Collectors.toSet());
                param.getParams().put("id", new Parameter(QueryParam.IN, idSet));
                param.getParams().remove("wbsId");
            }else{
                Map<String, Object> beans = new HashMap<>();
                beans.put("records", new ArrayList<>());
                ExcelExport.getInstance().export("reviewExport.xlsx", beans, response);
            }
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReviewEntity> list = service.queryList(param);
        List<ReviewVO> reviewVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            reviewVOS = BeanMapper.mapList(list, ReviewVO.class);
            for (ReviewVO reviewVO : reviewVOS){
                reviewVO.setBillStateName(BillStateEnum.getEnumByStateCode(reviewVO.getBillState()).getDescription());
                reviewVO.setChangeStateName(ChangeStatusEnum.getEnumByStateCode(reviewVO.getChangeState()).getDescription());
            }
        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", reviewVOS);
        ExcelExport.getInstance().export("reviewExport.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refReviewData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReviewVO>> refReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ReviewEntity> page = service.queryPage(param,false);
        IPage<ReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
