package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IWeighReportService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.CheckWeighVO;
import com.ejianc.business.wzxt.vo.WeighQueryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 智能称重台账实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("swWeighReport")
public class SwWeighReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${smartWeigh.addr}")
    private String SUPPLIER_HTTP;//五局服务域名

    @Autowired
    private IWeighReportService weighReportService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckWeighVO>> queryList(@RequestBody QueryParam param) {
        WeighQueryVO queryVO = new WeighQueryVO();
        queryVO.setOrgId(InvocationInfoProxy.getOrgId());
        queryVO.setPage(param.getPageIndex());
        queryVO.setRows(param.getPageSize());
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        String order = String.valueOf(orderMap.keySet().toArray()[0]);
        queryVO.setSort(order);
        queryVO.setOrder(orderMap.get(order));
        Parameter grossTime = param.getParams().get("grossTime");
        if (null != grossTime) {
            String grossTimeValue = String.valueOf(grossTime.getValue());
            String[] split = grossTimeValue.split(",");
            queryVO.setBeginTime(split[0]);
            queryVO.setEndTime(split[1]);
        }

        String url = SUPPLIER_HTTP + "/el/sw/weigh/projectOrOrg/list";
        String parameterStr = JSONObject.toJSON(queryVO).toString();
        CommonResponse<Object> response = doPostHttp(url, parameterStr);
        if (!response.isSuccess()) {
            throw new BusinessException("调用磅单服务失败！");
        }
        JSONObject jsonObject = JSONObject.parseObject(String.valueOf(response.getData()));
        List<CheckWeighVO> weighVOS = JSONObject.parseArray(String.valueOf(jsonObject.get("records")), CheckWeighVO.class);
        IPage<CheckWeighVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), ((Integer) jsonObject.get("total")));
        pageData.setRecords(weighVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * Post公共方法
     *
     * @param url          路径地址
     * @param parameterStr 参数  JSONString
     * @return
     */
    private CommonResponse<Object> doPostHttp(String url, String parameterStr) {
        Map<String, String> headers = new HashMap();
        // 获取token
//        this.getAccessToken(headers);
        CommonResponse<String> tokenres = orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            try {
                logger.info("------------  url：" + url + "  ------------");
                logger.info("------------  入参：" + parameterStr + "  ------------");
                String back = HttpTookit.postByJson(url, parameterStr, headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if ("200".equals(jsonBack.getString("code"))) {
                    //调用同步方法成功
                    logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
                    return CommonResponse.success(jsonBack.get("body"));
                } else {
                    //调用同步方法失败，输出错误信息
                    logger.error("------------  请求失败！message = " + jsonBack.getString("message") + "  ------------");
                    return CommonResponse.error(jsonBack.getString("message"));
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                return CommonResponse.error("查询失败！");
            }
        } else {
            logger.error("获取token异常，请联系管理员");
            return CommonResponse.error("查询失败！");
        }
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        WeighQueryVO queryVO = new WeighQueryVO();
        queryVO.setOrgId(InvocationInfoProxy.getOrgId());
        queryVO.setPage(param.getPageIndex());
        queryVO.setRows(param.getPageSize());
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        String order = String.valueOf(orderMap.keySet().toArray()[0]);
        queryVO.setSort(order);
        queryVO.setOrder(orderMap.get(order));
        Parameter grossTime = param.getParams().get("grossTime");
        if (null != grossTime) {
            String grossTimeValue = String.valueOf(grossTime.getValue());
            String[] split = grossTimeValue.split(",");
            queryVO.setBeginTime(split[0]);
            queryVO.setEndTime(split[1]);
        }

        String url = SUPPLIER_HTTP + "/el/sw/weigh/projectOrOrg/list";
        String parameterStr = JSONObject.toJSON(queryVO).toString();
        CommonResponse<Object> swResponse = doPostHttp(url, parameterStr);
        if (!swResponse.isSuccess()) {
            throw new BusinessException("调用磅单服务失败！");
        }
        JSONObject jsonObject = JSONObject.parseObject(String.valueOf(swResponse.getData()));
        List<CheckWeighVO> weighVOS = JSONObject.parseArray(String.valueOf(jsonObject.get("records")), CheckWeighVO.class);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", weighVOS);
        ExcelExport.getInstance().export("swWeighReportExport.xlsx", beans, response);
    }
}
