package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.api.ICmContractApi;
import com.ejianc.business.dataexchange.vo.CmContract;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.util.Check;
import com.ejianc.business.wzxt.util.CheckB;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.business.wzxt.vo.sync.SyncMroCheckDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

/**
 * 验收实体
 *
 * @author generator
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService {

    private static final String WZXT_CHECK = "WJ_XELL_CHECK";

    @Value("${smartWeigh.addr}")
    private String SUPPLIER_HTTP;//五局服务域名

    @Value("${mro.addr}")
    private String addr;

    @Value("${common.env.base-host}")
    private String BASE_HOST;//运行环境域名

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private ICheckDetailService checkDetailService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IDeliveryService deliveryService;

    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Autowired
    private ICheckWeighService checkWeighService;

    @Autowired
    private IWeighReportService weighReportService;

    @Autowired
    private ThirdSystemUtils thirdSystemUtils;

    @Autowired
    private ICmContractApi cmContractApi;

    @Autowired
    private IYzSupplierService yzSupplierService;

    @Autowired
    private IYzMaterialService yzMaterialService;

    @Autowired
    private IWeighService weighService;

    @Autowired
    private IWeighDetailService weighDetailService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IReviewDetailService reviewDetailService;

    @Autowired
    private ICauseService causeService;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        CheckEntity dbEntity = null;
        CheckEntity entity = BeanMapper.map(saveorUpdateVO, CheckEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (entity.getParentOrgId() != null) {
            //查询项目部上级组织的的来源id
            CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(entity.getParentOrgId());
            if (!orgParentVo.isSuccess()) {
                throw new BusinessException("查询组织详情失败！");
            }
            entity.setParentOrgName(orgParentVo.getData().getName());
            entity.setParentOrgSourceId(orgParentVo.getData().getSourceId());
            // 查询项目部NC 实际所属组织的的来源id
            CommonResponse<ProjectRegisterVO> project = projectApi.queryProjectByProjectDepartmentId(String.valueOf(entity.getOrgId()));
            if (project.isSuccess()) {
                entity.setRealCorpId(project.getData().getRealCorpId());
                entity.setRealNcCorp(project.getData().getRealNcCorp());
                entity.setRealCorpName(project.getData().getRealCorpName());
            } else {
                throw new BusinessException("查询项目信息详情失败！");
            }
        }
        // 新增
        if (entity.getId() == null) {
            entity.setUseState(0);// 未引用
            entity.setCheckState(1);// 已验收
            //  创建人信息
            if (entity.getCreateUserId() == null) {
                entity.setCreateUserId(InvocationInfoProxy.getUserid());
                entity.setCreateUserName(sessionManager.getUserContext().getUserName());
                entity.setCreateUserSourceId(this.getUserSourceId(entity.getCreateUserId()));// 用户来源ID
            }
            OrderEntity orderEntity = orderService.selectById(saveorUpdateVO.getOrderId());
            entity.setIsPurchase((null != orderEntity.getSubOrderType() && 0 == orderEntity.getSubOrderType()) ? "0" : "1");
        } else {
            dbEntity = selectById(saveorUpdateVO.getId());
        }

        //  创建人信息
        if (entity.getCreateUserId() != null && null == entity.getCreateUserSourceId()) {
            entity.setCreateUserSourceId(this.getUserSourceId(entity.getCreateUserId()));// 用户来源ID
        }

        // 子表处理
        List<CheckDetailEntity> detailList = entity.getDetailList();

        if (saveorUpdateVO.getSourceType() != null && "2".equals(saveorUpdateVO.getSourceType())) {
            yzSupplierService.saveOrUpdate(saveorUpdateVO);
            if (CollectionUtils.isNotEmpty(detailList)) {
                yzMaterialService.saveList(detailList);
            }
        }

        if (CollectionUtils.isNotEmpty(detailList)) {
            StringBuffer materialName = new StringBuffer();
            BigDecimal sumMny = null;// 无税价格合计
            BigDecimal sumTax = null;// 税金合计
            BigDecimal sumTaxMny = null;// 价税合计
            for (CheckDetailEntity detail : detailList) {
                if ("3".equals(entity.getIsPurchase()) && 1 == entity.getSaveState()) {
                    if (null == detail.getMroCheckNum() || detail.getMroCheckNum().compareTo(detail.getMroDeliverNumsSum()) > 0) {
                        throw new BusinessException("表体物资MRO验收数量不允许大于MRO发货数量");
                    }
                }
                detail.setMny(ComputeUtil.safeMultiply(detail.getCheckNumsSum(), detail.getNprice()).setScale(2, BigDecimal.ROUND_HALF_UP));
                detail.setTax(ComputeUtil.safeMultiply(detail.getMny(), ComputeUtil.safeDiv(detail.getTaxrate(), BigDecimal.valueOf(100))).setScale(2, BigDecimal.ROUND_HALF_UP));
                detail.setTaxmny(ComputeUtil.safeAdd(detail.getMny(), detail.getTax()).setScale(2, BigDecimal.ROUND_HALF_UP));

                materialName.append(detail.getMaterialName() + ",");
                sumMny = safeAdd(sumMny, detail.getMny());
                sumTax = safeAdd(sumTax, detail.getTax());
                sumTaxMny = safeAdd(sumTaxMny, detail.getTaxmny());
            }
            String materialNames = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(materialNames);
            entity.setDef1(sumMny != null ? sumMny.setScale(2, BigDecimal.ROUND_HALF_UP).toPlainString() : null);
            entity.setDef2(sumTax != null ? sumTax.setScale(2, BigDecimal.ROUND_HALF_UP).toPlainString() : null);
            entity.setDef3(sumTaxMny != null ? sumTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP).toPlainString() : null);
        }
        super.saveOrUpdate(entity, false);

        saveDealWeigh(entity);

        // 回写发货单验收状态及明细验收数量
        this.writeBackDelivery(saveorUpdateVO, true);
        // 回写订单验收状态及明细验收数量
        this.writeBackOrder(saveorUpdateVO, true);
        // 保存验收单主键与磅单主键关系（磅单确认状态-暂存）
        this.writeBackPoundTemp(entity.getId(), saveorUpdateVO.getPkWeighBills());
        // 更新智能称重台账 验收单主键与磅单主键关系（确认状态-暂存）
        this.writeBackWeighReportCheck(entity.getId(), entity.getBillCode(), saveorUpdateVO.getPkWeighBills());
        // 基于订单验收或者事前磅单的验收，回写磅单服务
        this.writeBackSwWeighBill(entity, true);

        if (saveorUpdateVO.getSaveState() == 1) {
            // 更新磅单确认状态-已确认
//            this.writeBackPound(entity.getId());
            // 更新智能称重台账确认状态-已确认
            this.writeBackWeighReport(entity.getId());
            // 基于订单验收或者事前磅单的验收，生成磅单台账
            this.swWriteBackWeighReport(entity, dbEntity, true);

            if (null != saveorUpdateVO.getOrderId() && null == saveorUpdateVO.getDeliveryId()) {
                orderService.updateOrderIgnore(saveorUpdateVO.getOrderId(), true);
            }
        }

        return BeanMapper.map(entity, CheckVO.class);
    }

    private void swWriteBackWeighReport(CheckEntity entity, CheckEntity dbEntity, Boolean isSave) {
        //移动端点保存
        if (isSave && entity.getSaveState() == 1 && (dbEntity == null || dbEntity.getSaveState() == 0)) {
            List<WeighReportEntity> reportList = new ArrayList<>();
            OrderEntity purchase = orderService.selectById(entity.getOrderId());
            for (CheckDetailEntity detailEntity : entity.getDetailList()) {
                OrderDetailEntity purchaseInfo = orderDetailService.selectById(detailEntity.getOrderDetailId());
                List<CheckWeighEntity> weighList = detailEntity.getWeighList();
                if (CollectionUtils.isNotEmpty(weighList)) {
                    for (CheckWeighEntity weighEntity : weighList) {
                        if (!"del".equals(weighEntity.getRowState())) {
                            WeighReportEntity weighReport = BeanMapper.map(weighEntity, WeighReportEntity.class);
                            //根据订单主表赋值
                            weighReport.setId(null);
                            weighReport.setProjOrgId(purchase.getOrgId());
                            weighReport.setConsigneeUnit(purchase.getProjectName());
                            weighReport.setPlanBody(detailEntity.getWbsName());
                            weighReport.setOrderCode(purchase.getBillCode());
                            weighReport.setPkProject(purchase.getProjectId());
                            weighReport.setConsigneeUnit(purchase.getProjectName());
                            weighReport.setPkSupplier(purchase.getSupplierId());
                            weighReport.setForwardingUnit(purchase.getSupplierName());
                            weighReport.setPkContractPurchase(purchase.getContractId());
                            weighReport.setContractPurchaseName(purchase.getContractName());
                            weighReport.setContractPurchaseCode(purchase.getContractCode());
                            //根据订单明细表赋值
                            weighReport.setPkPurchaseB(purchaseInfo.getId());
                            weighReport.setPkMaterial(purchaseInfo.getMaterialId());
                            weighReport.setPkMatclass(purchaseInfo.getMaterialTypeId());
                            weighReport.setMatclassName(purchaseInfo.getMaterialTypeName());
                            weighReport.setMaterialName(purchaseInfo.getMaterialName());
                            weighReport.setMaterialSpec(purchaseInfo.getSpec());
                            weighReport.setMaterialCode(purchaseInfo.getMaterialCode());
                            weighReport.setParentOrgId(purchase.getParentOrgId());
                            weighReport.setOrderNum(purchaseInfo.getOrderNumsSum());

                            weighReport.setCheckCode(entity.getBillCode());
                            weighReport.setPkCheck(entity.getId());
                            weighReport.setCheckStatus(2);

                            convertUnit(weighReport);

                            dealMaterialInfo(weighReport, weighReport.getParentOrgId());
                            reportList.add(weighReport);
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(reportList)) {
                weighReportService.saveOrUpdateBatch(reportList);
            }

        } else if (!isSave && entity.getSaveState() == 1) {
            //基于订单的验收且是保存后删除
            LambdaUpdateWrapper<WeighReportEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(WeighReportEntity::getPkCheck, entity.getId());
            weighReportService.remove(updateWrapper);
        }
    }

    /**
     * 处理单位，统一转为kg
     *
     * @param weighReport
     */
    private void convertUnit(WeighReportEntity weighReport) {
        String weightUnit = weighReport.getWeightUnit();
        if ("千克".equals(weightUnit) || "公斤".equals(weightUnit)
                || "KG".equals(weightUnit) || "Kg".equals(weightUnit) || "kg".equals(weightUnit)) {
            weighReport.setWeightUnit("千克");
        } else if ("吨".equals(weightUnit) || "T".equals(weightUnit) || "t".equals(weightUnit)) {
            weighReport.setWeightUnit("千克");
            weighReport.setNetWeight(weighReport.getNetWeight() == null ? BigDecimal.ZERO : weighReport.getNetWeight().multiply(new BigDecimal(1000)));
            weighReport.setGrossWeight(weighReport.getGrossWeight() == null ? BigDecimal.ZERO : weighReport.getGrossWeight().multiply(new BigDecimal(1000)));
            weighReport.setTareWeight(weighReport.getTareWeight() == null ? BigDecimal.ZERO : weighReport.getTareWeight().multiply(new BigDecimal(1000)));
        } else {
            weighReport.setWeightUnit("千克");
        }
    }

    private void dealMaterialInfo(WeighReportEntity weighReport, Long parentOrgId) {
        WeighInfoVO weighInfoVO = new WeighInfoVO();
        weighInfoVO.setOrgId(parentOrgId);
        weighInfoVO.setProjectDepartmentId(weighReport.getProjOrgId());
        List<Long> list = new ArrayList<>();
        list.add(weighReport.getPkMaterial());
        weighInfoVO.setMaterialIds(list);

        List<WeighDetailVO> weighDetailVOS = weighService.getMaterialByOrgId(weighInfoVO);
        BigDecimal rate = new BigDecimal(2400);
        if (CollectionUtils.isNotEmpty(weighDetailVOS) && null != weighDetailVOS.get(0).getTransformRate()) {
            rate = weighDetailVOS.get(0).getTransformRate();
        }
        weighReport.setUnitRatio(rate);
        weighReport.setResultNum(weighReport.getNetWeight().divide(rate, 2, BigDecimal.ROUND_HALF_UP));
    }

    private void writeBackSwWeighBill(CheckEntity entity, Boolean isSave) {
        SwWeighVO data = new SwWeighVO();
        if (isSave) {
            List<SwWeighRelationVO> backList = new ArrayList<>();
            for (CheckDetailEntity detailEntity : entity.getDetailList()) {
                List<CheckWeighEntity> weighList = detailEntity.getWeighList();
                if (CollectionUtils.isNotEmpty(weighList)) {
                    for (CheckWeighEntity weighEntity : weighList) {
                        if (!"del".equals(weighEntity.getRowState())) {
                            SwWeighRelationVO relationVO = new SwWeighRelationVO();
                            relationVO.setPkWeighBill(weighEntity.getPkWeighBill());
                            relationVO.setCheckNum(weighEntity.getCheckNum());
                            relationVO.setSourceId(String.valueOf(entity.getId()));
                            relationVO.setSourceDetailId(String.valueOf(detailEntity.getId()));
                            backList.add(relationVO);
                        }
                    }
                }
            }
            logger.info("------------ writeBackSwWeighBill save ------------");
            logger.info(JSONObject.toJSONString(backList));
            data.setSourceId(String.valueOf(entity.getId()));
            data.setBackList(backList);
        } else {
            logger.info("------------ writeBackSwWeighBill del ------------");
            data.setSourceId(String.valueOf(entity.getId()));
        }
        String url = SUPPLIER_HTTP + "/el/sw/weigh/writeBackForCheck";
        String parameterStr = JSONObject.toJSON(data).toString();
        CommonResponse<Object> response = doPostHttp(url, parameterStr);
        if (!response.isSuccess()) {
            throw new BusinessException("回调磅单服务失败！");
        }
    }

    private void saveDealWeigh(CheckEntity entity) {
        List<CheckWeighEntity> insertList = new ArrayList<>();
        List<Long> delPkList = new ArrayList<>();
        for (CheckDetailEntity detailEntity : entity.getDetailList()) {
            List<CheckWeighEntity> weighList = detailEntity.getWeighList();
            if (CollectionUtils.isNotEmpty(weighList)) {
                for (CheckWeighEntity allotEntity : weighList) {
                    if ("del".equals(allotEntity.getRowState())) {
                        delPkList.add(allotEntity.getId());
                    } else {
                        allotEntity.setCheckId(entity.getId());
                        allotEntity.setCheckDetailId(detailEntity.getId());
                        insertList.add(allotEntity);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(insertList)) {
            checkWeighService.saveOrUpdateBatch(insertList);
        }
        if (CollectionUtils.isNotEmpty(delPkList)) {
            checkWeighService.removeByIds(delPkList);
        }
    }


    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return baseMapper.querAnalysisList(page, queryWrapper);
    }

    @Override
    public List<CheckDetailsVO> queryDetailsList(Page<CheckDetailsVO> page, QueryWrapper queryWrapper) {
        return baseMapper.queryDetailsList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        // 发货单生成验收单
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        vo.setProjectId(delivery.getProjectId());// 项目主键
        vo.setProjectSourceId(delivery.getProjectSourceId());// 项目来源id
        vo.setProjectName(delivery.getProjectName());// 项目名称
        vo.setOrgId(delivery.getOrgId());// 组织主键
        vo.setOrgName(delivery.getOrgName());// 组织名称
        vo.setContractId(delivery.getContractId());// 合同主键
        vo.setContractName(delivery.getContractName());// 合同名称
        vo.setSupplierId(delivery.getSupplierId());// 供方主键
        vo.setSupplierName(delivery.getSupplierName());// 供方名称
        vo.setSupplierTenantId(delivery.getTenantId());// 发货单租户id为供方租户id
        vo.setLicensePlate(delivery.getDeliveryCarNumber());// 车牌号
        vo.setMaterialName(delivery.getMaterialName());// 物资名称
        vo.setOrderId(delivery.getOrderId());// 订单主键
        vo.setDeliveryId(deliveryId);// 发货单主键
        vo.setMaterialType(delivery.getMaterialType());//
        // 五局新增字段
        vo.setOrgSourceId(delivery.getOrgSourceId());// 组织来源ID
        vo.setParentOrgId(delivery.getParentOrgId());// 上级组织主键
        vo.setParentOrgSourceId(delivery.getParentOrgSourceId());// 上级组织主键来源ID
        vo.setSupplierSourceId(delivery.getSupplierSourceId());// 供应商来源ID
        vo.setConstruction(delivery.getConstruction());// 使用单位及部位
        vo.setSmartStatus(delivery.getSmartStatus());// 智能称重，0-否，1-是

        if (MaterialTypeEnum.MRO.getCode().equals(delivery.getMaterialType())) {
            vo.setMroDeliveryCode(delivery.getMroDeliveryCode());
        }
        // 发货单明细生成验收单明细
        List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.list(new LambdaQueryWrapper<DeliveryDetailEntity>().eq(DeliveryDetailEntity::getDeliveryId, delivery.getId()));
        if (CollectionUtils.isNotEmpty(deliveryDetailList)) {
            List<Long> pkMaterialList = new ArrayList<>();
            List<CheckDetailVO> detailList = new ArrayList<>();
            List<Long> orderDetailsId = new ArrayList<>();
            deliveryDetailList.forEach(dd -> {
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);// 发货单主键
                detail.setDeliveryDetailId(dd.getId());// 发货单明细主键
                detail.setOrderId(dd.getOrderId());// 订单主键
                detail.setOrderDetailId(dd.getOrderDetailId());// 订单明细主键
                detail.setMaterialTypeId(dd.getMaterialTypeId());// 物料分类主键
                detail.setMaterialTypeName(dd.getMaterialTypeName());// 物料分类名称
                detail.setMaterialId(dd.getMaterialId());// 物料主键
                detail.setMaterialCode(dd.getMaterialCode());// 物料编码
                detail.setMaterialName(dd.getMaterialName());// 物料名称
                detail.setUnit(dd.getUnit());// 单位
                detail.setSpec(dd.getSpec());// 规格型号
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());// 生产厂家
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());// 发货数量
                detail.setCheckTotalNum(orderDetailService.selectById(dd.getOrderDetailId()).getCheckNumsSum());//已验收数量
                detail.setNprice(dd.getPrice());//无税价格
                detail.setNtaxprice(dd.getTaxPrice());//含税价格
                detail.setTaxrate(dd.getTaxRate());//税率
                detail.setWbsId(dd.getWbsId());
                detail.setWbsName(dd.getWbsName());
                detail.setSmartStatus(dd.getSmartStatus());
                // 五局新增字段
                detail.setMaterialSourceId(dd.getMaterialSourceId());// 物资来源ID
                if ("1".equals(detail.getSmartStatus())) {
                    pkMaterialList.add(detail.getMaterialId());
                }
                orderDetailsId.add(dd.getOrderDetailId());
                detailList.add(detail);
            });
            if (CollectionUtils.isNotEmpty(pkMaterialList)) {
                //根据项目部主键和物料主键查询物料智能称重设置
                //如果项目没有配置转换系数，应该获取所属公司的系数
                Map<Long, BigDecimal> matMap = new HashMap<>();//项目设置
                Map<Long, BigDecimal> orgmatMap = new HashMap<>();//公司设置
                LambdaQueryWrapper<WeighDetailEntity> lambda = Wrappers.<WeighDetailEntity>lambdaQuery();
                lambda.eq(WeighDetailEntity::getOrgId, delivery.getParentOrgId());
                lambda.eq(WeighDetailEntity::getWeighFlag, delivery.getParentOrgId());
                lambda.in(WeighDetailEntity::getMaterialId, pkMaterialList);
                List<WeighDetailEntity> detailsOrgs = weighDetailService.list(lambda);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailsOrgs)) {
                    orgmatMap = detailsOrgs.stream().collect(Collectors.toMap(WeighDetailEntity::getMaterialId, WeighDetailEntity::getTransformRate));
                }
                lambda = Wrappers.<WeighDetailEntity>lambdaQuery();
                lambda.in(WeighDetailEntity::getMaterialId, pkMaterialList);
                lambda.eq(WeighDetailEntity::getOrgId, delivery.getOrgId());
                List<WeighDetailEntity> details = weighDetailService.list(lambda);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(details)) {
                    matMap = details.stream().collect(Collectors.toMap(WeighDetailEntity::getMaterialId, WeighDetailEntity::getTransformRate));
                }
                for (CheckDetailVO checkDetailVO : detailList) {
                    BigDecimal transformRate = matMap.get(checkDetailVO.getMaterialId());
                    if (transformRate == null) {
                        transformRate = orgmatMap.get(checkDetailVO.getMaterialId());
                    }
                    if (transformRate == null) {
                        transformRate = BigDecimal.ONE;//如果为空，默认为1
                    }
                    checkDetailVO.setUnitRatio(transformRate);
                }
            }
            vo.setDetailList(detailList);

            //根据发货单主键查询计划的创建人
            if (CollectionUtils.isNotEmpty(orderDetailsId)) {
                String queryPlanEmployName = orderDetailService.queryPlanEmployName(orderDetailsId, delivery.getOrderId());
                vo.setEmployeeName(queryPlanEmployName);
            }
        }
        return vo;
    }

    @Override
    public Boolean deleteIds(List<Long> ids) {
        List<CheckEntity> entityList = baseMapper.selectList(new QueryWrapper<CheckEntity>().in("id", ids));
        if (CollectionUtils.isNotEmpty(entityList)) {
            entityList.forEach(entity -> {
                if (entity.getUseState() == 1) {
                    throw new BusinessException("单据已被引用，不允许删除！");
                }
            });
        }
        List<CheckVO> vos = BeanMapper.mapList(entityList, CheckVO.class);
        if (CollectionUtils.isNotEmpty(vos)) {
            vos.forEach(vo -> {
                CheckEntity checkEntity = BeanMapper.map(vo, CheckEntity.class);
                // 基于订单验收或者事前磅单的验收，删除时回写磅单服务
                this.writeBackSwWeighBill(checkEntity, false);
                // 基于订单验收或者事前磅单的验收，删除磅单台账
                this.swWriteBackWeighReport(checkEntity, null, false);
                // 回写发货单验收状态及明细验收数量
                this.writeBackDelivery(vo, false);
                // 回写订单验收状态及明细验收数量
                this.writeBackOrder(vo, false);
                // 删除回写磅单验收状态
                this.writeBackPoundDel(vo.getId());
                // 删除回写智能称重台账
                this.writeBackWeighReportDel(vo.getId());
            });
        }
        return super.removeByIds(ids, true);
    }

    @Override
    public Boolean push2NC(Long id) {
        boolean drflag = this.sysdr(id);
        if (!drflag) {
            throw new BusinessException("NC端已存在且未删除");
        }
        StringBuffer msg = new StringBuffer();
        // 应该为登录用户的sourceId
        String pkUser = this.getUserSourceId(InvocationInfoProxy.getUserid());// 用户来源ID;
        CheckEntity check = baseMapper.selectById(id);
        if (StringUtils.isEmpty(check.getContractId())) {
            msg.append("[合同]");
        }
        if (StringUtils.isEmpty(check.getCwarehouseid())) {
            msg.append("[仓库]");
        }
        if (StringUtils.isEmpty(check.getCkcorgid())) {
            msg.append("[库存组织]");
        }
        if (StringUtils.isEmpty(check.getCdispatcherid())) {
            msg.append("[收发类别]");
        }
        if (StringUtils.isEmpty(check.getCpurorganization())) {
            msg.append("[采购组织]");
        }
        if (StringUtils.isEmpty(check.getCdptid())) {
            msg.append("[采购部门]");
        }


        List<CheckDetailEntity> checkBList = checkDetailService.list(Wrappers.<CheckDetailEntity>lambdaQuery().eq(CheckDetailEntity::getCheckId, id));
        for (CheckDetailEntity detailEntity : checkBList) {
            if (StringUtils.isEmpty(detailEntity.getPkAmountlist())) {
                msg.append("[表体分录]");
                break;
            }
        }
        if (StringUtils.isNotEmpty(msg)) {
            throw new BusinessException(msg + "不能为空");
        }
        CommonResponse<CmContract> commonResponse = cmContractApi.queryMatContractById(check.getContractId());
        if (commonResponse.isSuccess()) {
            check.setmPkCtManag(commonResponse.getData().getPkCtManage());
        }
        // 构造NC实体VO
        List<PurchaseOrderVO> checkVOList = this.changToNcVO(check, checkBList, pkUser);
        for (PurchaseOrderVO checkVO : checkVOList) {
            logger.info("--->> 推送NC构造实体VO: " + JSON.toJSONString(checkVO));
            //调接口push数据
            IPurchaseOrderService ncService = new IPurchaseOrderService();
            try {
//            URL url = new URL("http://172.30.201.66/uapws/service/OrderService?wsdl");
                IPurchaseOrderServicePortType http = ncService.getIPurchaseOrderServiceSOAP11PortHttp();
                String resulet = http.processData(checkVO);
                if (StringUtils.isNotEmpty(resulet)) {
                    logger.info("--->> 推送NC返回result: " + resulet);
                    Map valueMap = JSON.parseObject(resulet);
                    String code = (String) valueMap.get("code");
                    if (!"WS000001".equals(code)) {
                        msg.append((String) valueMap.get("msg"));
                    }
                }
            } catch (Exception e) {
                logger.info("推送NC出错" + e.getMessage());
                throw new BusinessException("推送NC出错");
            }
            if (StringUtils.isNotEmpty(msg)) {
                throw new BusinessException("推送NC" + msg);
            }
        }
        check.setUseState(1);
//        check.setDrstatus(0);
        // 记录推送人信息
        check.setPushUserId(InvocationInfoProxy.getUserid());
        check.setPushUserName(sessionManager.getUserContext().getUserName());
        check.setPushUserSourceId(this.getUserSourceId(check.getPushUserId()));// 用户来源ID
        baseMapper.updateById(check);

        return true;
    }

    /**
     * 推送MRO
     *
     * @param id
     */
    @Override
    public Boolean push2Mro(Long id) {
        CheckEntity checkEntity = selectById(id);
        if (null == checkEntity.getMroState() || 0 == checkEntity.getMroState()) {
            SyncMroCheckVO mroCheckVO = new SyncMroCheckVO();
            mroCheckVO.setDeliveryCode(checkEntity.getMroDeliveryCode());
            if (CollectionUtils.isNotEmpty(checkEntity.getDetailList())) {
                List<SyncMroCheckDetailVO> detailVOList = new ArrayList<>();
                checkEntity.getDetailList().forEach(detail -> {
                    SyncMroCheckDetailVO mroCheckDetailVO = new SyncMroCheckDetailVO();
                    mroCheckDetailVO.setQuantity(detail.getMroCheckNum());
                    mroCheckDetailVO.setSupplierSkuId(detail.getMroSupplierSkuId());
                    detailVOList.add(mroCheckDetailVO);
                });
                mroCheckVO.setDetailList(detailVOList);
            }
            Map<String, String> headers = new HashMap<>();
            thirdSystemUtils.getMroSign(headers);
            String mroUrl = addr + "/iec/v1/purchase_plan/receipt";
            try {
                logger.info("推送MRO" + JSONObject.toJSON(mroCheckVO).toString());
                String responseStr = HttpTookit.postByJson(mroUrl, JSONObject.toJSON(mroCheckVO).toString(), headers);
                JSONObject json = JSONObject.parseObject(responseStr);
                logger.info("推送MRO结果" + json.toJSONString());
                if (200 == json.getInteger("code") && true == json.getBoolean("success")) {
                    LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(CheckEntity::getId, id);
                    updateWrapper.set(CheckEntity::getMroState, 1);
                    update(updateWrapper);
                } else {
                    throw new BusinessException(json.getString("message"));
                }
            } catch (Exception e) {
                throw new BusinessException(e.getMessage());
            }
        }
        return true;
    }

    @Override
    public void updateProjectInfoByYzw(Long projectId, String mroProjectSourceId) {
        LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CheckEntity::getYzProjectCode, mroProjectSourceId);
        queryWrapper.isNull(CheckEntity::getProjectId);
        List<CheckEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            ProjectRegisterVO projectRegisterVO = null;
            OrgVO orgVO = null;
            List<Long> projectIdList = new ArrayList<>();
            projectIdList.add(projectId);
            CommonResponse<List<ProjectRegisterVO>> project = projectApi.queryProjectByIds(projectIdList);
            if (project.isSuccess()) {
                projectRegisterVO = project.getData().get(0);
                CommonResponse<OrgVO> orgVOCommonResponse = orgApi.getOneById(projectRegisterVO.getOrgId());
                if (orgVOCommonResponse.isSuccess()) {
                    orgVO = orgVOCommonResponse.getData();
                }
            }

            for (CheckEntity checkEntity : list) {
                if (null != projectRegisterVO) {
                    checkEntity.setProjectId(projectRegisterVO.getId());
                    checkEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                    checkEntity.setProjectName(projectRegisterVO.getName());
                    checkEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
                    checkEntity.setOrgName(projectRegisterVO.getName());
                    checkEntity.setParentOrgId(projectRegisterVO.getOrgId());
                }
                if (null != orgVO) {
                    checkEntity.setParentOrgSourceId(orgVO.getSourceId());
                }
            }
            saveOrUpdateBatch(list);
        }
    }

    @Override
    public CheckVO queryDetail(Long id) {
        CheckEntity entity = selectById(id);

        List<CheckDetailEntity> detailList = entity.getDetailList();
        for (CheckDetailEntity detailEntity : detailList) {
            LambdaQueryWrapper<CheckWeighEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(CheckWeighEntity::getCheckDetailId, detailEntity.getId());
            List<CheckWeighEntity> weighEntities = checkWeighService.list(queryWrapper);
            detailEntity.setWeighList(weighEntities);
        }
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return vo;
    }

    @Override
    public CheckVO orderToCheck(Long orderId) {
        // 发货单生成验收单
        CheckVO vo = new CheckVO();
        OrderEntity order = orderService.getById(orderId);
        vo.setOrderCode(order.getBillCode());
        vo.setProjectId(order.getProjectId());// 项目主键
        vo.setProjectSourceId(order.getProjectSourceId());// 项目来源id
        vo.setProjectName(order.getProjectName());// 项目名称
        vo.setOrgId(order.getOrgId());// 组织主键
        vo.setOrgName(order.getOrgName());// 组织名称
        vo.setContractId(order.getContractId());// 合同主键
        vo.setContractName(order.getContractName());// 合同名称
        vo.setSupplierId(order.getSupplierId());// 供方主键
        vo.setSupplierName(order.getSupplierName());// 供方名称
        vo.setSupplierTenantId(order.getTenantId());// 发货单租户id为供方租户id
        vo.setLicensePlate(null);// 车牌号
        vo.setMaterialName(order.getMaterialName());// 物资名称
        vo.setOrderId(order.getId());// 订单主键
        vo.setDeliveryId(null);// 发货单主键
        vo.setMaterialType(order.getOrderType());//
        // 五局新增字段
        vo.setOrgSourceId(order.getOrgSourceId());// 组织来源ID
        vo.setParentOrgId(order.getParentOrgId());// 上级组织主键
        vo.setParentOrgSourceId(order.getParentOrgSourceId());// 上级组织主键来源ID
        vo.setSupplierSourceId(order.getSupplierSourceId());// 供应商来源ID
        vo.setConstruction(order.getConstruction());// 使用单位及部位
        vo.setSmartStatus(order.getSmartStatus());// 智能称重，0-否，1-是

        // 发货单明细生成验收单明细
        List<OrderDetailEntity> orderDetailEntities = orderDetailService.list(new LambdaQueryWrapper<OrderDetailEntity>().eq(OrderDetailEntity::getOrderId, order.getId()));
        if (CollectionUtils.isNotEmpty(orderDetailEntities)) {
            List<CheckDetailVO> detailList = new ArrayList<>();
            List<Long> pkMaterialList = new ArrayList<>();
            List<Long> orderDetailsId = new ArrayList<>();
            orderDetailEntities.forEach(dd -> {
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(null);// 发货单主键
                detail.setDeliveryDetailId(null);// 发货单明细主键
                detail.setOrderId(dd.getOrderId());// 订单主键
                detail.setOrderDetailId(dd.getId());// 订单明细主键
                detail.setMaterialTypeId(dd.getMaterialTypeId());// 物料分类主键
                detail.setMaterialTypeName(dd.getMaterialTypeName());// 物料分类名称
                detail.setMaterialId(dd.getMaterialId());// 物料主键
                detail.setMaterialCode(dd.getMaterialCode());// 物料编码
                detail.setMaterialName(dd.getMaterialName());// 物料名称
                detail.setUnit(dd.getUnit());// 单位
                detail.setSpec(dd.getSpec());// 规格型号
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());// 生产厂家
                detail.setDeliverNumsSum(dd.getOrderNumsSum());// 订单数量
                detail.setNprice(dd.getPrice());//无税价格
                detail.setNtaxprice(dd.getTaxPrice());//含税价格
                detail.setTaxrate(dd.getTaxRate());//税率
                detail.setMaterialSourceId(dd.getMaterialSourceId());// 物资来源ID
                detail.setSmartStatus(dd.getSmartStatus());
                detail.setWbsId(dd.getWbsId());
                detail.setWbsName(dd.getWbsName());
                detail.setCheckTotalNum(dd.getCheckNumsSum());
                if ("1".equals(detail.getSmartStatus())) {
                    pkMaterialList.add(detail.getMaterialId());
                }
                orderDetailsId.add(dd.getId());
                detailList.add(detail);
            });
            if (CollectionUtils.isNotEmpty(pkMaterialList)) {
                //根据项目部主键和物料主键查询物料智能称重设置
                //如果项目没有配置转换系数，应该获取所属公司的系数
                Map<Long, BigDecimal> matMap = new HashMap<>();//项目设置
                Map<Long, BigDecimal> orgmatMap = new HashMap<>();//公司设置
                LambdaQueryWrapper<WeighDetailEntity> lambda = Wrappers.<WeighDetailEntity>lambdaQuery();
                lambda.eq(WeighDetailEntity::getOrgId, order.getParentOrgId());
                lambda.eq(WeighDetailEntity::getWeighFlag, order.getParentOrgId());
                lambda.in(WeighDetailEntity::getMaterialId, pkMaterialList);
                List<WeighDetailEntity> detailsOrgs = weighDetailService.list(lambda);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailsOrgs)) {
                    orgmatMap = detailsOrgs.stream().collect(Collectors.toMap(WeighDetailEntity::getMaterialId, WeighDetailEntity::getTransformRate));
                }
                lambda = Wrappers.<WeighDetailEntity>lambdaQuery();
                lambda.in(WeighDetailEntity::getMaterialId, pkMaterialList);
                lambda.eq(WeighDetailEntity::getOrgId, order.getOrgId());
                List<WeighDetailEntity> details = weighDetailService.list(lambda);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(details)) {
                    matMap = details.stream().collect(Collectors.toMap(WeighDetailEntity::getMaterialId, WeighDetailEntity::getTransformRate));
                }
                for (CheckDetailVO checkDetailVO : detailList) {
                    BigDecimal transformRate = matMap.get(checkDetailVO.getMaterialId());
                    if (transformRate == null) {
                        transformRate = orgmatMap.get(checkDetailVO.getMaterialId());
                    }
                    if (transformRate == null) {
                        transformRate = BigDecimal.ONE;//如果为空，默认为1
                    }
                    checkDetailVO.setUnitRatio(transformRate);
                }
            }
            vo.setDetailList(detailList);

            //根据发货单主键查询计划的创建人
            if (CollectionUtils.isNotEmpty(orderDetailsId)) {
                String queryPlanEmployName = orderDetailService.queryPlanEmployName(orderDetailsId, orderId);
                vo.setEmployeeName(queryPlanEmployName);
            }
        }
        return vo;
    }

    @Override
    public Boolean sysdr(Long id) {
        boolean flag = true;
        Integer dr = 1;
        List<String> arrList = new ArrayList<>();
        arrList.add(String.valueOf(id));
        IPurchaseOrderService ncService = new IPurchaseOrderService();
        StringBuffer msg = new StringBuffer();
        try {
//            URL url = new URL("http://172.30.201.66/uapws/service/OrderService?wsdl");
//            logger.info("getIPurchaseOrderServiceSOAP11PortHttp begin");
            IPurchaseOrderServicePortType http = ncService.getIPurchaseOrderServiceSOAP11PortHttp();
//            logger.info("getIPurchaseOrderServiceSOAP11PortHttp end");
            String json = http.getBillsStatus(arrList);
            if (StringUtils.isNotEmpty(json)) {
                logger.info("--->> NC同步dr返回result: " + json);
                Map valueMap = JSON.parseObject(json);
                String code = (String) valueMap.get("code");
                if (!"WS000001".equals(code)) {
                    msg.append((String) valueMap.get("msg"));
                } else {
                    JSONArray jsarr = (JSONArray) valueMap.get("data");
                    if (jsarr != null && jsarr.size() > 0) {
                        Map map = (JSONObject) jsarr.get(0);
                        dr = map.get("dr") != null ? Integer.parseInt((String) map.get("dr")) : dr;
                        if (dr != 1) {
                            flag = false;
                        }
                    }
                }
            } else {
                msg.append("结果为空");
            }
        } catch (Exception e) {
            throw new BusinessException("同步NC删除状态出错");
        }

        if (StringUtils.isNotEmpty(msg)) {
            throw new BusinessException("同步NC" + msg);
        }

        CheckEntity entity = baseMapper.selectById(id);
//        entity.setDrstatus(dr);
        // 已推送 + 已删除 = 未推送
        if (entity.getUseState() == 1 && dr == 1) {
            entity.setUseState(0);
            baseMapper.updateById(entity);
        }
        return flag;
    }

    @Override
    public Boolean updatenums(List<Long> ids) {
        List<CheckEntity> checks = new ArrayList<>();
        if (!ids.isEmpty()) {
            checks = baseMapper.selectBatchIds(ids);
            if (checks.size() > 0 && checks.size() == ids.size()) {// 检验前台传数据与后台查询数据条数是否一致
                for (CheckEntity check : checks) {
                    check.setPrintNum(check.getPrintNum() == null || check.getPrintNum() == 0 ? 1 : check.getPrintNum() + 1);
                }
            } else {
                throw new BusinessException("数据可能被更改,请刷新界面后再操作");
            }
        }
        boolean res = super.saveOrUpdateBatch(checks);
        if (!res) {
            throw new BusinessException("数据可能被更改,请刷新界面后再操作");
        }
        return res;
    }

    /**
     * 回写发货单验收状态及明细验收数量
     *
     * @param checkVO
     */
    private void writeBackDelivery(CheckVO checkVO, Boolean flag) {
        // 回写验收状态
        if (checkVO.getDeliveryId() != null) {
            DeliveryEntity delivery = deliveryService.getById(checkVO.getDeliveryId());
            // 新增
            if (null == checkVO.getId()) {
                delivery.setDeliverState(2);
                // 回写供方发货单已验收
                this.writeBackCheckToSupplier(checkVO.getDeliveryId(), true);
            }
            // 删除
            if (!flag) {
                LambdaQueryWrapper<CheckEntity> lambda = Wrappers.<CheckEntity>lambdaQuery();
                lambda.in(CheckEntity::getDeliveryId, checkVO.getDeliveryId());
                lambda.ne(CheckEntity::getId, checkVO.getId());
                List<CheckEntity> entityList = baseMapper.selectList(lambda);
                // 还有其他验收单时不回写未验收
                if (entityList.size() == 0) {
                    delivery.setDeliverState(1);
                    // 回写供方发货单未验收
                    this.writeBackCheckToSupplier(checkVO.getDeliveryId(), false);
                }
                // 如果发货单已关闭需开启
                if ("1".equals(delivery.getCloseStatus())) {
                    delivery.setCloseStatus("0");
                    // 回写供方发货单开启
                    this.writeBackOpenDelivery(checkVO.getDeliveryId(), false);
                }
            }
            deliveryService.updateById(delivery);
        }

        // 验收单明细
        List<CheckDetailVO> detailList = checkVO.getDetailList();
        // 回写明细验收数量
        List<DeliveryDetailEntity> ddEditList = new ArrayList<>();// 发货单明细
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(vo -> {
                if (vo.getDeliveryDetailId() != null) {
                    BigDecimal checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();//前端传的验收数量
                    if (null == vo.getId() || !flag || "del".equals(vo.getRowState())) {
                        // 新增或删除
                        DeliveryDetailEntity ddEntity = deliveryDetailService.getById(vo.getDeliveryDetailId());
                        BigDecimal ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();// 发货单明细验收数量
                        ddCheckNums = flag ? "del".equals(vo.getRowState()) ? ddCheckNums.subtract(checkNums) : ddCheckNums.add(checkNums) : ddCheckNums.subtract(checkNums);
                        ddEntity.setCheckNumsSum(ddCheckNums);
                        ddEditList.add(ddEntity);
                    } else {
                        // 编辑
                        CheckDetailEntity detailEntity = checkDetailService.getById(vo.getId());
                        BigDecimal checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();// 数据库验收数量
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            //说明验收数量有修改
                            DeliveryDetailEntity ddEntity = deliveryDetailService.getById(vo.getDeliveryDetailId());
                            BigDecimal ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();// 发货单明细验收数量
                            ddCheckNums = ddCheckNums.subtract(checkNumsDb).add(checkNums);
                            ddEntity.setCheckNumsSum(ddCheckNums);
                            ddEditList.add(ddEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(ddEditList)) {
                deliveryDetailService.updateBatchById(ddEditList);
            }
        }
    }

    /**
     * 回写订单验收状态及明细验收数量
     *
     * @param checkVO
     */
    private void writeBackOrder(CheckVO checkVO, Boolean flag) {
        // 回写验收状态（暂不回写）
//        if(checkVO.getOrderId() != null){
//            if(null == checkVO.getId() || !flag){
//                OrderEntity order = orderService.getById(checkVO.getOrderId());
//                order.setDeliverState(flag ? 2 : 1);
//                orderService.updateById(order);
//            }
//        }

        // 验收单明细
        List<CheckDetailVO> detailList = checkVO.getDetailList();
        // 回写明细验收数量
        List<OrderDetailEntity> odEditList = new ArrayList<>();// 订单明细
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(vo -> {
                if (vo.getOrderDetailId() != null) {
                    BigDecimal checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();//前端传的验收数量
                    if (null == vo.getId() || !flag || "del".equals(vo.getRowState())) {
                        // 新增或删除
                        OrderDetailEntity odEntity = orderDetailService.getById(vo.getOrderDetailId());
                        BigDecimal odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();// 订单明细验收数量
                        odCheckNums = flag ? "del".equals(vo.getRowState()) ? odCheckNums.subtract(checkNums) : odCheckNums.add(checkNums) : odCheckNums.subtract(checkNums);//例子  200 + 80
                        odEntity.setCheckNumsSum(odCheckNums);
                        odEditList.add(odEntity);
                    } else {
                        // 编辑
                        CheckDetailEntity detailEntity = checkDetailService.getById(vo.getId());
                        BigDecimal checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();// 数据库验收数量
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            //说明验收数量有修改
                            OrderDetailEntity odEntity = orderDetailService.getById(vo.getOrderDetailId());
                            BigDecimal odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();// 订单明细验收数量
                            odCheckNums = odCheckNums.subtract(checkNumsDb).add(checkNums);
                            odEntity.setCheckNumsSum(odCheckNums);
                            odEditList.add(odEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(odEditList)) {
                orderDetailService.updateBatchById(odEditList);
            }
        }
    }

    /**
     * 构造NC实体VO
     *
     * @param check
     * @param checkBList
     * @param pkUser
     * @return
     */
    private List<PurchaseOrderVO> changToNcVO(CheckEntity check, List<CheckDetailEntity> checkBList, String pkUser) {
        List<PurchaseOrderVO> purchaseOrderVOS = new ArrayList<>();
        Map<String, List<CheckDetailEntity>> map = new HashMap<>();
        for (CheckDetailEntity detailEntity : checkBList) {
            List<CheckDetailEntity> list;
            BigDecimal sl = detailEntity.getTaxrate() == null ? BigDecimal.ZERO : detailEntity.getTaxrate();
            String key = detailEntity.getPkAmountlist() + "&" + sl;
            if (map.containsKey(key)) {
                list = map.get(key);
            } else {
                list = new ArrayList<>();
            }
            list.add(detailEntity);
            map.put(key, list);
        }

        for (String key : map.keySet()) {
            PurchaseOrderVO checkVO = new PurchaseOrderVO();
            PurchaseOrderHeadVO checkHVO = this.changeToNcHVO(check, pkUser, key);// 构造主表VO
            List<PurchaseOrderBodyVO> checkBVOList = this.changeToNcBVO(check, map.get(key));// 构造子表VO
            checkVO.setPurchaseOrderHeadVO(checkHVO);
            checkVO.setPurchaseOrderBodyVO(checkBVOList.toArray(new PurchaseOrderBodyVO[0]));
            purchaseOrderVOS.add(checkVO);
        }
        return purchaseOrderVOS;
    }

    /**
     * 构造主表VO
     *
     * @param check
     * @param pkUser
     * @return
     */
    private PurchaseOrderHeadVO changeToNcHVO(CheckEntity check, String pkUser, String key) {
        PurchaseOrderHeadVO checkVO = new PurchaseOrderHeadVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        checkVO.setPk_corp(check.getParentOrgSourceId());
        checkVO.setNversion(1);
        checkVO.setDbilldate(new SimpleDateFormat("yyyy-MM-dd").format(check.getCheckDate()));
        checkVO.setCbiztype("0001N510000000036VJ3");
        checkVO.setPk_project(check.getProjectSourceId());
        checkVO.setCwarehouseid(check.getCwarehouseid());
        checkVO.setCpurorganization(check.getCkcorgid());
        checkVO.setCvendormangid(check.getSupplierSourceId());
        checkVO.setCdispatcherid(check.getCdispatcherid());
        checkVO.setCpurorganization2(check.getCpurorganization());
        checkVO.setCdptid(check.getCdptid());//采购部门
        checkVO.setVmemo(check.getBillCode());
        checkVO.setVbeizhu(StringUtils.isNotBlank(check.getConstruction()) && check.getConstruction().length() > 100 ? check.getConstruction().substring(0, 100) : check.getConstruction());
        checkVO.setNtaxrate(BigDecimal.valueOf(0));//税率
        checkVO.setPk_defdoc5(sdf.format(check.getCheckDate()));//入库日期
        checkVO.setFrom_source("qlhpt_00000001");//数据来源
        checkVO.setWebsite(this.getWebSite(check.getId()));//网络站点
//        checkVO.setWebsite("http://wei.cscec5b.com.cn:9000/pca/index.html#/pca/acptBook/detail2?pkCheck=" + check.getId());//网络站点
        checkVO.setTmaketime(sdf.format(new Date()));
        checkVO.setCoperator(pkUser);
        checkVO.setDauditdate(sdf.format(new Date()));
        checkVO.setCauditpsn(pkUser);
        checkVO.setPk_transfer(String.valueOf(check.getId()));
        checkVO.setCwhsmanagerid(check.getCreateUserSourceId());
        checkVO.setPk_contract(check.getContractId());
        String[] arr = key.split("&");
        checkVO.setHtflh(arr[0]);
        checkVO.setSl(new BigDecimal(arr[1]));
        checkVO.setM_pk_ct_manag(check.getmPkCtManag());
        return checkVO;
    }

    /**
     * 生成验收单跳转地址
     *
     * @param id
     * @return
     */
    private String getWebSite(Long id) {
        Long userid = InvocationInfoProxy.getUserid();
        String targeturl = BASE_HOST + "cscec5b-wzxt-frontend/#/check/card?id=" + id;// 目标路径
        logger.info("--->> targeturl: " + targeturl);
        try {
            targeturl = URLEncoder.encode(targeturl, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String webSite = BASE_HOST + "portal/sso/index?userid=" + userid + "&targeturl=" + targeturl;
        logger.info("--->> 生成验收单跳转地址: " + webSite);
        return webSite;
    }

    /**
     * 构造子表VO
     *
     * @param check
     * @param checkBList
     * @return
     */
    private List<PurchaseOrderBodyVO> changeToNcBVO(CheckEntity check, List<CheckDetailEntity> checkBList) {
        List<PurchaseOrderBodyVO> checkBVOList = new ArrayList<>();
        if (checkBList != null && checkBList.size() > 0) {
            Map<String, PurchaseOrderBodyVO> map = new HashMap<>();
            for (CheckDetailEntity checkB : checkBList) {
                PurchaseOrderBodyVO checkBVO = null;
                if (map.containsKey(checkB.getMaterialSourceId())) {
                    checkBVO = map.get(checkB.getMaterialSourceId());
                    checkBVO.setNinnum(ComputeUtil.safeAdd(checkBVO.getNinnum(), checkB.getCheckNumsSum()));
                    checkBVO.setNmny(ComputeUtil.safeAdd(checkBVO.getNmny(), checkB.getMny().setScale(2, BigDecimal.ROUND_HALF_UP)));
                    checkBVO.setNtaxmny(ComputeUtil.safeAdd(checkBVO.getNtaxmny(), checkB.getTaxmny().setScale(2, BigDecimal.ROUND_HALF_UP)));
                } else {
                    checkBVO = new PurchaseOrderBodyVO();
                    checkBVO.setPk_contract(check.getContractId());
                    checkBVO.setContract_name(check.getContractName());
                    checkBVO.setPk_cinventory(checkB.getMaterialSourceId());
                    checkBVO.setCinventorycode(checkB.getMaterialCode());
                    checkBVO.setCinventoryname(checkB.getMaterialName());
                    checkBVO.setInvspec(checkB.getDef1());// 规格
                    checkBVO.setInvtype(checkB.getDef2());// 型号
                    checkBVO.setPk_measddoc(checkB.getDef3());// 计量单位主键
                    checkBVO.setNinnum(checkB.getCheckNumsSum() == null ? BigDecimal.ZERO : checkB.getCheckNumsSum());
                    checkBVO.setNmny(checkB.getMny().setScale(2, BigDecimal.ROUND_HALF_UP));
                    checkBVO.setNtaxrate_b(checkB.getTaxrate() == null ? BigDecimal.ZERO : checkB.getTaxrate());
                    checkBVO.setTaxmny(checkB.getTax().setScale(2, BigDecimal.ROUND_HALF_UP));
                    checkBVO.setNtaxmny(checkB.getTaxmny().setScale(2, BigDecimal.ROUND_HALF_UP));
                    checkBVO.setDbizdate(new SimpleDateFormat("yyyy-MM-dd").format(check.getCheckDate()));//入库日期
                    checkBVO.setVnotebody(checkB.getMemo());
                    checkBVO.setVdef20(checkB.getMaterialManufacturer());
                    checkBVO.setHtflh(checkB.getPkAmountlist());
                    checkBVO.setSl(checkB.getTaxrate() == null ? BigDecimal.ZERO : checkB.getTaxrate());
                    map.put(checkB.getMaterialSourceId(), checkBVO);
                }
            }

            for (PurchaseOrderBodyVO bodyVO : map.values()) {
                bodyVO.setTaxmny(ComputeUtil.safeSub(bodyVO.getNtaxmny(), bodyVO.getNmny()).setScale(2, BigDecimal.ROUND_HALF_UP));
                bodyVO.setNprice(ComputeUtil.safeDiv(bodyVO.getNmny(), bodyVO.getNinnum()).setScale(8, BigDecimal.ROUND_HALF_UP));
                checkBVOList.add(bodyVO);
            }
        }
        return checkBVOList;
    }

    @Override
    public CommonResponse<Object> poundList(String id) {
        logger.info("------------  查询磅单列表  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/check/list";
        Map<String, String> params = new HashMap();
        params.put("pkCheck", String.valueOf(id));
        return doGetHttp(url, params);
    }

    @Override
    public CommonResponse<Object> poundDetail(String pkWeighBill) {
        logger.info("------------  查询磅单详情  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/detail";
        Map<String, String> params = new HashMap();
        params.put("pkWeighBill", pkWeighBill);
        return doGetHttp(url, params);
    }

    @Override
    public CommonResponse<Object> getWeighListByPks(List<String> pkWeighBill) {
        logger.info("------------  根据主键集合获取磅单信息  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/list";
        Map<String, List<String>> map = new HashMap<>();
        map.put("pkWeighs", pkWeighBill);
        JSONObject params = JSONObject.parseObject(JSON.toJSONString(map));
        String parameterStr = params.toJSONString();
        return doPostHttp(url, parameterStr);
    }

    @Override
    public CommonResponse<Object> getWeighListByDelivery(String pkDelivery, Integer checkStatus) {
        logger.info("------------  根据发货单主键获取磅单信息  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/delivery/list";
        Map<String, String> params = new HashMap();
        params.put("pkDelivery", pkDelivery);
        if (checkStatus != null) {
            params.put("checkStatus", String.valueOf(checkStatus));
        }
        return doGetHttp(url, params);
    }

    @Override
    public CommonResponse<Object> getWeighListByProjOrOrg(WeighQueryVO weighQueryVO) {
        logger.info("------------  根据项目主键和标识获取磅单列表  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/projectOrOrg/list";
        JSONObject params = JSONObject.parseObject(JSON.toJSONString(weighQueryVO));
        String parameterStr = params.toJSONString();
        return doPostHttp(url, parameterStr);
    }

    @Override
    public Boolean push2Supplier(Long id) {
        CheckEntity entity = selectById(id);
        Check data = getCheckHeadVO(entity);// 构造验收单主表VO
        List<CheckB> bodyList = getCheckBodyVOList(entity);// 构造验收单子表VO
        data.setCheckBList(bodyList);
        String url = SUPPLIER_HTTP + "/el/delivery/check/insert";
        String parameterStr = JSONObject.toJSON(data).toString();
        return doPostHttp(url, parameterStr).isSuccess();
    }

    @Override
    public Boolean rollBackForSupplier(Long id) {
        Check data = new Check();
        data.setPkCheck(String.valueOf(id));
        String url = SUPPLIER_HTTP + "/el/delivery/check/delete";
        String parameterStr = JSONObject.toJSON(data).toString();
        return doPostHttp(url, parameterStr).isSuccess();
    }

    @Override
    public void push2Cause(Long billId) {
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        Callable<CommonResponse<String>> mainDatasetCallable = new PushCauseCallable(billId, RequestContextHolder.getRequestAttributes(), sessionManager, causeService, reviewDetailService);
        threadPool.submit(mainDatasetCallable);
    }

    class PushCauseCallable implements Callable<CommonResponse<String>> {

        private Long callBillId;
        private RequestAttributes callContext;
        private SessionManager callSessionManager;
        private ICauseService callcauseService;
        private IReviewDetailService callReviewDetailService;

        public PushCauseCallable(Long callBillId, RequestAttributes callContext, SessionManager callSessionManager, ICauseService callcauseService, IReviewDetailService callReviewDetailService) {
            this.callBillId = callBillId;
            this.callContext = callContext;
            this.callSessionManager = callSessionManager;
            this.callcauseService = callcauseService;
            this.callReviewDetailService = callReviewDetailService;
        }

        @Override
        public CommonResponse<String> call() throws Exception {
            RequestContextHolder.setRequestAttributes(callContext);
            CheckEntity checkEntity = selectById(callBillId);
            List<CauseDetailVO> result = new ArrayList<>();
            UserContext userContext = callSessionManager.getUserContext();
            logger.error("PushCauseCallable userContext is " + JSONObject.toJSONString(userContext));
            for (CheckDetailEntity detailEntity : checkEntity.getDetailList()) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq("project_id", checkEntity.getProjectId());
                queryWrapper.eq("wbs_id", detailEntity.getWbsId());
                queryWrapper.eq("material_id", detailEntity.getMaterialId());
                Page<CauseDetailVO> page = new Page<>(1, -1);
                List<CauseDetailVO> causeDetailVOS = callReviewDetailService.queryStandingBook(page, queryWrapper);
                if (CollectionUtils.isNotEmpty(causeDetailVOS) && ComputeUtil.isLessThan(causeDetailVOS.get(0).getExceedRate(), BigDecimal.ZERO)) {
                    causeDetailVOS.get(0).setId(null);
                    result.add(causeDetailVOS.get(0));
                }
            }
            if (CollectionUtils.isNotEmpty(result)) {
                CauseVO causeVO = new CauseVO();
                causeVO.setProjectId(checkEntity.getProjectId());
                causeVO.setProjectName(checkEntity.getProjectName());
                causeVO.setEmployeeId(String.valueOf(userContext.getEmployeeId()));
                causeVO.setEmployeeName(userContext.getEmployeeName());
                causeVO.setDetailList(result);
                callcauseService.saveOrUpdate(causeVO);
                logger.error("PushCauseCallable causeVO is" + JSONObject.toJSONString(causeVO));
            }
            return CommonResponse.success("成功");
        }
    }

    /**
     * 构造验收单主表
     *
     * @param entity
     * @return
     */
    private Check getCheckHeadVO(CheckEntity entity) {
        Check data = new Check();
        data.setPkCheck(String.valueOf(entity.getId()));// 主键
        data.setBillcode(entity.getBillCode());// 单据编码
        data.setPkOrg(entity.getOrgSourceId());// 组织主键
        data.setPkProject(entity.getProjectSourceId());// 项目主键
        data.setProjectname(entity.getProjectName());// 项目主键名称
        data.setPkContractPurchase(entity.getContractId());// 合同主键
        data.setContractPurchaseName(entity.getContractName());// 合同名称
        data.setPkSupplier(entity.getSupplierSourceId());// 供应商主键
        data.setSuppliername(entity.getSupplierName());// 供应商名称
        data.setChecker(entity.getEmployeeName());// 验收人
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        data.setChecktime(formatter.format(entity.getCheckDate()));// 验收日期
        data.setCarnumber(entity.getLicensePlate());// 车牌号
        data.setIsrequirement("1".equals(entity.getIsRequirement()) ? "Y" : "N");// 是否满足质量要求
        data.setIsstandard("1".equals(entity.getIsStandard()) ? "Y" : "N");// 是否满足合同要求
        data.setMaterialnumber(entity.getMaterialnumber());// 材质书号
        data.setUnit(entity.getConstruction());// 使用单位及部位
        data.setCheckprocess(entity.getCheckprocess());// 验收过程
        data.setCreator(entity.getCreateUserSourceId());// 创建人
        data.setVdef1(entity.getCreateUserName());// 创建人名称
        data.setCreatorDate(formatter.format(entity.getCreateTime()));// 制单时间
        data.setCheckStatus(4);//已确认

        if (data.getPkProject() != null) {
            //查询项目部上级组织的的来源id
            CommonResponse<ProjectRegisterVO> ponse = projectApi.queryProjectBySourceId(data.getPkProject());
            if (ponse.getData() == null) {
                throw new BusinessException("网络异常， 查询失败，请稍后再试");
            }
            ProjectRegisterVO projectRegisterVO = ponse.getData();
            data.setCorpId(projectRegisterVO.getOrgId());//项目所属组织id
            data.setCorpName(projectRegisterVO.getOrgName());
            data.setCorpSourceId(projectRegisterVO.getSourceOrgId());//项目所属组织来源id
        }

        CommonResponse<List<AttachmentVO>> beforeResponse = attachmentApi.queryListBySourceId(entity.getId(), "BT221118000000001", "imgUpload1", null);
        if (beforeResponse.isSuccess() && CollectionUtils.isNotEmpty(beforeResponse.getData())) {
            String tpurl = beforeResponse.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.joining(","));
            data.setTpurl(tpurl);// 原始照片
        }
        CommonResponse<List<AttachmentVO>> afterResponse = attachmentApi.queryListBySourceId(entity.getId(), "BT221118000000001", "imgUpload2", null);
        if (afterResponse.isSuccess() && CollectionUtils.isNotEmpty(afterResponse.getData())) {
            String sceneurl = afterResponse.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.joining(","));
            data.setSceneurl(sceneurl);// 现场照片
        }
        data.setPkDelivery(String.valueOf(entity.getDeliveryId()));// 发货单主键
        data.setSysmark("xellxpt");// 来源系统
        return data;
    }


    /**
     * 构造验收单子表
     *
     * @param entity
     * @return
     */
    private List<CheckB> getCheckBodyVOList(CheckEntity entity) {
        List<CheckB> bodyList = new ArrayList<>();
        List<CheckDetailEntity> detailList = entity.getDetailList();
        for (CheckDetailEntity detail : detailList) {
            CheckB body = new CheckB();
            body.setPkCheckB(String.valueOf(detail.getId()));// 子表主键
            body.setPkCheck(String.valueOf(detail.getCheckId()));// 主表主键
            body.setPkMaterial(detail.getMaterialSourceId());// 物料主键
            body.setCode(detail.getMaterialCode());// 物料编码
            body.setName(detail.getMaterialName());// 物料名称
            body.setSpec(detail.getSpec());// 规格型号
            body.setMeasname(detail.getUnit());// 单位
            body.setManufacturer(detail.getMaterialManufacturer());// 生产厂家
            body.setNumber(this.getDouble(detail.getCheckNumsSum()));// 验收数量
            body.setVat(this.getDouble(detail.getNprice()));// 无税单价
            body.setTax(this.getDouble(detail.getTaxrate()));// 税率
            body.setNote(detail.getMemo());// 备注
            if (null != entity.getDeliveryId()) {
                body.setPkDelivery(deliveryService.selectById(entity.getDeliveryId()).getHistoryId());// 发货单主键
            }
            if (null != detail.getDeliveryDetailId()) {
                body.setPkDeliveryInfo(deliveryDetailService.selectById(detail.getDeliveryDetailId()).getHistoryId());// 发货单子表主键
            }
            bodyList.add(body);
        }
        return bodyList;
    }

    /**
     * 取BigDecimal的Double值
     *
     * @param num
     * @return
     */
    private Double getDouble(BigDecimal num) {
        return num != null ? num.doubleValue() : null;
    }

    @Override
    public List<MaterialInRefVO> getMaterialInRef(Page<MaterialInRefVO> page, QueryWrapper wrapper, String contractId, Long tenantId) {
        List<MaterialInRefVO> list = baseMapper.getMaterialInRef(page, wrapper, contractId, tenantId);
        return list;
    }

    /**
     * 回写供方发货单是否已验收
     *
     * @param deliveryId 发货单主键
     * @param isCheck    是否验收
     * @return
     */
    private CommonResponse<Object> writeBackCheckToSupplier(Long deliveryId, Boolean isCheck) {
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        String pkDelivery = StringUtils.isNotEmpty(delivery.getHistoryId()) ? delivery.getHistoryId() : String.valueOf(deliveryId);
        logger.info("------------  回写供方发货单验收状态  ------------");
        String url = SUPPLIER_HTTP + "/el/delivery/delivery/check";
        Map<String, String> params = new HashMap();
        params.put("pkDelivery", pkDelivery);
        params.put("isCheck", String.valueOf(isCheck));
        return doGetHttp(url, params);
    }

    /**
     * 回写供方发货单开启/关闭
     *
     * @param deliveryId 发货单主键
     * @param isClose    是否开启
     * @return
     */
    public CommonResponse<Object> writeBackOpenDelivery(Long deliveryId, Boolean isClose) {
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        String pkDelivery = StringUtils.isNotEmpty(delivery.getHistoryId()) ? delivery.getHistoryId() : String.valueOf(deliveryId);
        logger.info("------------  回写供方发货单开启  ------------");
        String url = SUPPLIER_HTTP + "/el/delivery/delivery/close";
        Map<String, String> params = new HashMap();
        params.put("pkDelivery", pkDelivery);
        params.put("isClose", String.valueOf(isClose));
        return doGetHttp(url, params);
    }

    /**
     * 保存验收单主键与磅单主键关系（磅单确认状态-暂存）
     *
     * @param id           验收单主键
     * @param pkWeighBills 磅单主键集合
     * @return
     */
    private CommonResponse<Object> writeBackPoundTemp(Long id, List<String> pkWeighBills) {
        if (CollectionUtils.isEmpty(pkWeighBills)) {
            return CommonResponse.error("pkWeighBills为空！");
        }
        logger.info("------------  保存验收单主键与磅单主键关系（磅单确认状态-暂存）  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/check";
        WeighCheckVO data = new WeighCheckVO();
        data.setPkCheck(String.valueOf(id));
        data.setPkWeighBills(pkWeighBills);
        String parameterStr = JSONObject.toJSON(data).toString();
        return doPostHttp(url, parameterStr);
    }

    /**
     * 更新智能称重台账 验收单主键与磅单主键关系（确认状态-暂存）
     *
     * @param id           验收单主键
     * @param billCode     验收单编号
     * @param pkWeighBills 磅单主键集合
     */
    private void writeBackWeighReportCheck(Long id, String billCode, List<String> pkWeighBills) {
        if (CollectionUtils.isEmpty(pkWeighBills)) {
            return;
        }
        LambdaUpdateWrapper<WeighReportEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(WeighReportEntity::getPkWeighBill, pkWeighBills);
        updateWrapper.set(WeighReportEntity::getPkCheck, String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getCheckCode, billCode);
        updateWrapper.set(WeighReportEntity::getCheckStatus, 1);
        weighReportService.update(updateWrapper);
    }

    /**
     * 更新磅单确认状态-已确认(废除)
     *
     * @param id 验收单主键
     * @return
     */
    private CommonResponse<Object> writeBackPound(Long id) {
        logger.info("------------  更新磅单确认状态-已确认  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/updateCheckStatus";
        WeighCheckVO data = new WeighCheckVO();
        data.setPkCheck(String.valueOf(id));
        data.setBillStatus(2);
        String parameterStr = JSONObject.toJSON(data).toString();
        return doPostHttp(url, parameterStr);
    }

    /**
     * 更新智能称重台账确认状态-已确认
     *
     * @param id 验收单主键
     */
    private void writeBackWeighReport(Long id) {
        LambdaUpdateWrapper<WeighReportEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(WeighReportEntity::getPkCheck, String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getCheckStatus, 2);
        weighReportService.update(updateWrapper);
    }

    /**
     * 删除回写磅单验收状态
     *
     * @param id 验收单主键
     * @return
     */
    private CommonResponse<Object> writeBackPoundDel(Long id) {
        logger.info("------------  删除回写磅单验收状态  ------------");
        String url = SUPPLIER_HTTP + "/el/sw/weigh/unCheck";
        Map<String, String> params = new HashMap();
        params.put("pkCheck", String.valueOf(id));
        return doGetHttp(url, params);
    }

    /**
     * 删除回写智能称重台账
     *
     * @param id 验收单主键
     */
    private void writeBackWeighReportDel(Long id) {
        LambdaUpdateWrapper<WeighReportEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(WeighReportEntity::getPkCheck, String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getPkCheck, null);
        updateWrapper.set(WeighReportEntity::getCheckStatus, 0);
        updateWrapper.set(WeighReportEntity::getCheckCode, null);
        weighReportService.update(updateWrapper);
    }

//    /**
//     * 获取access_token服务
//     *
//     * @param headers
//     * @throws GeneralSecurityException
//     * @throws IOException
//     */
//    private CommonResponse<String> getAccessToken(Map<String, String> headers) {
//        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
//        if(redisTemplate.opsForValue().get("X-Open-Token") != null){
//            //若存在，直接放到header中
//            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
//        }else{
//            String initContextUrl = SUPPLIER_HTTP + "/el/sw/auth/v1/accessToken?appId=6de82f4q&secret=@zLc1HUc";
//            String responseStr = null;
//            try {
//                responseStr = HttpTookit.get(initContextUrl, null);
//                JSONObject json = JSONObject.parseObject(responseStr);
//                if("200".equals(json.get("code").toString())){
//                    JSONObject data = json.getJSONObject("body");
//                    String access_token = data.get("token").toString();
//                    headers.put("X-Open-Token", access_token);
//                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
//                    redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
//                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
//                }else{
//                    //请求失败，输出错误信息
//                    return CommonResponse.error("获取供方access_token异常");
//                }
//            } catch (GeneralSecurityException e) {
//                logger.info("GeneralSecurityException 异常"+e.getMessage());
//                return CommonResponse.error("获取供方access_token异常");
//            } catch (IOException e) {
//                logger.info("IOException 异常"+e.getMessage());
//                return CommonResponse.error("获取供方access_token异常");
//            }
//        }
//        return CommonResponse.success();
//    }

    /**
     * Get公共方法
     *
     * @param url    路径地址
     * @param params 参数  Map<String, String>
     * @return
     */
    private CommonResponse<Object> doGetHttp(String url, Map<String, String> params) {
        Map<String, String> headers = new HashMap();
        // 获取token
//        this.getAccessToken(headers);
        CommonResponse<String> tokenres = orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            try {
                logger.info("------------  url：" + url + "  ------------");
                logger.info("------------  入参：" + params.toString() + "  ------------");
                String back = HttpTookit.get(url, params, headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if ("200".equals(jsonBack.getString("code"))) {
                    //调用同步方法成功
                    logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
                    return CommonResponse.success(jsonBack.get("body"));
                } else {
                    //调用同步方法失败，输出错误信息
                    logger.error("------------  请求失败！message = " + jsonBack.getString("message") + "  ------------");
                    return CommonResponse.error(jsonBack.getString("message"));
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                return CommonResponse.error("查询失败！");
            }
        } else {
            logger.error("获取token异常，请联系管理员");
            return CommonResponse.error("查询失败！");
        }
    }

    /**
     * Post公共方法
     *
     * @param url          路径地址
     * @param parameterStr 参数  JSONString
     * @return
     */
    private CommonResponse<Object> doPostHttp(String url, String parameterStr) {
        Map<String, String> headers = new HashMap();
        // 获取token
//        this.getAccessToken(headers);
        CommonResponse<String> tokenres = orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            try {
                logger.info("------------  url：" + url + "  ------------");
                logger.info("------------  入参：" + parameterStr + "  ------------");
                String back = HttpTookit.postByJson(url, parameterStr, headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if ("200".equals(jsonBack.getString("code"))) {
                    //调用同步方法成功
                    logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
                    return CommonResponse.success(jsonBack.get("body"));
                } else {
                    //调用同步方法失败，输出错误信息
                    logger.error("------------  请求失败！message = " + jsonBack.getString("message") + "  ------------");
                    return CommonResponse.error(jsonBack.getString("message"));
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                return CommonResponse.error("查询失败！");
            }
        } else {
            logger.error("获取token异常，请联系管理员");
            return CommonResponse.error("查询失败！");
        }
    }

    /**
     * 获取登录用户sourceId
     *
     * @param createUserId
     * @return
     */
    private String getUserSourceId(Long createUserId) {
        CommonResponse<List<UserVO>> res = userApi.queryListByIds(new String[]{String.valueOf(createUserId)});
        if (!res.isSuccess()) {
            throw new BusinessException("查询用户失败！");
        }
        if (CollectionUtils.isNotEmpty(res.getData())) {
            UserVO vo = res.getData().get(0);// 获取登录用户VO
            if (vo != null && StringUtils.isNotEmpty(vo.getSourceId())) {
                return vo.getSourceId();// 来源ID
            }
        }
        return null;
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null && decimal2 == null) {
            return null;
        } else {
            decimal1 = decimal1 == null ? BigDecimal.ZERO : new BigDecimal(decimal1.toString());
            decimal2 = decimal2 == null ? BigDecimal.ZERO : new BigDecimal(decimal2.toString());
            return decimal1.add(decimal2);
        }
    }

}
