package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailEntity;
import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.mapper.OrderMapper;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 订单实体
 *
 * @author generator
 *
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    @Value("${openApi.wjTokenUrl}")
    private String wjTokenUrl;

    @Value("${openApi.wjOrderUrl}")
    private String wjOrderUrl;

    @Value("${openApi.wjDelOrderUrl}")
    private String wjDelOrderUrl;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String XELL_ORDER_BILL_CODE = "WJ_XELL_ORDER";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IProjectApi iProjectApi;


    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ICmContractInfoApi cmContractInfoApi;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private IReviewService reviewService;

    @Autowired
    private IReviewDetailService reviewDetailService;


    @Override
    public OrderVO saveOrUpdate(OrderVO orderVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(orderVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(XELL_ORDER_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                orderVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(CollectionUtils.isEmpty(orderVO.getPurchaseOrderDetail())){
            throw new BusinessException("材料明细为空,请添加数据!");
        }

        //回写订单数据到用量复核单
        OrderEntity entity = BeanMapper.map(orderVO, OrderEntity.class);
        entity.setHistoryFlag(0);
        entity.setOrderType(0);
        entity.setIgnoreFlag(0);
        super.saveOrUpdate(entity, false);
        //根据项目查询出用量复核数据
        LambdaQueryWrapper<ReviewEntity> lambdaReviewEntity = Wrappers.<ReviewEntity>lambdaQuery();
        lambdaReviewEntity.eq(ReviewEntity::getProjectId, entity.getProjectId());
        ReviewEntity reviewEntity = reviewService.getOne(lambdaReviewEntity);
        //复核子表
        LambdaQueryWrapper<ReviewDetailEntity> lambdaReviewDetailEntity = Wrappers.<ReviewDetailEntity>lambdaQuery();
        lambdaReviewDetailEntity.eq(ReviewDetailEntity::getReviewId, reviewEntity.getId());
        List<ReviewDetailEntity> reviewDetailEntityList = reviewDetailService.list(lambdaReviewDetailEntity);


        //根据复核主键查询出所有的订单信息
        LambdaQueryWrapper<OrderDetailEntity> lambdaOrderDetailEntity = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambdaOrderDetailEntity.eq(OrderDetailEntity::getReviewId, reviewEntity.getId());
        List<OrderDetailEntity> orderDetailEntities = orderDetailService.list(lambdaOrderDetailEntity);
        if (CollectionUtils.isNotEmpty(orderDetailEntities)){
            Map<Long, List<OrderDetailEntity>> receiveIdMap = orderDetailEntities.stream().collect(Collectors.groupingBy(OrderDetailEntity::getReviewDetailId));
            for (ReviewDetailEntity reviewDetailEntity : reviewDetailEntityList){
                if (receiveIdMap.containsKey(reviewDetailEntity.getId())){
                    List<OrderDetailEntity> orderDetailEntityList = receiveIdMap.get(reviewDetailEntity.getId());
                    BigDecimal orderNum = orderDetailEntityList.stream().map(OrderDetailEntity::getOrderNumsSum)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                    reviewDetailEntity.setOrderNum(orderNum);
                }else {
                    reviewDetailEntity.setOrderNum(BigDecimal.ZERO);
                }
            }
        }
        reviewDetailService.saveOrUpdateBatch(reviewDetailEntityList);
        return queryDetail(entity.getId());
    }

    @Override
    public Boolean isMatRefCont(String pkContract, String matPkList) {
        // 1、获取物资合同清单明细
        List<CmContractInfoVO> infoList = cmContractInfoApi.queryMatContractInfoById(pkContract).getData();
        if (infoList == null) {
            throw new BusinessException("该采购合同中无清单项！");
        }
        List<String> pkList = infoList.stream().map(CmContractInfoVO::getInfocode).collect(Collectors.toList());
        // 2、选择材料明细
        List<String> matList = Arrays.asList(matPkList.split(","));
        // 3、进行匹配
        List<String> diffList = this.getDifferent(pkList, matList);         // 材料明细中不匹配的PK
        if (diffList != null && diffList.size() > 0) {
            throw new BusinessException(String.join(",", diffList) + "不在合同中");
        } else {
            return true;
        }
    }

    private static List<String> getDifferent(List<String> list1, List<String> list2) {
        List<String> diff = new ArrayList<String>();
        a: for (int j=0; j<list2.size(); j++) {
            b: for (int i=0; i<list1.size(); i++) {
                if ( list2.get(j).indexOf(list1.get(i)) != -1 ) {       // 如果包含，跳出内层循环
                    break b;
                } else if (list2.get(j).indexOf(list1.get(i)) == -1 && i == list1.size()-1) {  // 如果遍历所有元素都不包含，则识别该元素
                    diff.add(list2.get(j));
                }
            }
        }
        return diff;
    }

    @Override
    public CommonResponse<OrderVO> updateReceived(OrderVO orderVO) {

        //考虑历史数据升级的问题
        LambdaQueryWrapper<OrderEntity> lambda = Wrappers.<OrderEntity>lambdaQuery();
        lambda.eq(OrderEntity::getHistoryId, orderVO.getMainId());
        OrderEntity orderEntity = super.getOne(lambda);
        if(null!=orderEntity && null !=orderEntity.getId() ){
            orderVO.setId(orderEntity.getId());
            LambdaQueryWrapper<OrderDetailEntity> lambda2 = Wrappers.<OrderDetailEntity>lambdaQuery();
            lambda2.eq(OrderDetailEntity::getOrderId, orderEntity.getId());
            List<OrderDetailEntity> details = orderDetailService.list(lambda2);
            if(CollectionUtils.isNotEmpty(details)){
                orderEntity.setPurchaseOrderDetail(details);
                Map<String, Long> map = details.stream().collect(Collectors.toMap(OrderDetailEntity::getHistoryId,OrderDetailEntity::getId));
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                    if(map.containsKey(vo.getChildId())){
                        vo.setId(map.get(vo.getChildId()));
                    }
                });
            }
        }else{
            orderEntity = super.selectById(Long.parseLong(orderVO.getMainId()));
            orderVO.setId(orderEntity.getId());
            if(CollectionUtils.isNotEmpty(orderEntity.getPurchaseOrderDetail())){
                orderVO.getPurchaseOrderDetail().forEach(vo -> {
                        vo.setId(Long.parseLong(vo.getChildId()));
                });
            }
        }

        if(null!=orderEntity&&null!=orderEntity.getReceiveState()&&orderEntity.getReceiveState()>0&&4!=orderVO.getReceiveState()){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }

        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"cscec5b-xell-frontend/#/purchaseOrder/card?id="+orderEntity.getId();
        String subject = "";
        String content = "";
        //全部接收
        if(1==orderVO.getReceiveState()){
            orderEntity.setReceiveState(1);//全部接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail(),1);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    vo.setReceiveNumsSum(vo.getOrderNumsSum());//接收数量
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                });
            }
        }else if(2==orderVO.getReceiveState()){
            //部分接收
            orderEntity.setReceiveState(2);//部分接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail(),2);
                Map<Long, BigDecimal> map = orderVO.getPurchaseOrderDetail().stream().collect(Collectors.toMap(OrderDetailVO::getId,OrderDetailVO::getReceiveNumsSum));
                logger.debug("map------"+map);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    vo.setReceiveNumsSum(map.get(vo.getId()));
                    logger.debug("ReceiveNumsSum------"+vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                });
            }
        }else if(3==orderVO.getReceiveState()){
          //已拒绝
            orderEntity.setReceiveState(3);//拒绝
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail(),3);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                });
            }
        }
        if(4==orderVO.getReceiveState()){
            orderEntity.setDeliverState(3);//已退回
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】退回。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】退回。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分退回数量
                BackOrderDetail(orderVO.getPurchaseOrderDetail());
                Map<Long, BigDecimal> map = orderVO.getPurchaseOrderDetail().stream().collect(Collectors.toMap(OrderDetailVO::getId,OrderDetailVO::getBackNumsSum));
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    BigDecimal backOrderNumsSum = vo.getBackNumsSum()==null?BigDecimal.ZERO:vo.getBackNumsSum();//退还量
                    BigDecimal backOrderNums = map.get(vo.getId())==null?BigDecimal.ZERO:map.get(vo.getId());//本次退还
                    vo.setBackNumsSum(backOrderNumsSum.add(backOrderNums));
                });
            }
        }
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()),orderEntity);
        logger.debug("-----主键"+orderEntity.getId());
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }

    @Override
    public CommonResponse<OrderVO> updateReceivedPart(OrderVO orderVO) {
        OrderEntity orderEntity = super.selectById(orderVO.getId());
        if(null!=orderEntity&&null!=orderEntity.getReceiveState()&&orderEntity.getReceiveState()>=0){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }
        orderEntity.setReceiveState(2);//部分接收
        orderEntity.setDeliverState(0);//待发货
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            //拆分接收数量
            OrderDetailBack(orderVO.getPurchaseOrderDetail(),2);
            orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }

        // TO DO 定时到期下架消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
//        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"cscec5b-xell-frontend/#/purchaseOrder/card?id="+orderEntity.getId();
        String subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。";
        String content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()),orderEntity);
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }
    //1-全部接收，2-部分接收，3-全部拒绝 4-退回
    public void OrderDetailBack(List<OrderDetailVO> detailList,int type){
        List<OrderDetailEntity> entityList = new ArrayList<>();
        List<ReviewDetailEntity> reviewDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            for (OrderDetailVO vo : detailList){
                OrderDetailEntity orderDetailEntity = orderDetailService.getById(vo.getId());
                orderDetailEntity.setReceiveNumsSum(vo.getReceiveNumsSum());
//                BigDecimal backOrderNumsSum = orderDetailEntity.getBackNumsSum()==null?BigDecimal.ZERO:orderDetailEntity.getBackNumsSum();//退还量
//                orderDetailEntity.setBackNumsSum(backOrderNumsSum.add(vo.getBackNumsSum()));
                ReviewDetailEntity reviewDetailEntity = reviewDetailService.selectById(orderDetailEntity.getReviewDetailId());

                BigDecimal occupyNum =  reviewDetailEntity.getOccupyNum()==null?BigDecimal.ZERO: reviewDetailEntity.getOccupyNum();//
                BigDecimal orderNumsSum =  orderDetailEntity.getOrderNumsSum()==null?BigDecimal.ZERO: orderDetailEntity.getOrderNumsSum();//
                BigDecimal receiveNumsSum =   vo.getReceiveNumsSum()==null?BigDecimal.ZERO:  vo.getReceiveNumsSum();//

                reviewDetailEntity.setOccupyNum(occupyNum.subtract(orderNumsSum).add(receiveNumsSum));
                reviewDetailList.add(reviewDetailEntity);
                entityList.add(orderDetailEntity);

            }
            //批量更新订单明细
            if(CollectionUtils.isNotEmpty(entityList)){
                orderDetailService.updateBatchById(entityList);
            }
            //批量更新复核明细
            if(CollectionUtils.isNotEmpty(reviewDetailList)){
                reviewDetailService.updateBatchById(reviewDetailList);
            }
//            .forEach(vo -> {



//                //查询订单数量>接收数量的明细  根据主键正序排
//                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
//                lambda.eq(OrderDetailEntity::getParentId,orderDetailEntity.getTid());
//                lambda.eq(OrderDetailEntity::getOrderId,orderDetailEntity.getOrderId());
//                lambda.eq(OrderDetailEntity::getLeafFlag,true);
//                lambda.orderByAsc(OrderDetailEntity::getId);
//                List<OrderDetailEntity> details  = orderDetailService.list(lambda);
//                if(CollectionUtils.isNotEmpty(details)){
//                    BigDecimal receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();//汇总的接收数量
//                    //forEach  不能这样用    xx = xx.subtract(xx);
//                    for(int i=0;i<details.size();i++){
//
//                        BigDecimal orderNumsSum = details.get(i).getOrderNumsSum()==null?BigDecimal.ZERO:details.get(i).getOrderNumsSum();//订单量
//                        if(receiveNumsSum.compareTo(BigDecimal.ZERO)>0){
//                            if(receiveNumsSum.compareTo(orderNumsSum)>=0){
//                                //接收数量  大于该行  剩余可接收数量，则直接将该行  接收数量=订单数量即可
//                                details.get(i).setReceiveNumsSum(orderNumsSum);
//                                receiveNumsSum = receiveNumsSum.subtract(orderNumsSum);
//                            }else{
////                                接收数量  小于该行  剩余可接收数量，则直接将该行  接收数量=原来订单数量+行汇总后的剩余接收数量
//                                details.get(i).setReceiveNumsSum(receiveNumsSum);
//                                //此时需要回写计划订单明细对应的占用金额
//                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
//                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
//                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();
//
//                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum).add(receiveNumsSum));//占用量
//                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
//                                receiveNumsSum = receiveNumsSum.subtract(receiveNumsSum);
//                                planDetailList.add(planDetailEntity);
//                            }
//                            entityList.add(details.get(i));//后续批量更新
//                        }else {
//                            PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
//                            BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
//                            BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();
//
//                            planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));//占用量
//                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
//                            planDetailList.add(planDetailEntity);
//                        }
//                    }
//
//                }
            };
        }
//    }


    public void BackOrderDetail(List<OrderDetailVO> detailList){
        List<OrderDetailEntity> entityList = new ArrayList<>();
        List<ReviewDetailEntity> reviewDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            for (OrderDetailVO vo : detailList){
                OrderDetailEntity orderDetailEntity = orderDetailService.getById(vo.getId());
                orderDetailEntity.setReceiveNumsSum(vo.getReceiveNumsSum());
                BigDecimal backOrderNumsSum = orderDetailEntity.getBackNumsSum()==null?BigDecimal.ZERO:orderDetailEntity.getBackNumsSum();//退还量
                orderDetailEntity.setBackNumsSum(backOrderNumsSum.add(vo.getBackNumsSum()));
                ReviewDetailEntity reviewDetailEntity = reviewDetailService.selectById(orderDetailEntity.getReviewDetailId());

                BigDecimal occupyNum =  reviewDetailEntity.getOccupyNum()==null?BigDecimal.ZERO: reviewDetailEntity.getOccupyNum();//
                BigDecimal orderNumsSum =  orderDetailEntity.getOrderNumsSum()==null?BigDecimal.ZERO: orderDetailEntity.getOrderNumsSum();//
                BigDecimal receiveNumsSum =   vo.getReceiveNumsSum()==null?BigDecimal.ZERO:  vo.getReceiveNumsSum();//

                reviewDetailEntity.setOccupyNum(occupyNum.subtract(orderNumsSum).add(receiveNumsSum));
                reviewDetailList.add(reviewDetailEntity);
                entityList.add(orderDetailEntity);

            }
            //批量更新订单明细
            if(CollectionUtils.isNotEmpty(entityList)){
                orderDetailService.updateBatchById(entityList);
            }
            //批量更新复核明细
            if(CollectionUtils.isNotEmpty(reviewDetailList)){
                reviewDetailService.updateBatchById(reviewDetailList);
            }
//            detailList.forEach(vo -> {
////                OrderDetailEntity orderDetailEntity = orderDetailService.getById(vo.getId());//取当前行的tid
////
////                //查询订单数量>接收数量的明细  根据主键正序排
////                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
////                lambda.eq(OrderDetailEntity::getParentId,orderDetailEntity.getTid());
////                lambda.eq(OrderDetailEntity::getOrderId,orderDetailEntity.getOrderId());
////                lambda.eq(OrderDetailEntity::getLeafFlag,true);
////                lambda.orderByAsc(OrderDetailEntity::getId);
////                List<OrderDetailEntity> details  = orderDetailService.list(lambda);
////                if(CollectionUtils.isNotEmpty(details)){
////                    BigDecimal backNumsSum = vo.getBackNumsSum()==null?BigDecimal.ZERO:vo.getBackNumsSum();//汇总的退回
////                    //forEach  不能这样用    xx = xx.subtract(xx);
////                    for(int i=0;i<details.size();i++){
////                        BigDecimal receiveNumsSum = details.get(i).getReceiveNumsSum()==null?BigDecimal.ZERO:details.get(i).getReceiveNumsSum();//接收量
////                        BigDecimal backOrderNumsSum = details.get(i).getBackNumsSum()==null?BigDecimal.ZERO:details.get(i).getBackNumsSum();//退还量
////                        BigDecimal orderNumsSum = receiveNumsSum.subtract(backOrderNumsSum);
////                        if(backNumsSum.compareTo(BigDecimal.ZERO)>0){
////                            if(orderNumsSum.compareTo(backNumsSum)>=0){
////                                //例如   退回数量100    接收(300)-退还(100) = 200
////                                details.get(i).setBackNumsSum(backOrderNumsSum.add(backNumsSum));
////
////
//////                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
//////                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
//////                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();
//////
//////                                planDetailEntity.setOccupyNums(occupyNums.subtract(backNumsSum));//占用量
//////                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
//////                                planDetailList.add(planDetailEntity);
//////                                backNumsSum = BigDecimal.ZERO;
////                            }else{
////                                //例如   退回数量100    接收(30)-退还(10) = 20
//////                                details.get(i).setBackNumsSum(backOrderNumsSum.add(orderNumsSum));
//////                                //此时需要回写计划订单明细对应的占用金额
//////                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
//////                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
//////                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();
//////
//////                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));//占用量
//////                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
//////                                backNumsSum = backNumsSum.subtract(orderNumsSum);
//////                                planDetailList.add(planDetailEntity);
////                            }
////                            entityList.add(details.get(i));//后续批量更新
////                        }
////                    }
////                    //批量更新订单明细
////                    if(CollectionUtils.isNotEmpty(entityList)){
////                        orderDetailService.updateBatchById(entityList);
////                    }
////                    //批量更新计划明细
////                    if(CollectionUtils.isNotEmpty(planDetailList)){
////                        planDetailService.updateBatchById(planDetailList);
////                    }
////                }
////            });
        }
    }


    @Override
    public OrderVO queryDetail(Long id) {
        OrderEntity entity = super.selectById(id);
        OrderVO orderVO = BeanMapper.map(entity, OrderVO.class);
        return orderVO;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId,OrderEntity orderEntity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }

        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams  = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "供方平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", wjyPath+"cscec5b-xell-mobile/#/orderIndex/orderDetails?id="+orderEntity.getId()+"&userid={userid}");
            parameter.setWjyMsgParams(wjyMsgParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        //获取redis中的X-Open-Token，若不存在，则重新请求并放入redis中
        logger.info("------------  开始获取token  ------------");
        if(redisTemplate.opsForValue().get("X-Open-Token") != null){
            //若存在，直接放到header中
            logger.info("------------  redisTemplate里有token  ------------"+redisTemplate.opsForValue().get("X-Open-Token"));
            headers.put("X-Open-Token", redisTemplate.opsForValue().get("X-Open-Token").toString());
        }else{
            String initContextUrl = wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject(responseStr);
                if("200".equals(json.get("code").toString())){
                    JSONObject data = json.getJSONObject("body");
                    String access_token = data.get("token").toString();
                    headers.put("X-Open-Token", access_token);
                    //将获取到的X-Open-Token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于120分钟）
                    redisTemplate.opsForValue().set("X-Open-Token", access_token,6000, TimeUnit.SECONDS);
                    logger.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
                }else{
                    //请求失败，输出错误信息
                    return CommonResponse.error("系统推送供方时，获取供方access_token异常");
                }
            } catch (GeneralSecurityException e) {
                logger.info("GeneralSecurityException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            } catch (IOException e) {
                logger.info("IOException 异常"+e.getMessage());
                return CommonResponse.error("系统推送供方时，获取供方access_token异常");
            }
        }
        return CommonResponse.success();
    }

    /**
     * 推送供方订单
     *
     * @param headers
     *
     */
    public CommonResponse<String>  pushOrder(Map<String, String> headers,OrderEntity orderEntity){
        String url = wjOrderUrl;
        Purchase purchase = new Purchase();
        purchase.setPkPurchase(String.valueOf(orderEntity.getId()));// 订货单主键
        purchase.setPkOrg(orderEntity.getParentOrgSourceId());;// 组织主键   传来源组织主键
        purchase.setPkProject(orderEntity.getProjectSourceId());// 项目主键    传来源项目主键
        purchase.setProjectName(orderEntity.getProjectName());
        purchase.setPurchaseCode(orderEntity.getBillCode());// 订货单编码
        purchase.setPkSupplier(orderEntity.getSupplierSourceId());// 供应商主键     传来源供应商主键
        purchase.setSupplierName(orderEntity.getSupplierName());
        purchase.setPkContractPurchase(orderEntity.getContractId());// 采购合同主键
        purchase.setContractPurchaseName(orderEntity.getContractName());
        purchase.setContractPurchaseCode(orderEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        purchase.setPurchaseCreateDate(formatter.format(orderEntity.getOrderCreateDate()));// 订货单创建时间 yyyy-MM-dd
        purchase.setPurchaseExpiryDate(formatter.format(orderEntity.getOrderExpiryDate()));// 订货单要求送货时间 yyyy-MM-dd
        purchase.setPurchaseLinkMan(orderEntity.getLinkName());// 订货单联系人
        purchase.setPurchaseLinkTelephone(orderEntity.getLinkTelephone());// 订货单联系电话
        purchase.setBillStatus(1);// 订货单状态  传1  代表“待确认”
        purchase.setPurchaseType(orderEntity.getOrderType());
        purchase.setIsConfirm(orderEntity.getIsConfirm());
        purchase.setPurchaseNote(orderEntity.getOrderNote());// 送货要求
        purchase.setPurchaseAddress(orderEntity.getOrderAddress());// 送货地址
        purchase.setPlanBody(orderEntity.getConstruction());//使用部位
        purchase.setSmartStatus(orderEntity.getSmartStatus()==null?0:Integer.parseInt(orderEntity.getSmartStatus()));//智能称重标识 0 激活 1 关闭
        purchase.setPlatformType(orderEntity.getPlatformType());//磅点类型 0、请选择   1、实达、 2、沣悦
        purchase.setPlatformCode(orderEntity.getPlatformCode());//磅点编号
        purchase.setSysmark("xellxpt");//系统标识，“xpt”-限额领料
        purchase.setPkCreator("xellxpt");
        purchase.setCreatorName("限额领料");
        purchase.setCreatorDate(DateFormater.getInstance().format(DateFormater.LONG_FORMAT));

        if(purchase.getPkProject()!=null){
            //查询项目部上级组织的的来源id
            CommonResponse<ProjectRegisterVO> ponse =  iProjectApi.queryProjectBySourceId(purchase.getPkProject());
            if(ponse.getData()==null) {
                throw new BusinessException("网络异常， 查询失败，请稍后再试");
            }
            ProjectRegisterVO projectRegisterVO = ponse.getData();
            purchase.setCorpId(projectRegisterVO.getOrgId());//项目所属组织id
            purchase.setCorpName(projectRegisterVO.getOrgName());
            purchase.setCorpSourceId(projectRegisterVO.getSourceOrgId());//项目所属组织来源id
        }

        //获取附件  传送供方
        List<FileRelation> orderfileList = new ArrayList<>();
        CommonResponse<List<AttachmentVO>> fileResponse = attachmentApi.queryListBySourceId(orderEntity.getId(), "BT201028000000001", "gfUpload", null);
        if (fileResponse.isSuccess() && fileResponse.getData() != null && fileResponse.getData().size() > 0) {
            List<AttachmentVO> fileList = fileResponse.getData();
            for (AttachmentVO fileVo : fileList) {
                FileRelation file = new FileRelation();
                file.setFileName(fileVo.getFileName());
                file.setFilePath(fileVo.getFilePath());
                file.setFileType(fileVo.getFileName().substring(fileVo.getFileName().lastIndexOf(".") + 1, fileVo.getFileName().length()));
                file.setFileBizPk(orderEntity.getId().toString());
                file.setDr(0);
                file.setFileBiz("purchase");// 订单业务标识
                file.setBizType("0");// 附件业务标识
                orderfileList.add(file);
            }
        }
        purchase.setFileList(orderfileList);


        if(CollectionUtils.isNotEmpty(orderEntity.getPurchaseOrderDetail())){
            List<PurchaseInfo> list = new ArrayList<>();
            orderEntity.getPurchaseOrderDetail().forEach(e -> {
                    //非末级才需要同步
                    PurchaseInfo vo = new PurchaseInfo();
                    vo.setPkPurchaseInfo(String.valueOf(e.getId()));// 订购单子表主键
                    vo.setPkPurchase(String.valueOf(orderEntity.getId()));// 订单表主键
                    vo.setPkMaterial(e.getMaterialSourceId());// 材料主键 传来源主键
                    vo.setMaterialCode(e.getMaterialCode());// 材料编码"
                    vo.setMaterialName(e.getMaterialName());// 材料名称
                    vo.setMaterialSpec(e.getSpec());// 规格
                    vo.setMaterialType(e.getSpec());// 型号
                    vo.setMaterialMeasname(e.getUnit());// 单位
                    vo.setMaterialManufacturer(e.getMaterialManufacturer());// 生产厂家
                    vo.setMaterialNote(e.getMemo());// 材料备注
                    vo.setWbsName(e.getWbsName());

                    vo.setPrice(e.getPrice()==null?0:e.getPrice().doubleValue());
                    vo.setTaxPrice(e.getTaxPrice()==null?0:e.getTaxPrice().doubleValue());
                    vo.setTaxRate(e.getTaxRate()==null?0:e.getTaxRate().doubleValue());
                    vo.setWidth(e.getWidth());
                    vo.setHeight(e.getHeight());
                    vo.setLength(e.getLength());
                    vo.setSurface(e.getSurface());
                    vo.setColor(e.getColor());
                    vo.setColorNumber(e.getColorNumber());
                    vo.setTextureMaterial(e.getTextureMaterial());
                    vo.setWallThickness(e.getWallThickness());
                    vo.setBuildingNumber(e.getBuildingNumber());

                    vo.setPlanAmountSum(e.getPlanNumsSum()==null?0:e.getPlanNumsSum().doubleValue());// 计划数量
                    vo.setPlanUncheckAmountSum(e.getSurplusNumsSum()==null?0:e.getSurplusNumsSum().doubleValue());// 计划剩余数量
                    vo.setStockAmountSum(e.getStockAmountSum()==null?0:e.getStockAmountSum().doubleValue());// 库存数量
                    vo.setPurchaseAmountSum(e.getOrderNumsSum()==null?0:e.getOrderNumsSum().doubleValue());// 订单数量
                    vo.setPurchaseCheckAmountSum(e.getReceiveNumsSum()==null?0:e.getReceiveNumsSum().doubleValue());// 接收数量
                    vo.setSmartStatus(e.getSmartStatus()==null?0:Integer.parseInt(e.getSmartStatus()));
                    list.add(vo);
            });
            purchase.setPurchaseInfoList(list);
        }

        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(purchase).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方订单异常!");
        }
    }


    /**
     * 弃审删除供方订单
     *
     * @param headers
     *
     */
    public CommonResponse<String>  pushDelOrder(Map<String, String> headers,OrderEntity orderEntity){
        String url = wjDelOrderUrl;
        String pkPurchase = String.valueOf(orderEntity.getId());
        Map<String,String> map = new HashMap<>();
        map.put("pkPurchase",pkPurchase);
        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + pkPurchase);
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.get(url, map, headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方订单异常!");
        }
    }

    @Override
    public String queryContractCodeById(String contractId) {
        return orderMapper.queryContractCodeById(contractId);
    }

    @Override
    public void delete(List<OrderVO> vos) {
        List<Long> orderIds = vos.stream().map(OrderVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<OrderDetailEntity> lambdaOrderEntity = Wrappers.<OrderDetailEntity>lambdaQuery();
        lambdaOrderEntity.in(OrderDetailEntity::getOrderId, orderIds);
        List<OrderDetailEntity> orderDetailEntityList = orderDetailService.list(lambdaOrderEntity);
        List<Long> reviewDetailIdList = orderDetailEntityList.stream().map(OrderDetailEntity::getReviewDetailId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper<ReviewDetailEntity> lambdaRevieEntity = Wrappers.<ReviewDetailEntity>lambdaQuery();
        lambdaRevieEntity.in(ReviewDetailEntity::getId, reviewDetailIdList);
        List<ReviewDetailEntity> reviewDetailEntityList = reviewDetailService.list(lambdaRevieEntity);
        Map<Long, List<OrderDetailEntity>> orderDetailIdMap = orderDetailEntityList.stream().collect(Collectors.groupingBy(OrderDetailEntity::getReviewDetailId));
        for (ReviewDetailEntity reviewDetailEntity : reviewDetailEntityList){
            List<OrderDetailEntity> orderDetailDelEntityList = orderDetailIdMap.get(reviewDetailEntity.getId());
            BigDecimal orderNum = orderDetailDelEntityList.stream().map(OrderDetailEntity::getOrderNumsSum)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            reviewDetailEntity.setOrderNum(reviewDetailEntity.getOrderNum().subtract(orderNum));

        }

        reviewDetailService.saveOrUpdateBatch(reviewDetailEntityList);
        //删除
        super.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);

}

    @Override
    public OrderVO updateOrderIgnore(Long id, boolean isIgnore) {
        LambdaUpdateWrapper<OrderEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(OrderEntity::getId, id);
        updateWrapper.set(OrderEntity::getIgnoreFlag, isIgnore ? 1 : 0);
        update(updateWrapper);
        return BeanMapper.map(selectById(id), OrderVO.class);
    }
}
