package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service("plan")
public class PlanBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${mro.addr}")
	private String addr;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IPlanService planService;

	@Autowired
	private ThirdSystemUtils thirdSystemUtils;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return planService.pushToMro(billId);
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//合同是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PlanEntity planEntity = planService.selectById(billId);
		if(MaterialTypeEnum.MRO.getCode() == planEntity.getMaterialType()){
			Map<String, String> headers = new HashMap<>();

			thirdSystemUtils.getMroSign(headers);

			if(StringUtils.isBlank(planEntity.getHistoryId())){
				throw new BusinessException("该计划MRO主键为空");
			}
			String mroUrl = addr + "/iec/v1/purchase_plan/update/status";
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("id", planEntity.getHistoryId());
			jsonObject.put("originStatus", "0".equals(planEntity.getPlanFlag()) ? "OFF" : "ON");
			jsonObject.put("targetStatus", "DELETED");
			try {
				String responseStr = HttpTookit.postByJson(mroUrl, jsonObject.toJSONString(), headers);
				logger.info("afterAbstainingProcessor " + responseStr);
				JSONObject json = JSONObject.parseObject(responseStr);
				if(200 == json.getInteger("code") && true == json.getBoolean("success")){
					logger.info("删除MRO计划成功");
				}else{
					throw new BusinessException(json.getString("message"));
				}
			} catch (Exception e) {
				throw new BusinessException(e.getMessage());
			}
		}
		return CommonResponse.success();
	}

}
