package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.ReviewChangeEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailEntity;
import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IReviewChangeService;
import com.ejianc.business.wzxt.service.IReviewService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("review")
public class ReviewBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IReviewService reviewService;
	@Autowired
	private IReviewChangeService reviewChangeService;
	@Autowired
	private IOrderService orderService;


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		ReviewEntity reviewEntity = reviewService.selectById(billId);
		List<ReviewDetailEntity> reviewDetailList = reviewEntity.getReviewDetailList();
		if (CollectionUtils.isNotEmpty(reviewDetailList)) {
			List<String> numList = new ArrayList<>();
			List<String> rationRateList = new ArrayList<>();
			List<String> targetRateList = new ArrayList<>();
			for(ReviewDetailEntity detailEntity : reviewDetailList){
				if (null != detailEntity.getParentId() && null == detailEntity.getReviewNum()) {
					numList.add(detailEntity.getDetailIndex());
				}
				if (null == detailEntity.getParentId() && null == detailEntity.getRationRate()) {
					rationRateList.add(detailEntity.getDetailIndex());
				}
				if (null == detailEntity.getParentId() && null == detailEntity.getTargetRate()) {
					targetRateList.add(detailEntity.getDetailIndex());
				}
			}
			if (CollectionUtils.isNotEmpty(numList)) {
				return CommonResponse.error("序号[" + StringUtils.join(numList, ",") + "]的[复核数量]为空，不允许提交!");
			}
			if (CollectionUtils.isNotEmpty(rationRateList)) {
				return CommonResponse.error("序号[" + StringUtils.join(rationRateList, ",") + "]的[定额损耗率]为空，不允许提交!");
			}
			if (CollectionUtils.isNotEmpty(targetRateList)) {
				return CommonResponse.error("序号[" + StringUtils.join(targetRateList, ",") + "]的[目标节约率]为空，不允许提交!");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ReviewEntity reviewEntity = reviewService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();

		reviewEntity.setCommitDate(new Date());
		reviewEntity.setCommitUserCode(userContext.getUserCode());
		reviewEntity.setCommitUserName(userContext.getUserName());
		reviewService.saveOrUpdate(reviewEntity, false);

		return CommonResponse.success("用量复核审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(state)) {
			ReviewEntity reviewEntity = reviewService.selectById(billId);
			List<ReviewDetailEntity> reviewDetailList = reviewEntity.getReviewDetailList();
			if (CollectionUtils.isNotEmpty(reviewDetailList)) {
				List<String> numList = new ArrayList<>();
				List<String> rationRateList = new ArrayList<>();
				List<String> targetRateList = new ArrayList<>();
				for(ReviewDetailEntity detailEntity : reviewDetailList){
					if (null != detailEntity.getParentId() && null == detailEntity.getReviewNum()) {
						numList.add(detailEntity.getDetailIndex());
					}
					if (null == detailEntity.getParentId() && null == detailEntity.getRationRate()) {
						rationRateList.add(detailEntity.getDetailIndex());
					}
					if (null == detailEntity.getParentId() && null == detailEntity.getTargetRate()) {
						targetRateList.add(detailEntity.getDetailIndex());
					}
				}
				if (CollectionUtils.isNotEmpty(numList)) {
					return CommonResponse.error("序号[" + StringUtils.join(numList, ",") + "]的[复核数量]为空，不允许提交!");
				}
				if (CollectionUtils.isNotEmpty(rationRateList)) {
					return CommonResponse.error("序号[" + StringUtils.join(rationRateList, ",") + "]的[定额损耗率]为空，不允许提交!");
				}
				if (CollectionUtils.isNotEmpty(targetRateList)) {
					return CommonResponse.error("序号[" + StringUtils.join(targetRateList, ",") + "]的[目标节约率]为空，不允许提交!");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReviewEntity reviewEntity = reviewService.selectById(billId);
		reviewEntity.setEffectiveDate(new Date());
		if(state == 1) {
			//直审时记录
			UserContext userContext = sessionManager.getUserContext();
			reviewEntity.setCommitDate(new Date());
			reviewEntity.setCommitUserCode(userContext.getUserCode());
			reviewEntity.setCommitUserName(userContext.getUserName());
		}
		reviewService.saveOrUpdate(reviewEntity, false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReviewEntity reviewEntity = reviewService.selectById(billId);
		LambdaQueryWrapper<ReviewChangeEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(ReviewChangeEntity::getProjectId, reviewEntity.getProjectId());
		if (reviewChangeService.count(queryWrapper) > 0) {
			return CommonResponse.error("该单据存在变更单，不允许撤回！");
		}
		LambdaQueryWrapper<OrderEntity> orderQuery = new LambdaQueryWrapper<>();
		orderQuery.eq(OrderEntity::getProjectId, reviewEntity.getProjectId());
		if (orderService.count(orderQuery) > 0) {
			return CommonResponse.error("该单据存在订单，不允许撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
