package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.enums.ChangeTypeEnum;
import com.ejianc.business.wzxt.service.IReviewChangeHisService;
import com.ejianc.business.wzxt.service.IReviewChangeService;
import com.ejianc.business.wzxt.service.IReviewDetailService;
import com.ejianc.business.wzxt.service.IReviewService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.classgen.asm.indy.InvokeDynamicWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("reviewChange")
public class ReviewChangeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IReviewService reviewService;
	@Autowired
	private IReviewDetailService reviewDetailService;
	@Autowired
	private IReviewChangeService reviewChangeService;
	@Autowired
	private IReviewChangeHisService reviewChangeHisService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		ReviewChangeEntity reviewEntity = reviewChangeService.selectById(billId);
		List<ReviewDetailChangeEntity> reviewDetailList = reviewEntity.getReviewDetailList();
		if (CollectionUtils.isNotEmpty(reviewDetailList)) {
			List<String> numList = new ArrayList<>();
			List<String> rationRateList = new ArrayList<>();
			List<String> targetRateList = new ArrayList<>();
			for(ReviewDetailChangeEntity detailEntity : reviewDetailList){
				if (null != detailEntity.getParentId() && null == detailEntity.getReviewNum()) {
					numList.add(detailEntity.getDetailIndex());
				}
				if (null == detailEntity.getParentId() && null == detailEntity.getRationRate()) {
					rationRateList.add(detailEntity.getDetailIndex());
				}
				if (null == detailEntity.getParentId() && null == detailEntity.getTargetRate()) {
					targetRateList.add(detailEntity.getDetailIndex());
				}
			}
			if (CollectionUtils.isNotEmpty(numList)) {
				return CommonResponse.error("序号[" + StringUtils.join(numList, ",") + "]的[复核数量]为空，不允许提交!");
			}
			if (CollectionUtils.isNotEmpty(rationRateList)) {
				return CommonResponse.error("序号[" + StringUtils.join(rationRateList, ",") + "]的[定额损耗率]为空，不允许提交!");
			}
			if (CollectionUtils.isNotEmpty(targetRateList)) {
				return CommonResponse.error("序号[" + StringUtils.join(targetRateList, ",") + "]的[目标节约率]为空，不允许提交!");
			}
		}
		logger.info("用量复核变更提交审批回调--billId:{}, state: {}", billId, state);

		//此处billId即为单据Id
		ReviewChangeEntity reviewChangeEntity = reviewChangeService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		//设置提交人信息
		reviewChangeEntity.setCommitDate(new Date());
		reviewChangeEntity.setCommitUserCode(userContext.getUserCode());
		reviewChangeEntity.setCommitUserName(userContext.getUserName());

		reviewChangeService.saveOrUpdate(reviewChangeEntity, false);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("用量复核变更撤回回调处理：billId: {}, state: {}", billId, state);

		ReviewChangeEntity reviewChangeEntity = reviewChangeService.selectById(billId);

		//清空总计划变更提交人信息
		reviewChangeEntity.setCommitUserName(null);
		reviewChangeEntity.setCommitUserCode(null);
		reviewChangeEntity.setCommitDate(null);

		reviewChangeService.saveOrUpdate(reviewChangeEntity, false);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(state)) {
			ReviewChangeEntity reviewEntity = reviewChangeService.selectById(billId);
			List<ReviewDetailChangeEntity> reviewDetailList = reviewEntity.getReviewDetailList();
			if (CollectionUtils.isNotEmpty(reviewDetailList)) {
				List<String> numList = new ArrayList<>();
				List<String> rationRateList = new ArrayList<>();
				List<String> targetRateList = new ArrayList<>();
				for(ReviewDetailChangeEntity detailEntity : reviewDetailList){
					if (null != detailEntity.getParentId() && null == detailEntity.getReviewNum()) {
						numList.add(detailEntity.getDetailIndex());
					}
					if (null == detailEntity.getParentId() && null == detailEntity.getRationRate()) {
						rationRateList.add(detailEntity.getDetailIndex());
					}
					if (null == detailEntity.getParentId() && null == detailEntity.getTargetRate()) {
						targetRateList.add(detailEntity.getDetailIndex());
					}
				}
				if (CollectionUtils.isNotEmpty(numList)) {
					return CommonResponse.error("序号[" + StringUtils.join(numList, ",") + "]的[复核数量]为空，不允许提交!");
				}
				if (CollectionUtils.isNotEmpty(rationRateList)) {
					return CommonResponse.error("序号[" + StringUtils.join(rationRateList, ",") + "]的[定额损耗率]为空，不允许提交!");
				}
				if (CollectionUtils.isNotEmpty(targetRateList)) {
					return CommonResponse.error("序号[" + StringUtils.join(targetRateList, ",") + "]的[目标节约率]为空，不允许提交!");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("总计划变更审批完成回调处理：billId: {}, state: {}", billId, state);
		//查询变更计划
		ReviewChangeEntity reviewChangeEntity = reviewChangeService.selectById(billId);
		ReviewEntity newPlanEntity = null;
		//查询原计划
		ReviewEntity oldReview = reviewService.selectById(reviewChangeEntity.getSourceReviewId());
		//变更复核附件复制到主复核
		CommonResponse<String> stringCommonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "EJCBT202210000045", "reviewFile", String.valueOf(oldReview.getId()), "EJCBT202210000040", "reviewFile");
		if(!stringCommonResponse.isSuccess()){
			logger.info("复核变更附件复制到主附件------", JSONObject.toJSONString(stringCommonResponse));
		}else {
			logger.info("复核更附件复制到主附件------", JSONObject.toJSONString(stringCommonResponse));
		}

		/*处理变更复核主表信息*/
		if(state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
			//直审时记录
			UserContext userContext = sessionManager.getUserContext();
			//设置提交人信息
			reviewChangeEntity.setCommitDate(new Date());
			reviewChangeEntity.setCommitUserCode(userContext.getUserCode());
			reviewChangeEntity.setCommitUserName(userContext.getUserName());
		}
		//设置复核变更单据生效时间
		reviewChangeEntity.setEffectiveDate(new Date());

		//设置复核变更单据生效时间
		reviewChangeEntity.setEffectiveDate(new Date());

		//1、复制复核信息到复核记录
		ReviewChangeHisEntity recordEntity = BeanMapper.map(oldReview, ReviewChangeHisEntity.class);
		logger.info("复核变更审批完成回调, 复核变更信息：【{}】, 变更前复核信息: 【{}】", JSON.toJSONString(reviewChangeEntity), JSON.toJSONString(oldReview));

		//设置复核Id
		recordEntity.setSourceReviewId(oldReview.getId());
		//Id置为空
		recordEntity.setId(null);
		//子表处理

		if(CollectionUtils.isNotEmpty(recordEntity.getReviewDetailList())) {
			List<ReviewDetailChangeHisEntity> reviewDetailList = recordEntity.getReviewDetailList();
			Map<Long, List<ReviewDetailChangeHisEntity>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeHisEntity::getParentId));
			List<ReviewDetailChangeHisEntity> hisEntityList = new ArrayList<>();
			for (ReviewDetailChangeHisEntity reviewDetailChangeHisEntity : reviewDetailList){
				if (reviewDetailChangeHisEntity.getParentId() == null){
					List<ReviewDetailChangeHisEntity> childList = childMap.get(reviewDetailChangeHisEntity.getId());
					reviewDetailChangeHisEntity.setId(IdWorker.getId());
					childList.forEach(p->p.setParentId(reviewDetailChangeHisEntity.getId()));
					childList.forEach(p->p.setId(IdWorker.getId()));
					hisEntityList.add(reviewDetailChangeHisEntity);
					hisEntityList.addAll(childList);
				}
			}
			recordEntity.setReviewDetailList(hisEntityList);
		}

		/*记录主表信息处理*/
		//设置编制人等信息
		recordEntity.setCreateUserCode(reviewChangeEntity.getCreateUserCode());
		recordEntity.setCreateTime(reviewChangeEntity.getCreateTime());
		recordEntity.setCreateUserName(reviewChangeEntity.getCreateUserName());
		recordEntity.setModifyUserName(reviewChangeEntity.getModifyUserName());
		recordEntity.setUpdateTime(reviewChangeEntity.getUpdateTime());
		recordEntity.setUpdateUserCode(reviewChangeEntity.getUpdateUserCode());
		recordEntity.setCommitDate(reviewChangeEntity.getCommitDate());
		recordEntity.setCommitUserCode(reviewChangeEntity.getCommitUserCode());
		recordEntity.setCommitUserName(reviewChangeEntity.getCommitUserName());
		recordEntity.setEffectiveDate(reviewChangeEntity.getEffectiveDate());
		recordEntity.setChangeReviewId(reviewChangeEntity.getId());
		recordEntity.setChangeUserName(reviewChangeEntity.getChangeUserName());
		recordEntity.setChangeReason(reviewChangeEntity.getChangeReason());
		//总计划变更记录保存
		reviewChangeHisService.saveOrUpdate(recordEntity, false);

		//变更计划信息更新
		reviewChangeService.saveOrUpdate(reviewChangeEntity, false);
		//修改总计划字段  复制变更计划{回显原计划用}
		newPlanEntity = BeanMapper.map(oldReview, ReviewEntity.class);
		/*
		 * 更新主表信息
		 * */
		//变更状态-已变更
		newPlanEntity.setChangeState(2);
		//清空当前变更复核id
		newPlanEntity.setCurChangingReviewId(null);
		//初始创建信息
//		newPlanEntity.setCreateUserName(oldReview.getCreateUserName());
//		newPlanEntity.setCreateUserCode(oldReview.getCreateUserCode());
//		newPlanEntity.setCreateTime(oldReview.getCreateTime());
//		newPlanEntity.setId(oldReview.getId());
//		newPlanEntity.setVersion(oldReview.getVersion());
		newPlanEntity.setChangeVersion(reviewChangeEntity.getChangeVersion());
		//子表信息设置
		//
		List<ReviewDetailChangeEntity> reviewChangeDetailList = reviewChangeEntity.getReviewDetailList();
		Map<Long, ReviewDetailChangeEntity> changeEntityMap = reviewChangeDetailList.stream().filter(s -> s.getChangeType().equals(ChangeTypeEnum.变更项.getCode())).
				collect(Collectors.toMap(ReviewDetailChangeEntity::getTargetId, Function.identity()));
		Map<Long, List<ReviewDetailChangeEntity>> newChangeEntityMap = reviewChangeDetailList.stream().filter(s -> s.getChangeType().equals(ChangeTypeEnum.增补项.getCode()) && s.getParentId() != null).
				collect(Collectors.groupingBy(ReviewDetailChangeEntity::getParentId));
        List<ReviewDetailChangeEntity> reviewDetailChangeParentList = reviewChangeDetailList.stream().filter(s -> s.getParentId() == null).
                collect(Collectors.toList());
		Map<Long, ReviewDetailChangeEntity> changeEntityAllMap = reviewChangeDetailList.stream().
				collect(Collectors.toMap(ReviewDetailChangeEntity::getId, Function.identity()));



        List<ReviewDetailEntity> oldReviewDetailList = oldReview.getReviewDetailList();
		List<ReviewDetailEntity> newReviewDetailList = new ArrayList<>();
		//变更项处理
		for (ReviewDetailEntity reviewDetailEntity : oldReviewDetailList){
			if (changeEntityMap.containsKey(reviewDetailEntity.getId())){
				ReviewDetailChangeEntity reviewDetailChangeEntity = changeEntityMap.get(reviewDetailEntity.getId());
				if (reviewDetailEntity.getParentId() == null){
					reviewDetailEntity.setPlanNum(reviewDetailChangeEntity.getPlanNum());
					reviewDetailEntity.setReviewNum(reviewDetailChangeEntity.getReviewNum());
					reviewDetailEntity.setRationRate(reviewDetailChangeEntity.getRationRate());
					reviewDetailEntity.setRationNum(reviewDetailChangeEntity.getRationNum());
					reviewDetailEntity.setTargetNum(reviewDetailChangeEntity.getTargetNum());
					reviewDetailEntity.setTargetRate(reviewDetailChangeEntity.getTargetRate());
					newReviewDetailList.add(reviewDetailEntity);
				}
				if (reviewDetailEntity.getParentId() != null){
					reviewDetailEntity.setPlanNum(reviewDetailChangeEntity.getPlanNum());
					reviewDetailEntity.setReviewNum(reviewDetailChangeEntity.getReviewNum());
					newReviewDetailList.add(reviewDetailEntity);
				}

			}

		}
		//新增项处理
        if (CollectionUtils.isNotEmpty(reviewDetailChangeParentList)){
		    for (ReviewDetailChangeEntity reviewDetailChangeEntity : reviewDetailChangeParentList){
				if (newChangeEntityMap.containsKey(reviewDetailChangeEntity.getId())){
				List<ReviewDetailChangeEntity> reviewDetailChangeEntities = newChangeEntityMap.get(reviewDetailChangeEntity.getId());
				if (reviewDetailChangeEntity.getChangeType().equals(ChangeTypeEnum.变更项.getCode())){

					for (ReviewDetailChangeEntity reviewDetailChangeChildEntity : reviewDetailChangeEntities){
						reviewDetailChangeChildEntity.setParentId(reviewDetailChangeEntity.getTargetId());
						reviewDetailChangeChildEntity.setId(IdWorker.getId());
						ReviewDetailEntity detailEntity = BeanMapper.map(reviewDetailChangeChildEntity, ReviewDetailEntity.class);
						newReviewDetailList.add(detailEntity);
					}

				}

				if (reviewDetailChangeEntity.getChangeType().equals(ChangeTypeEnum.增补项.getCode())){
					reviewDetailChangeEntity.setId(IdWorker.getId());
					for (ReviewDetailChangeEntity reviewDetailChangeChildEntity : reviewDetailChangeEntities){
						reviewDetailChangeChildEntity.setParentId(reviewDetailChangeEntity.getId());
						reviewDetailChangeChildEntity.setId(IdWorker.getId());
						ReviewDetailEntity detailEntity = BeanMapper.map(reviewDetailChangeChildEntity, ReviewDetailEntity.class);
						newReviewDetailList.add(detailEntity);
					}
					ReviewDetailEntity reviewDetailEntity = BeanMapper.map(reviewDetailChangeEntity, ReviewDetailEntity.class);
					newReviewDetailList.add(reviewDetailEntity);
				}
				}
            }

        }
//		newPlanEntity.setReviewDetailList(newReviewDetailList);
		reviewService.saveOrUpdate(newPlanEntity);
		reviewDetailService.saveOrUpdateBatch(newReviewDetailList);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("当前单据不允许撤回！");

	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
