package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.ReviewChangeEntity;
import com.ejianc.business.wzxt.bean.ReviewDetailChangeEntity;
import com.ejianc.business.wzxt.bean.ReviewEntity;
import com.ejianc.business.wzxt.mapper.ReviewChangeMapper;
import com.ejianc.business.wzxt.service.IReviewChangeService;
import com.ejianc.business.wzxt.service.IReviewService;
import com.ejianc.business.wzxt.vo.ReviewChangeVO;
import com.ejianc.business.wzxt.vo.ReviewDetailChangeVO;
import com.ejianc.business.wzxt.vo.ReviewDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 复核变更实体
 *
 * @author generator
 *
 */
@Service("reviewChangeService")
public class ReviewChangeServiceImpl extends BaseServiceImpl<ReviewChangeMapper, ReviewChangeEntity> implements IReviewChangeService{

    private static final String BILL_CODE = "xell-review-change-code";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ReviewChangeMapper reviewChangeMapper;
    @Autowired
    private IReviewService reviewService;
    @Autowired
    private SessionManager sessionManager;
    @Override
    public CommonResponse<ReviewChangeVO> saveOrUpdatReview(ReviewChangeVO saveOrUpdateVO, boolean b) {
        //校验项目是否存在未完成的变更单存在
//        ReviewChangeEntity reviewChangeEntity = getUnFinishedChange(saveOrUpdateVO.getSourceReviewId());

//        if (null != reviewChangeEntity && (null == saveOrUpdateVO.getId() || !reviewChangeEntity.getId().equals(saveOrUpdateVO.getId()))) {
//            throw new BusinessException("保存失败，该项目存在未完成的变更复核！");
//        }

        if(StringUtils.isEmpty(saveOrUpdateVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        ReviewEntity reviewEntity = reviewService.selectById(saveOrUpdateVO.getSourceReviewId());
        UserContext userContext = sessionManager.getUserContext();
        ReviewChangeEntity saveEntity = BeanMapper.map(saveOrUpdateVO, ReviewChangeEntity.class);
//        saveEntity.setReviewDetailList(BeanMapper.mapList(saveOrUpdateVO.getReviewDetailList(),ReviewDetailChangeEntity.class));
        if (null == saveOrUpdateVO.getId()) {

            saveEntity.setId(IdWorker.getId());
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(reviewEntity.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setReviewCode(reviewEntity.getBillCode());
            saveEntity.setCreateUserName(userContext.getUserName());

        }
        else {
//            saveEntity = super.getById(saveOrUpdateVO.getId());
            saveEntity.setModifyUserName(userContext.getUserName());
            //设置子表信息关系
//            List<ReviewDetailChangeVO> reviewDetailList = saveOrUpdateVO.getReviewDetailList();
//            List<ReviewDetailChangeEntity> reviewDetailChangeEntityList  = new ArrayList<>();

//            if (CollectionUtils.isNotEmpty(reviewDetailList)){
//                List<ReviewDetailChangeEntity> reviewDetailChangeEntities = BeanMapper.mapList(reviewDetailList, ReviewDetailChangeEntity.class);
//                for(ReviewDetailChangeEntity reviewDetailChangeEntity : reviewDetailChangeEntities){
//                    if (reviewDetailChangeEntity.getParentId() != null){
//                        if (reviewDetailChangeEntity.getChangeType().equals(ChangeTypeEnum.变更项.getCode())){
//                            reviewDetailChangeEntity.setTargetId(reviewDetailChangeEntity.getId());
//                        }
//                        reviewDetailChangeEntity.setId(IdWorker.getId());
////                        reviewDetailChangeEntityList.add(reviewDetailChangeEntity);
//                    }
//                    if (reviewDetailChangeEntity.getParentId() == null){
//                        if (reviewDetailChangeEntity.getChangeType().equals(ChangeTypeEnum.变更项.getCode())){
//                            reviewDetailChangeEntity.setTargetId(reviewDetailChangeEntity.getId());
//                        }
//                        reviewDetailChangeEntity.setId(IdWorker.getId());
////                        reviewDetailChangeEntityList.add(reviewDetailChangeEntity);
//                    }
//
//                    //子集信息处理
//                    List<ReviewDetailChangeEntity> children = reviewDetailChangeEntity.getChildren();
//                    for (ReviewDetailChangeEntity reviewDetailChangeEntityChild : children){
//                        if (reviewDetailChangeEntityChild.getChangeType().equals(ChangeTypeEnum.变更项.getCode())){
//                            reviewDetailChangeEntityChild.setTargetId(reviewDetailChangeEntityChild.getId());
//                            reviewDetailChangeEntityChild.setParentId(reviewDetailChangeEntity.getId());
//                        }
//                        reviewDetailChangeEntityChild.setId(IdWorker.getId());
//                        reviewDetailChangeEntityList.add(reviewDetailChangeEntityChild);
//                    }
//                }
//                saveEntity.setReviewDetailList(reviewDetailChangeEntityList);
//            }
        }

        super.saveOrUpdate(saveEntity, false);

        ReviewEntity review = reviewService.selectById(saveEntity.getSourceReviewId());
        if (1 != review.getChangeState()) {
            review.setChangeState(1);
            review.setCurChangingReviewId(saveEntity.getId());
            reviewService.saveOrUpdate(review, false);
        }
        //处理子表信息

        List<ReviewDetailChangeEntity> reviewDetailList = saveEntity.getReviewDetailList();
        Map<Long, List<ReviewDetailChangeEntity>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeEntity::getParentId));
        List<ReviewDetailChangeEntity> reviewDetailVOS = reviewDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());

        for (ReviewDetailChangeEntity reviewDetailVO : reviewDetailVOS){
            List<ReviewDetailChangeEntity> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        saveEntity.setReviewDetailList(reviewDetailVOS);
        return CommonResponse.success("保存成功！", BeanMapper.map(saveEntity, ReviewChangeVO.class));

    }
    @Override
    public ReviewChangeEntity getUnFinishedChange(Long sourceReviewId) {
        QueryWrapper<ReviewChangeEntity> query = new QueryWrapper<>();
        query.eq("source_review_id", sourceReviewId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return reviewChangeMapper.selectOne(query);
    }

    @Override
    public ReviewChangeVO queryDetail(Long id) {
        ReviewChangeEntity entity = super.selectById(id);
        ReviewChangeVO vo = BeanMapper.map(entity, ReviewChangeVO.class);
        List<ReviewDetailChangeVO> reviewDetailList = vo.getReviewDetailList();
        Map<Long, List<ReviewDetailChangeVO>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailChangeVO::getParentId));
        List<ReviewDetailChangeVO> reviewDetailVOS = reviewDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());

        for (ReviewDetailChangeVO reviewDetailVO : reviewDetailVOS){
            List<ReviewDetailChangeVO> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        vo.setReviewDetailList(reviewDetailVOS);

        return vo;
    }

    @Override
    public CommonResponse<ReviewChangeVO> getChangeInfo(Long id) {
        //获取变更信息
        ReviewEntity reviewEntity = reviewService.selectById(id);
        ReviewChangeVO reviewChangeVO = new ReviewChangeVO();
        reviewChangeVO.setProjectId(reviewEntity.getProjectId());
        reviewChangeVO.setProjectSourceId(reviewEntity.getProjectSourceId());
        reviewChangeVO.setProjectName(reviewEntity.getProjectName());
        reviewChangeVO.setOrgId(reviewEntity.getOrgId());
        reviewChangeVO.setOrgSourceId(reviewEntity.getOrgSourceId());
        reviewChangeVO.setOrgName(reviewEntity.getOrgName());
        reviewChangeVO.setParentOrgId(reviewEntity.getParentOrgId());
        reviewChangeVO.setParentOrgSourceId(reviewEntity.getParentOrgSourceId());
        reviewChangeVO.setSourceReviewId(reviewEntity.getId());
        UserContext userContext = sessionManager.getUserContext();
        reviewChangeVO.setEmployeeId(userContext.getUserId());
        reviewChangeVO.setEmployeeName(userContext.getUserName());
        reviewChangeVO.setCreateDate(new Date());


        //获取子表信息
        CommonResponse<List<ReviewDetailVO>> reviewInfo = reviewService.getReviewInfo(reviewEntity.getProjectId(), reviewEntity.getId());
        List<ReviewDetailVO> data = reviewInfo.getData();
        reviewChangeVO.setReviewDetailInfoList(data);
        return  CommonResponse.success("保存成功！",reviewChangeVO);
    }
}
