package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.enums.ChangeTypeEnum;
import com.ejianc.business.wzxt.mapper.ReviewMapper;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.vo.ReviewChangeHisVO;
import com.ejianc.business.wzxt.vo.ReviewDetailVO;
import com.ejianc.business.wzxt.vo.ReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 复核实体
 *
 * @author generator
 *
 */
@Service("reviewService")
public class ReviewServiceImpl extends BaseServiceImpl<ReviewMapper, ReviewEntity> implements IReviewService{
    private static final String BILL_CODE = "xell-review-code";//此处需要根据实际修改
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ReviewMapper reviewMapper;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private IReviewDetailService reviewDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IReviewChangeHisService reviewChangeHisService;
    @Override
    public ReviewVO saveOrUpdate(ReviewVO saveOrUpdateVO) {
        //查询项目部上级组织的的来源id
        CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(saveOrUpdateVO.getParentOrgId());
        if(!orgParentVo.isSuccess()) {
            throw new BusinessException("查询组织详情失败");
        }

        saveOrUpdateVO.setParentOrgSourceId(orgParentVo.getData().getSourceId());
        ReviewEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        UserContext userContext = sessionManager.getUserContext();
        ReviewEntity saveEntity = null;
        if(null == saveOrUpdateVO.getId()) {
            saveEntity = BeanMapper.map(saveOrUpdateVO, ReviewEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为未变更
            saveEntity.setChangeState(0);
            //设置为自由态
//            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(1);
            //设置编制人
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = BeanMapper.map(saveOrUpdateVO, ReviewEntity.class);
        }
        //处理子表信息
        List<ReviewDetailEntity> reviewDetailList = entity.getReviewDetailList();
//        List<ReviewDetailEntity> reviewDetailChildList = new ArrayList<>();
//        for (ReviewDetailEntity reviewDetailEntity : reviewDetailList){
//            List<ReviewDetailEntity> children = reviewDetailEntity.getChildren();
//            reviewDetailChildList.addAll(children);
//        }
//        reviewDetailList.addAll(reviewDetailChildList);
        saveEntity.setReviewDetailList(reviewDetailList);
        super.saveOrUpdate(saveEntity, false);

        //处理子表成树形
        ReviewVO vo = BeanMapper.map(saveEntity, ReviewVO.class);
        List<ReviewDetailVO> reviewDetailListss = vo.getReviewDetailList();
        Map<Long, List<ReviewDetailVO>> childMap = reviewDetailListss.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailVO::getParentId));
        List<ReviewDetailVO> reviewDetailVOS = reviewDetailListss.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());

        for (ReviewDetailVO reviewDetailVO : reviewDetailVOS){
            List<ReviewDetailVO> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        vo.setReviewDetailList(reviewDetailVOS);

        return vo;

    }

    @Override
    public CommonResponse<List<ReviewDetailVO>> getReviewInfo(Long projectId, Long billId) {
        //判断是否重复
        //校验项目是否已有总计划
        QueryWrapper<ReviewEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        ReviewEntity reviewEntity = reviewMapper.selectOne(query);

        if(null != reviewEntity && (null == billId || !reviewEntity.getId().equals(billId))) {
            throw new BusinessException("该项目下已存在用料复核，请勿重复添加！");
        }
        //获取子表信息, 汇总二级树
        List list = new ArrayList();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<PlanEntity> lambdaPlan = Wrappers.<PlanEntity>lambdaQuery();
        lambdaPlan.eq(PlanEntity::getProjectId, projectId);
        lambdaPlan.in(PlanEntity::getBillState, list);
        List<PlanEntity> planEntityList = planService.list(lambdaPlan);
        if (CollectionUtils.isEmpty(planEntityList)){
            throw new BusinessException("没有审批通过的计划！");
        }

        List<Long> planIds = planEntityList.stream().map(PlanEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<PlanDetailEntity> lambdaPlanDetail = Wrappers.<PlanDetailEntity>lambdaQuery();
        lambdaPlanDetail.in(PlanDetailEntity::getPlanId, planIds);
        List<PlanDetailEntity> planEntityDetailList = planDetailService.list(lambdaPlanDetail);
        Map<String, List<ReviewDetailEntity>> reviewDetailMap = new HashMap<>();
        Map<Long, List<OrderDetailEntity>> orderDetailMap = new HashMap<>();
        Map<Long, ReviewDetailEntity> reviewDetailChildEntityMap = new HashMap<>();
        List<ReviewDetailVO> planDetailList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(planEntityDetailList)){
            //查询复核信息
            LambdaQueryWrapper<ReviewEntity> lambdaReviewEntity = Wrappers.<ReviewEntity>lambdaQuery();
            lambdaReviewEntity.in(ReviewEntity::getProjectId, projectId);
            ReviewEntity reviewEntityOne = super.getOne(lambdaReviewEntity);

            if (reviewEntityOne != null){
//                List<Long> reviewIds = reviewEntityList.stream().map(ReviewEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<ReviewDetailEntity> lambdaReviewDetailEntity = Wrappers.<ReviewDetailEntity>lambdaQuery();
                lambdaReviewDetailEntity.eq(ReviewDetailEntity::getReviewId, reviewEntityOne.getId());
                List<ReviewDetailEntity> reviewDetailEntities = reviewDetailService.list(lambdaReviewDetailEntity);

                reviewDetailMap = reviewDetailEntities.stream().filter(map->map.getParentId() == null).collect(Collectors.groupingBy(
                        s -> s.getMaterialId() + "-"+s.getWbsId())
                );
                List<Long> reviewDetailIds = reviewDetailEntities.stream().
                        filter(map -> map.getParentId() == null).map(ReviewDetailEntity::getId).collect(Collectors.toList());

                reviewDetailChildEntityMap = reviewDetailEntities.stream().filter(map -> map.getParentId() != null).collect(Collectors.toMap(ReviewDetailEntity::getPlanDetailId, Function.identity()));

                //查询订单和验收数量
                LambdaQueryWrapper<OrderEntity> lambdaOrderEntity = Wrappers.<OrderEntity>lambdaQuery();
                lambdaOrderEntity.in(OrderEntity::getProjectId, projectId);
                List<OrderEntity> orderEntityList = orderService.list(lambdaOrderEntity);

                if (CollectionUtils.isNotEmpty(orderEntityList)){
                    List<Long> orderIds = orderEntityList.stream().map(OrderEntity::getId).collect(Collectors.toList());
                    LambdaQueryWrapper<OrderDetailEntity> lambdaOrderDetailEntity = Wrappers.<OrderDetailEntity>lambdaQuery();
                    lambdaOrderDetailEntity.in(OrderDetailEntity::getReviewDetailId, reviewDetailIds);
                    lambdaOrderDetailEntity.in(OrderDetailEntity::getOrderId, orderIds);
                    List<OrderDetailEntity> orderDetailEntityList = orderDetailService.list(lambdaOrderDetailEntity);

                    if (CollectionUtils.isNotEmpty(orderDetailEntityList)){
                        orderDetailMap = orderDetailEntityList.stream().collect(Collectors.groupingBy(OrderDetailEntity::getReviewDetailId));
                    }
                }
            }

            //获取计划主表信息
            Map<Long, PlanEntity> planMap = planEntityList.stream().collect(Collectors.toMap(PlanEntity::getId, Function.identity()));
            //根据分组
            Map<String, List<PlanDetailEntity>> map = planEntityDetailList.stream().collect(
            Collectors.groupingBy(
                    s -> s.getMaterialId().toString()+'-'+s.getWbsId()
            ));
            Map<String, List<ReviewDetailEntity>> finalReviewDetailMap = reviewDetailMap;
            Map<Long, List<OrderDetailEntity>> finalOrderDetailMap = orderDetailMap;
            Map<Long, ReviewDetailEntity> finalReviewDetailChildEntityMap = reviewDetailChildEntityMap;

            int parentIndex = 1;
            for(String key : map.keySet()){
                List<PlanDetailEntity> value = map.get(key);
                ReviewDetailVO reviewDetailVO = BeanMapper.map(value.stream().findFirst().get(),ReviewDetailVO.class);
                BigDecimal planNum = value.stream().map(PlanDetailEntity::getNums)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                reviewDetailVO.setDetailIndex(String.valueOf(parentIndex));
                parentIndex ++;
                reviewDetailVO.setPlanNum(planNum);
                reviewDetailVO.setId(IdWorker.getId());
                reviewDetailVO.setCreateTime(null);
                reviewDetailVO.setCreateUserCode(null);
                reviewDetailVO.setUpdateTime(null);
                reviewDetailVO.setUpdateUserCode(null);
                reviewDetailVO.setReviewId(reviewEntityOne == null ? null:reviewEntityOne.getId());

                //设置父级数据
                if (finalReviewDetailMap.containsKey(key)){
                    List<ReviewDetailEntity> reviewDetailEntities = finalReviewDetailMap.get(key);
                    ReviewDetailEntity reviewDetailEntity = reviewDetailEntities.stream().findFirst().get();
                    reviewDetailVO.setReviewNum(reviewDetailEntity.getReviewNum());
                    reviewDetailVO.setRationRate(reviewDetailEntity.getRationRate());
                    reviewDetailVO.setRationNum(reviewDetailEntity.getRationNum());
                    reviewDetailVO.setTargetRate(reviewDetailEntity.getTargetRate());
                    reviewDetailVO.setTargetNum(reviewDetailEntity.getTargetNum());
                    reviewDetailVO.setOccupyNum(reviewDetailEntity.getOccupyNum());
                    reviewDetailVO.setPlanId(null);
                    reviewDetailVO.setCheckNum(null);
//                    reviewDetailVO.setReviewId(reviewEntityOne == null ? null:reviewEntityOne.getId());
                    reviewDetailVO.setTargetId(reviewDetailEntity.getId());
                    reviewDetailVO.setChangeType(ChangeTypeEnum.变更项.getCode());

                    if (finalOrderDetailMap.containsKey(reviewDetailEntity.getId())){
                        List<OrderDetailEntity> orderDetailEntityList = finalOrderDetailMap.get(reviewDetailEntity.getId());
                        BigDecimal checkNum = orderDetailEntityList.stream().filter(s -> s.getCheckNumsSum() != null).map(OrderDetailEntity::getCheckNumsSum)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal orderNum = orderDetailEntityList.stream().filter(s -> s.getOrderNumsSum() != null).map(OrderDetailEntity::getOrderNumsSum)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                        reviewDetailVO.setOrderNum(orderNum);
                        reviewDetailVO.setCheckNum(checkNum);
                    }

                }else {
                    reviewDetailVO.setId(IdWorker.getId());
                    reviewDetailVO.setChangeType(ChangeTypeEnum.增补项.getCode());
                }

                List<ReviewDetailVO> reviewDetailVOS = BeanMapper.mapList(value, ReviewDetailVO.class);
                for (int i = 0; i < reviewDetailVOS.size(); i++) {
                    ReviewDetailVO reviewDetailChild = reviewDetailVOS.get(i);
                    reviewDetailChild.setDetailIndex(reviewDetailVO.getDetailIndex() + "." + (i + 1) );
                    reviewDetailChild.setPlanDetailId(reviewDetailChild.getId());
                    reviewDetailChild.setPlanName(planMap.get(reviewDetailChild.getPlanId()).getPlanName());
                    reviewDetailChild.setPlanBillCode(planMap.get(reviewDetailChild.getPlanId()).getBillCode());
                    reviewDetailChild.setPlanEmployeeName(planMap.get(reviewDetailChild.getPlanId()).getEmployeeName());
                    reviewDetailChild.setParentId(reviewDetailVO.getId());
                    reviewDetailChild.setPlanNum(reviewDetailChild.getNums());
                    reviewDetailChild.setReviewId(reviewEntityOne == null ? null:reviewEntityOne.getId());
                    reviewDetailChild.setId(IdWorker.getId());
                    //设置计划复核量
                    if (finalReviewDetailChildEntityMap.containsKey(reviewDetailChild.getPlanDetailId())){
                        ReviewDetailEntity reviewDetailEntity = finalReviewDetailChildEntityMap.get(reviewDetailChild.getPlanDetailId());
                        reviewDetailChild.setReviewNum(reviewDetailEntity.getReviewNum());
                        reviewDetailChild.setTargetId(reviewDetailEntity.getId());
                        reviewDetailChild.setChangeType(ChangeTypeEnum.变更项.getCode());
                    }else{
                        reviewDetailChild.setChangeType(ChangeTypeEnum.增补项.getCode());
                    }

                }
                reviewDetailVO.setChildren(reviewDetailVOS);
                planDetailList.add(reviewDetailVO);

            }
        }

        return CommonResponse.success("查询成功！",planDetailList);
    }

    @Override
    public ReviewVO queryDetail(Long id) {
        ReviewEntity entity = super.selectById(id);
        ReviewVO vo = BeanMapper.map(entity, ReviewVO.class);
        List<ReviewDetailVO> reviewDetailList = vo.getReviewDetailList();
        Map<Long, List<ReviewDetailVO>> childMap = reviewDetailList.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(ReviewDetailVO::getParentId));
        List<ReviewDetailVO> reviewDetailVOS = reviewDetailList.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());

        for (ReviewDetailVO reviewDetailVO : reviewDetailVOS){
            List<ReviewDetailVO> reviewDetailChildVOS = childMap.get(reviewDetailVO.getId());
            reviewDetailVO.setChildren(reviewDetailChildVOS);
        }
        List<ReviewDetailVO> sortDetails = reviewDetailVOS.stream().sorted(ReviewServiceImpl::compareProductNumbers).collect(Collectors.toList());
        vo.setReviewDetailList(sortDetails);

        //历史记录
        LambdaQueryWrapper<ReviewChangeHisEntity> hisEntity = Wrappers.<ReviewChangeHisEntity>lambdaQuery();
        hisEntity.in(ReviewChangeHisEntity::getSourceReviewId, id);
        List<ReviewChangeHisEntity> reviewChangeHisEntities = reviewChangeHisService.list(hisEntity);
        if (CollectionUtils.isNotEmpty(reviewChangeHisEntities)){
            List<ReviewChangeHisVO> reviewChangeHisVOS = BeanMapper.mapList(reviewChangeHisEntities, ReviewChangeHisVO.class);
            vo.setReviewChangeHisList(reviewChangeHisVOS);
        }
        return vo;
    }

    private static int compareProductNumbers(ReviewDetailVO reviewDetailVO, ReviewDetailVO reviewDetailVO1) {
        String s1 = reviewDetailVO.getDetailIndex();
        String s2 = reviewDetailVO1.getDetailIndex();
        String[] parts1 = s1.split("\\.");
        String[] parts2 = s2.split("\\.");

        int length = Math.max(parts1.length, parts2.length);

        for (int i = 0; i < length; i++) {
            int part1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int part2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;

            if (part1 != part2) {
                return Integer.compare(part1, part2);
            }
        }

        return 0;
    }
}
