package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.YzMaterialEntity;
import com.ejianc.business.wzxt.mapper.YzMaterialMapper;
import com.ejianc.business.wzxt.service.IYzMaterialService;
import com.ejianc.business.wzxt.util.MathUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 云筑物料实体
 *
 * @author generator
 *
 */


@Service("yzMaterialService")
public class YzMaterialServiceImpl extends BaseServiceImpl<YzMaterialMapper, YzMaterialEntity> implements IYzMaterialService{
    @Override
    public boolean saveList(List<CheckDetailEntity> checkList) {
        List<YzMaterialEntity> list = new ArrayList<>();
        for(CheckDetailEntity detail : checkList) {
            YzMaterialEntity yzMaterialEntity;
            QueryParam queryParamn = new QueryParam();
            queryParamn.getParams().put("yzMaterialCode", new Parameter(QueryParam.EQ, detail.getYzMaterialCode()));
            List<YzMaterialEntity> yzMaterialEntityList = queryList(queryParamn);
            if (yzMaterialEntityList.size() > 0) {
                yzMaterialEntity = yzMaterialEntityList.get(0);
            } else {
                yzMaterialEntity = new YzMaterialEntity();
            }
            yzMaterialEntity.setYzMaterialCode(detail.getYzMaterialCode());
            yzMaterialEntity.setYzMaterialName(detail.getYzMaterialName());
            yzMaterialEntity.setMaterialId(detail.getMaterialId());
            yzMaterialEntity.setMaterialName(detail.getMaterialName());
            yzMaterialEntity.setMaterialCode(detail.getMaterialCode());
            yzMaterialEntity.setSpec(detail.getSpec());
            yzMaterialEntity.setYzUnit(detail.getYzUnit());
            yzMaterialEntity.setYzCheckNumsSum(detail.getYzCheckNumsSum());
            BigDecimal checkNumsSum = detail.getCheckNumsSum();
            BigDecimal yzCheckNumsSum = detail.getYzCheckNumsSum();
            BigDecimal divide = MathUtil.safeDiv(checkNumsSum, yzCheckNumsSum);
            yzMaterialEntity.setCoefficient(divide);
            list.add(yzMaterialEntity);
        }
        return saveOrUpdateBatch(list);
    }

    @Override
    public YzMaterialEntity queryMaterialIdByYzCode(String mateSysNo) {
        LambdaQueryWrapper<YzMaterialEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(YzMaterialEntity::getYzMaterialCode, mateSysNo);
        List<YzMaterialEntity> list = list(queryWrapper);
        return CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
    }
}

