package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.wzxt.bean.YzSupplierEntity;
import com.ejianc.business.wzxt.mapper.YzSupplierMapper;
import com.ejianc.business.wzxt.service.IYzSupplierService;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.business.wzxt.vo.YzSupplierVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 云筑供应商实体
 *
 * @author generator
 *
 */
@Service("yzSupplierService")
public class YzSupplierServiceImpl extends BaseServiceImpl<YzSupplierMapper, YzSupplierEntity> implements IYzSupplierService{

    @Override
    public YzSupplierVO saveOrUpdate(CheckVO checkVO) {
        YzSupplierEntity yzEntity;
        // 查询表中是否存在 yzSupplierName
        QueryParam queryParamn = new QueryParam();
        queryParamn.getParams().put("yzSupplierCode",new Parameter(QueryParam.EQ,checkVO.getYzSupplierCode()));
        List<YzSupplierEntity> yzSupplierEntityList = super.queryList(queryParamn);
        if(yzSupplierEntityList.size()>0){
            yzEntity = yzSupplierEntityList.get(0);
            yzEntity.setSupplierId(checkVO.getSupplierId());
            yzEntity.setSupplierName(checkVO.getSupplierName());
        }else{
            yzEntity = new YzSupplierEntity();
            yzEntity.setSupplierId(checkVO.getSupplierId());
            yzEntity.setSupplierName(checkVO.getSupplierName());
            yzEntity.setYzSupplierName(checkVO.getYzSupplierName());
            yzEntity.setYzSupplierCode(checkVO.getYzSupplierCode());
        }
        super.saveOrUpdate(yzEntity, false);
        return null;
    }

    @Override
    public Long querySuplIdByYzCode(String yzCode) {
        LambdaQueryWrapper<YzSupplierEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(YzSupplierEntity::getYzSupplierCode, yzCode);
        List<YzSupplierEntity> list = list(queryWrapper);
        return CollectionUtils.isNotEmpty(list) ? list.get(0).getSupplierId() : null;
    }

}
