package com.ejianc.business.wzxt.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 订单实体
 * 
 * @author generator
 * 
 */
public class OrderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.Long projectId; // 项目
    private java.lang.String projectSourceId; // 项目来源id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 组织
    private java.lang.String orgName; // 组织名称
    private java.lang.String contractId; // 合同主键
    private java.lang.String contractName; // 合同名称
    private java.lang.Long supplierId; // 设备供应商
    private java.lang.String supplierName; // 供应商名称
    private java.lang.Long supplierTenantId; // 供应商租户ID
    private java.lang.String materialName; // 物资名称
    private java.lang.Long commitId; // 提交人
    private java.lang.Long employeeId; // 经办人
    private java.lang.String employeeName; // 经办人名称
    private java.lang.Long linkId; // 联系人
    private java.lang.String linkName; // 联系人名称
    private java.lang.String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date orderCreateDate; // 订单日期
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date orderExpiryDate; // 到货日期
    private java.lang.String orderNote; // 送货要求
    private java.lang.String orderAddress; // 送货地址
    private java.lang.Integer receiveState; // 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
    private java.lang.Integer deliverState; // 发货状态（0-待发货，1-已发货，2-已验收）
    private java.lang.String receiveStateName; // 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
    private java.lang.String deliverStateName; // 发货状态（0-待发货，1-已发货，2-已验收）
    private java.lang.Integer billState; // 单据状态（审批必须字段）

    private java.math.BigDecimal orderNumsSum; // 订单数量
    private java.math.BigDecimal deliverNumsSum; // 发货数量
    private java.math.BigDecimal unDeliverNumsSum; // 未发货数量
    private java.math.BigDecimal receiveNumsSum; // 接收数量

    private String billStateName;


    private java.lang.String orgSourceId; // 组织来源id
    private java.lang.Long parentOrgId; // 上级组织id
    private java.lang.String parentOrgSourceId; // 上级组织来源id
    private java.lang.String contractCode; // 合同编号
    private java.lang.String supplierSourceId; // 供应商来源id
    private java.lang.String construction; // 施工部位
    private String smartStatus;//智能称重标识
    private java.lang.String platformType; // 磅点类型
    private java.lang.String platformCode; // 磅点编号
    private Integer historyFlag;//是否历史数据(1是,0否)
    private java.lang.String historySystem; // 来源系统
    private java.lang.String historyId; // 来源主键
    private java.lang.String def1;
    private java.lang.String def2;
    private java.lang.String def3;
    private java.lang.String def4;
    private java.lang.String def5;

    // 订单表主键
    private String mainId;

    public String getMainId() {
        return mainId;
    }

    public void setMainId(String mainId) {
        this.mainId = mainId;
    }

    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public String getSmartStatus() {
        return smartStatus;
    }

    public void setSmartStatus(String smartStatus) {
        this.smartStatus = smartStatus;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public Integer getHistoryFlag() {
        return historyFlag;
    }

    public void setHistoryFlag(Integer historyFlag) {
        this.historyFlag = historyFlag;
    }

    public String getHistorySystem() {
        return historySystem;
    }

    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }

    public String getHistoryId() {
        return historyId;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getOrderNumsSum() {
        return orderNumsSum;
    }

    public void setOrderNumsSum(BigDecimal orderNumsSum) {
        this.orderNumsSum = orderNumsSum;
    }

    public BigDecimal getDeliverNumsSum() {
        return deliverNumsSum;
    }

    public void setDeliverNumsSum(BigDecimal deliverNumsSum) {
        this.deliverNumsSum = deliverNumsSum;
    }

    public BigDecimal getUnDeliverNumsSum() {
        return unDeliverNumsSum;
    }

    public void setUnDeliverNumsSum(BigDecimal unDeliverNumsSum) {
        this.unDeliverNumsSum = unDeliverNumsSum;
    }

    public BigDecimal getReceiveNumsSum() {
        return receiveNumsSum;
    }

    public void setReceiveNumsSum(BigDecimal receiveNumsSum) {
        this.receiveNumsSum = receiveNumsSum;
    }

    // 采购订单明细子表
    private List<OrderDetailVO> purchaseOrderDetail = new ArrayList<OrderDetailVO>();

    public List<OrderDetailVO> getPurchaseOrderDetail() {
        return purchaseOrderDetail;
    }

    public void setPurchaseOrderDetail(List<OrderDetailVO> purchaseOrderDetail) {
        this.purchaseOrderDetail = purchaseOrderDetail;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }

    public String getReceiveStateName() {
        return receiveStateName;
    }

    public void setReceiveStateName(String receiveStateName) {
        this.receiveStateName = receiveStateName;
    }

    public String getDeliverStateName() {
        return deliverStateName;
    }

    public void setDeliverStateName(String deliverStateName) {
        this.deliverStateName = deliverStateName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同主键
     */
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 设备供应商
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商租户ID
     */
    public java.lang.Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户ID
     */
    public void setSupplierTenantId(java.lang.Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }


    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 联系人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public java.lang.Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    @ReferDeserialTransfer
    public void setLinkId(java.lang.Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人名称
     */
    public java.lang.String getLinkName() {
        return linkName;
    }

    /**
     * 联系人名称
     */
    public void setLinkName(java.lang.String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系人电话
     */
    public java.lang.String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(java.lang.String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 订单日期
     */
    public java.util.Date getOrderCreateDate() {
        return orderCreateDate;
    }

    /**
     * 订单日期
     */
    public void setOrderCreateDate(java.util.Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }
    /**
     * 到货日期
     */
    public java.util.Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    /**
     * 到货日期
     */
    public void setOrderExpiryDate(java.util.Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    /**
     * 送货要求
     */
    public java.lang.String getOrderNote() {
        return orderNote;
    }

    /**
     * 送货要求
     */
    public void setOrderNote(java.lang.String orderNote) {
        this.orderNote = orderNote;
    }
    /**
     * 送货地址
     */
    public java.lang.String getOrderAddress() {
        return orderAddress;
    }

    /**
     * 送货地址
     */
    public void setOrderAddress(java.lang.String orderAddress) {
        this.orderAddress = orderAddress;
    }
    /**
     * 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
     */
    public java.lang.Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
     */
    public void setReceiveState(java.lang.Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public java.lang.Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public void setDeliverState(java.lang.Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    
}
