package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.util.ContextHolderUtils;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.Check;
import com.ejianc.business.wzxt.vo.CheckB;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("check") 
public class CheckBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private final static String TOKEN_URL = "/el/supl/auth/v1/accessToken?appId=6de82f4q&secret=azLc1HUc";

	@Value("${smartWeigh.addr}")
	private String SUPPLIER_HTTP;//五局服务域名


	@Value("${common.env.base-host}")
	private String BASE_HOST;//运行环境域名

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Autowired
	private ICheckService checkService;

	@Autowired
	private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		CheckEntity entity = checkService.selectById(billId);
		// 暂存态改为保存态
		if(entity.getSaveState() == 0){
			entity.setSaveState(1);
			checkService.saveOrUpdate(entity,false);
			logger.info("单据----"+billId+"----已保存");
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("------------  验收单推送供方  ------------");
		CheckEntity entity = checkService.selectById(billId);
		Check data = this.getCheckHeadVO(entity);// 构造验收单主表VO
		List<CheckB> bodyList = this.getCheckBodyVOList(entity);// 构造验收单子表VO
		data.setCheckBList(bodyList);
		String url = SUPPLIER_HTTP + "/el/delivery/check/insert";
		String parameterStr = JSONObject.toJSON(data).toString();
		CommonResponse<Object> res = this.doPostHttp(url, parameterStr);
		if(!res.isSuccess()){
			return CommonResponse.error("推送供方失败！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CheckEntity entity = checkService.selectById(billId);
		// 已供方确认不允许弃审
		if("1".equals(entity.getIsConfirm())) {
			logger.info("单据----"+billId+"----已供方确认");
			return CommonResponse.error("该单据已供方确认，不允许弃审！");
		}
		// 已推送NC不允许弃审
		if(entity.getUseState() == 1) {
			logger.info("单据----"+billId+"----已推送NC");
			return CommonResponse.error("该单据已推送NC，不允许弃审！");
		}
		//是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		Check data = new Check();
		data.setPkCheck(String.valueOf(billId));
		String url = SUPPLIER_HTTP + "/el/delivery/check/delete";
		String parameterStr = JSONObject.toJSON(data).toString();
		CommonResponse<Object> res = this.doPostHttp(url, parameterStr);
		if(!res.isSuccess()){
			return CommonResponse.error("供方删除失败！");
		}
		return CommonResponse.success();
	}

	/**
	 * 构造验收单主表
	 * @param entity
	 * @return
	 */
	private Check getCheckHeadVO(CheckEntity entity) {
		Check data = new Check();
		data.setPkCheck(String.valueOf(entity.getId()));// 主键
		data.setBillcode(entity.getBillCode());// 单据编码
		data.setPkOrg(entity.getOrgSourceId());// 组织主键
		data.setPkProject(entity.getProjectSourceId());// 项目主键
		data.setProjectname(entity.getProjectName());// 项目主键名称
		data.setPkContractPurchase(entity.getContractId());// 合同主键
		data.setContractPurchaseName(entity.getContractName());// 合同名称
		data.setPkSupplier(entity.getSupplierSourceId());// 供应商主键
		data.setSuppliername(entity.getSupplierName());// 供应商名称
		data.setChecker(entity.getEmployeeName());// 验收人
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		data.setChecktime(formatter.format(entity.getCheckDate()));// 验收日期
		data.setCarnumber(entity.getLicensePlate());// 车牌号
		data.setIsrequirement("1".equals(entity.getIsRequirement()) ? "Y" : "N");// 是否满足质量要求
		data.setIsstandard("1".equals(entity.getIsStandard()) ? "Y" : "N");// 是否满足合同要求
		data.setMaterialnumber(entity.getMaterialnumber());// 材质书号
		data.setUnit(entity.getConstruction());// 使用单位及部位
		data.setCheckprocess(entity.getCheckprocess());// 验收过程
		data.setCreator(entity.getCreateUserSourceId());// 创建人
		data.setVdef1(entity.getCreateUserName());// 创建人名称
		data.setCreatorDate(formatter.format(entity.getCreateTime()));// 制单时间
		data.setCheckStatus(2);// 验收单状态，默认为2-确认中
		List<AttachmentVO> imgList1 = this.queryListBySourceId(entity.getId(), "BT210125000000004", "imgUpload1");
		String tpurl = imgList1.stream().map(AttachmentVO::getFilePath).collect(Collectors.joining(","));
		data.setTpurl(tpurl);// 原始照片
		List<AttachmentVO> imgList2 = this.queryListBySourceId(entity.getId(), "BT210125000000004", "imgUpload2");
		String sceneurl = imgList2.stream().map(AttachmentVO::getFilePath).collect(Collectors.joining(","));
		data.setSceneurl(sceneurl);// 现场照片
		data.setPkDelivery(String.valueOf(entity.getDeliveryId()));// 发货单主键
//		data.setDeliveryCode("");// 发货单编号
		data.setSysmark("bjxpt");// 来源系统
		return data;
	}

	/**
	 * 构造验收单子表
	 * @param entity
	 * @return
	 */
	private List<CheckB> getCheckBodyVOList(CheckEntity entity) {
		List<CheckB> bodyList = new ArrayList<>();
		List<CheckDetailEntity> detailList = entity.getDetailList();
		for(CheckDetailEntity detail : detailList) {
			CheckB body = new CheckB();
			body.setPkCheckB(String.valueOf(detail.getId()));// 子表主键
			body.setPkCheck(String.valueOf(detail.getCheckId()));// 主表主键
			body.setPkMaterial(detail.getMaterialSourceId());// 物料主键
//			body.setPkMatclass(String.valueOf(detail.getMaterialTypeId()));// 物料分类主键
			body.setCode(detail.getMaterialCode());// 物料编码
			body.setName(detail.getMaterialName());// 物料名称
			body.setSpec(detail.getSpec());// 规格型号
			body.setMeasname(detail.getUnit());// 单位
			body.setManufacturer(detail.getMaterialManufacturer());// 生产厂家
			body.setNumber(this.getDouble(detail.getCheckNumsSum()));// 验收数量
			body.setVat(this.getDouble(detail.getNprice()));// 无税单价
			body.setTax(this.getDouble(detail.getTaxrate()));// 税率
			body.setNote(detail.getMemo());// 备注
			body.setPkDelivery(String.valueOf(detail.getDeliveryId()));// 发货单主键
			body.setPkDeliveryInfo(String.valueOf(detail.getDeliveryDetailId()));// 发货单子表主键
//			body.setDeliveryCode("");// 发货单编号
			bodyList.add(body);
		}
		return bodyList;
	}

	/**
	 * 查询附件信息
	 * @param sourceId
	 * @param billType
	 * @param sourceType
	 * @return
	 */
	private List<AttachmentVO> queryListBySourceId(Long sourceId, String billType, String sourceType){
		String url = BASE_HOST + "ejc-file-web/attachment/queryListBySourceId";
		Map<String, String> params = new HashMap();
		params.put("sourceId", String.valueOf(sourceId));
		params.put("billType", billType);
		params.put("sourceType", sourceType);
		try {
			String json = com.ejianc.framework.core.util.HttpTookit.get(url, params, ContextHolderUtils.getRequest());
			logger.info("请求：" + url +"?params={} 响应结果：{}", params, json);
			CommonResponse<JSONObject> response = JSONObject.parseObject(json, CommonResponse.class);
			String data = response.getData().getString("data");
			List<AttachmentVO> list = (List<AttachmentVO>) JSONArray.parseArray(data, AttachmentVO.class);
			return list;
		} catch (Exception e) {
			logger.error("获取文件信息异常，", e);
			return new ArrayList<>();
		}
	}

	/**
	 * Post公共方法
	 *
	 * @param url               路径地址
	 * @param parameterStr      参数  JSONString
	 * @return
	 */
	public CommonResponse<Object>  doPostHttp(String url, String parameterStr){
		Map<String, String> headers = new HashMap();
		// 获取token
		try {
			logger.info("------------  url：" + url + "  ------------");
			logger.info("------------  入参：" + parameterStr + "  ------------");
			String back = HttpTookit.postByJson(url, parameterStr, headers);
			JSONObject jsonBack = JSONObject.parseObject(back);
			if("200".equals(jsonBack.getString("code"))){
				//调用同步方法成功
				logger.info("------------  请求成功！body = " + jsonBack.getString("body") + "  ------------");
				return CommonResponse.success(jsonBack.get("body"));
			}else{
				//调用同步方法失败，输出错误信息
				logger.error("------------  请求失败！message = " + jsonBack.getString("message") + "  ------------");
				return CommonResponse.error(jsonBack.getString("message"));
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
			return CommonResponse.error("查询失败！");
		}
	}

	/**
	 * 取BigDecimal的Double值
	 * @param num
	 * @return
	 */
	private Double getDouble(BigDecimal num) {
		return num != null ? num.doubleValue() : null;
	}

}
