package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.EvaluateVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.EvaluateMapper;
import com.ejianc.business.wzxt.bean.EvaluateEntity;
import com.ejianc.business.wzxt.service.IEvaluateService;

/**
 * 供应商评价表
 * 
 * @author generator
 * 
 */
@Service("evaluateService")
public class EvaluateServiceImpl extends BaseServiceImpl<EvaluateMapper, EvaluateEntity> implements IEvaluateService{
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IOrderService orderService;

    @Override
    public EvaluateVO saveOrUpdate(EvaluateVO evaluateVO) {
        logger.error("service进来了"+evaluateVO.toString());
        //查询订单主键查询订单
        LambdaQueryWrapper<OrderEntity> queryWrapperOrder = Wrappers.<OrderEntity>lambdaQuery();
        queryWrapperOrder.eq(OrderEntity::getHistoryId, evaluateVO.getOrderStringId());
        OrderEntity orderEntityOne = orderService.getOne(queryWrapperOrder);
        OrderEntity orderEntity = new OrderEntity();
        if(null != orderEntityOne){
            orderEntity = orderEntityOne;
        }else {
            logger.info("发货单信息:"+evaluateVO.toString());
            orderEntity = orderService.getById(Long.parseLong(evaluateVO.getOrderStringId()));
        }
        logger.error("订单实体信息:"+orderEntity.toString());
        evaluateVO.setProjectId(orderEntity.getProjectId());
        evaluateVO.setProjectName(orderEntity.getProjectName());
        evaluateVO.setOrgId(orderEntity.getOrgId());
        evaluateVO.setOrgName(orderEntity.getOrgName());
        evaluateVO.setContractId(orderEntity.getContractId());
        evaluateVO.setContractName(orderEntity.getContractName());
        evaluateVO.setSupplierId(orderEntity.getSupplierId());
        evaluateVO.setSupplierName(orderEntity.getSupplierName());
        evaluateVO.setProjectSourceId(orderEntity.getProjectSourceId());
        evaluateVO.setSupplierSourceId(orderEntity.getSupplierSourceId());
        EvaluateEntity entity = BeanMapper.map(evaluateVO, EvaluateEntity.class);
        super.saveOrUpdate(entity,false);
        return BeanMapper.map(entity, EvaluateVO.class);
    }
}
