package com.ejianc.business.fbxt.odd.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.fbxt.odd.vo.OddInfoApplyVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 用工申请实体
 * 
 * @author generator
 * 
 */
public class OddApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectSourceId; // 项目来源id
    private Long cropId; // 项目所属组织id
    private String cropSourceId; // 项目所属组织来源id
    private Long orgId; // 组织
    private String orgSourceId; // 组织来源id
    private String orgName; // 组织名称
    private String contractId; // 合同
    private String contractName; // 合同名称
    private String contractCode; // 合同编号
    private Long supplierId; // 供方主键
    private String supplierSourceId; // 供方来源id
    private String supplierName; // 供方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 申请日期
    private Long useType; // 用工类型，档案
    private Long belong; // 费用归属，档案
    private String planBody; // 施工部位
    private String useDesc; // 用工内容
    private Integer redirectFlag; // 是否转扣，0-否，1-是
    private Integer registerFlag; // 是否登记，0-否，1-是
    private java.math.BigDecimal applyMny; // 申请金额
    private java.math.BigDecimal reviewMny; // 审核金额
    private Long oddId; // 用工单主键
    private Integer oddStatus; // 暂存状态，0-暂存，1-已提交
    private Integer billState; // 单据状态
    private String createName; // 申请人姓名
    private List<OddInfoApplyVO> oddInfoApplyEntities = new ArrayList<>(); // 用工申请清单实体


    private String registerFlagName; // 是否登记，0-否，1-是
    private String billStateName;
    private String cropName; // 所属公司

    /**
     * 经办人
     */
    @TableField(value = "manager")
    private String manager;
    /**
     * 经办人姓名
     */
    @TableField(value = "managname")
    private String managname;
    /**
     * 意见
     */
    @TableField(value = "opinion")
    private String opinion;
    private Integer passFlag; // 供方是否通过，-1：不需要确认，0-待确认，1-已确认，2-已驳回
    private String passFlagName; // 供方是否通过，-1：不需要确认，0-待确认，1-已确认，2-已驳回
    private Integer oddApplySource; // 数据来源，0-新增，1-历史数据
    private String useTypeName;

    public String getUseTypeName() {
        return useTypeName;
    }

    public void setUseTypeName(String useTypeName) {
        this.useTypeName = useTypeName;
    }

    public Integer getOddApplySource() {
        return oddApplySource;
    }

    public void setOddApplySource(Integer oddApplySource) {
        this.oddApplySource = oddApplySource;
    }

    public String getPassFlagName() {
        return passFlagName;
    }

    public void setPassFlagName(String passFlagName) {
        this.passFlagName = passFlagName;
    }

    public String getManager() {
        return manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public String getManagname() {
        return managname;
    }

    public void setManagname(String managname) {
        this.managname = managname;
    }

    public String getOpinion() {
        return opinion;
    }

    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }

    public Integer getPassFlag() {
        return passFlag;
    }

    public void setPassFlag(Integer passFlag) {
        this.passFlag = passFlag;
    }

    public String getCropName() {
        return cropName;
    }

    public void setCropName(String cropName) {
        this.cropName = cropName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getRegisterFlagName() {
        return registerFlagName;
    }

    public void setRegisterFlagName(String registerFlagName) {
        this.registerFlagName = registerFlagName;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目来源id
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源id
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    /**
     * 项目所属组织id
     */
    public Long getCropId() {
        return cropId;
    }

    /**
     * 项目所属组织id
     */
    public void setCropId(Long cropId) {
        this.cropId = cropId;
    }
    /**
     * 项目所属组织来源id
     */
    public String getCropSourceId() {
        return cropSourceId;
    }

    /**
     * 项目所属组织来源id
     */
    public void setCropSourceId(String cropSourceId) {
        this.cropSourceId = cropSourceId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源id
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源id
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同
     */
    public String getContractId() {
        return contractId;
    }

    /**
     * 合同
     */
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供方主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方来源id
     */
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    /**
     * 供方来源id
     */
    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }
    /**
     * 供方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 申请日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 申请日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 用工类型，档案
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getUseType() {
        return useType;
    }

    /**
     * 用工类型，档案
     */
    @ReferDeserialTransfer
    public void setUseType(Long useType) {
        this.useType = useType;
    }
    /**
     * 费用归属，档案
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBelong() {
        return belong;
    }

    /**
     * 费用归属，档案
     */
    @ReferDeserialTransfer
    public void setBelong(Long belong) {
        this.belong = belong;
    }
    /**
     * 施工部位
     */
    public String getPlanBody() {
        return planBody;
    }

    /**
     * 施工部位
     */
    public void setPlanBody(String planBody) {
        this.planBody = planBody;
    }
    /**
     * 用工内容
     */
    public String getUseDesc() {
        return useDesc;
    }

    /**
     * 用工内容
     */
    public void setUseDesc(String useDesc) {
        this.useDesc = useDesc;
    }
    /**
     * 是否转扣，0-否，1-是
     */
    public Integer getRedirectFlag() {
        return redirectFlag;
    }

    /**
     * 是否转扣，0-否，1-是
     */
    public void setRedirectFlag(Integer redirectFlag) {
        this.redirectFlag = redirectFlag;
    }
    /**
     * 是否登记，0-否，1-是
     */
    public Integer getRegisterFlag() {
        return registerFlag;
    }

    /**
     * 是否登记，0-否，1-是
     */
    public void setRegisterFlag(Integer registerFlag) {
        this.registerFlag = registerFlag;
    }
    /**
     * 申请金额
     */
    public java.math.BigDecimal getApplyMny() {
        return applyMny;
    }

    /**
     * 申请金额
     */
    public void setApplyMny(java.math.BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    /**
     * 审核金额
     */
    public java.math.BigDecimal getReviewMny() {
        return reviewMny;
    }

    /**
     * 审核金额
     */
    public void setReviewMny(java.math.BigDecimal reviewMny) {
        this.reviewMny = reviewMny;
    }
    /**
     * 用工单主键
     */
    public Long getOddId() {
        return oddId;
    }

    /**
     * 用工单主键
     */
    public void setOddId(Long oddId) {
        this.oddId = oddId;
    }
    /**
     * 暂存状态，0-暂存，1-已提交
     */
    public Integer getOddStatus() {
        return oddStatus;
    }

    /**
     * 暂存状态，0-暂存，1-已提交
     */
    public void setOddStatus(Integer oddStatus) {
        this.oddStatus = oddStatus;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<OddInfoApplyVO> getOddInfoApplyEntities() {
        return oddInfoApplyEntities;
    }

    public void setOddInfoApplyEntities(List<OddInfoApplyVO> oddInfoApplyEntities) {
        this.oddInfoApplyEntities = oddInfoApplyEntities;
    }
}
