package com.ejianc.business.fbxt.odd.controller;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fbxt.odd.bean.OddImportInfoEntity;
import com.ejianc.business.fbxt.odd.service.IOddImportInfoService;
import com.ejianc.business.fbxt.odd.vo.OddImportInfoVO;

/**
 * 零星用工导入申请单实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("oddImportInfo")
public class OddImportInfoController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOddImportInfoService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddImportInfoVO> saveOrUpdate(@RequestBody OddImportInfoVO saveorUpdateVO) {
    	OddImportInfoEntity entity = BeanMapper.map(saveorUpdateVO, OddImportInfoEntity.class);
    	service.saveOrUpdate(entity, false);
    	OddImportInfoVO vo = BeanMapper.map(entity, OddImportInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddImportInfoVO> queryDetail(Long id) {
    	OddImportInfoEntity entity = service.selectById(id);
    	OddImportInfoVO vo = BeanMapper.map(entity, OddImportInfoVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddImportInfoVO> vos) {
        service.removeByIds(vos.stream().map(OddImportInfoVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddImportInfoVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<OddImportInfoEntity> page = service.queryPage(param,false);
        IPage<OddImportInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OddImportInfoVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
