/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.mapper.OddApplyMapper;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.vo.OddApplyVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.ApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddApplyRequest;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.fbxt.util.MsgUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="oddApplyService")
public class OddApplyServiceImpl
extends BaseServiceImpl<OddApplyMapper, OddApplyEntity>
implements IOddApplyService {
    private static final String ODD_APPLY = "HN_ODD_APPLY";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${openApi.wjOddApplyUrl}")
    private String wjOddApplyUrl;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private MsgUtil msgUtil;

    @Override
    public CommonResponse<OddApplyVO> saveOrUpdate(OddApplyVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddApplyEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (OddApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddApplyEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ODD_APPLY, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OddApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddApplyEntity.class));
            operateType = "add";
        }
        CommonResponse orgVo = this.orgApi.getOneById(entity.getOrgId());
        if (!orgVo.isSuccess()) {
            return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            entity.setOrgSourceId(((OrgVO)orgVo.getData()).getSourceId());
        }
        if (entity.getCropId() != null) {
            CommonResponse cropVo = this.orgApi.getOneById(entity.getCropId());
            if (!cropVo.isSuccess()) {
                return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null != cropVo.getData()) {
                entity.setCropSourceId(((OrgVO)cropVo.getData()).getSourceId());
            }
        }
        if (entity.getPassFlag() == null) {
            entity.setPassFlag(-1);
        }
        entity.setRegisterFlag(0);
        super.saveOrUpdate((Object)entity, false);
        OddApplyVO vo = (OddApplyVO)BeanMapper.map((Object)((Object)entity), OddApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public Boolean applyUsed(ApplyRequest request) {
        if (request.getIsused() != null && request.getIsused() == 0) {
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)0);
            tupdateWrapper.set(OddApplyEntity::getOddId, null);
            tupdateWrapper.eq(BaseEntity::getId, (Object)request.getPkOddApply());
            super.update((Wrapper)tupdateWrapper);
        } else {
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)1);
            tupdateWrapper.set(OddApplyEntity::getOddId, (Object)request.getPkOdd());
            tupdateWrapper.eq(BaseEntity::getId, (Object)request.getPkOddApply());
            super.update((Wrapper)tupdateWrapper);
        }
        return true;
    }

    @Override
    public Boolean suplcommit(OddApplyRequest request) {
        List bcFileList;
        LambdaUpdateWrapper tupdateWrapper;
        String subject = null;
        OddApplyEntity applyEntity = (OddApplyEntity)((Object)super.selectById((Serializable)request.getPkOddApply()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (request.getOddStatus() != null && request.getOddStatus() == 1) {
            tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getPassFlag, (Object)2);
            tupdateWrapper.set(OddApplyEntity::getManager, (Object)request.getManager());
            tupdateWrapper.set(OddApplyEntity::getManagname, (Object)request.getManagname());
            tupdateWrapper.set(OddApplyEntity::getOpinion, (Object)request.getOpinion());
            tupdateWrapper.set(OddApplyEntity::getBillState, (Object)0);
            tupdateWrapper.eq(BaseEntity::getId, (Object)request.getPkOddApply());
            super.update((Wrapper)tupdateWrapper);
            subject = "\u4f60\u63d0\u4ea4\u7684\u6d41\u7a0b\u3010\u96f6\u661f\u7528\u5de5_" + applyEntity.getBillCode() + "_" + sdf.format(new Date()) + "\u3011\u5df2\u88ab\u4f9b\u5e94\u5546\u3010" + applyEntity.getSupplierName() + "\u3011\u9a73\u56de";
        } else {
            tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddApplyEntity::getPassFlag, (Object)1);
            tupdateWrapper.set(OddApplyEntity::getManager, (Object)request.getManager());
            tupdateWrapper.set(OddApplyEntity::getManagname, (Object)request.getManagname());
            tupdateWrapper.set(OddApplyEntity::getOpinion, (Object)request.getOpinion());
            tupdateWrapper.eq(BaseEntity::getId, (Object)request.getPkOddApply());
            super.update((Wrapper)tupdateWrapper);
            subject = "\u4f60\u63d0\u4ea4\u7684\u6d41\u7a0b\u3010\u96f6\u661f\u7528\u5de5_" + applyEntity.getBillCode() + "_" + sdf.format(new Date()) + "\u3011\u5df2\u88ab\u4f9b\u5e94\u5546\u3010" + applyEntity.getSupplierName() + "\u3011\u786e\u8ba4";
        }
        String billType = "BT210804000000001";
        String sourceTypebc = "oddapplybc";
        CommonResponse fileResponse = this.attachmentApi.queryListBySourceId(request.getPkOddApply(), billType, sourceTypebc, null);
        if (fileResponse.isSuccess() && fileResponse.getData() != null && ((List)fileResponse.getData()).size() > 0) {
            List fileIds = ((List)fileResponse.getData()).stream().map(AttachmentVO::getId).collect(Collectors.toList());
            this.attachmentApi.delete(StringUtils.join(fileIds, (String)","));
        }
        if ((bcFileList = request.getBcfileList()) != null && bcFileList.size() > 0) {
            ArrayList<AttachmentVO> fileList = new ArrayList<AttachmentVO>();
            for (FileRelation f : bcFileList) {
                AttachmentVO file = new AttachmentVO();
                file.setBillType(billType);
                file.setSourceId(request.getPkOddApply());
                file.setSourceType(sourceTypebc);
                file.setFileName(f.getFileName());
                file.setFilePath("suplfile/" + f.getFilePath());
                file.setUploadUserName(request.getManagname());
                file.setFileSize(Long.valueOf(10123L));
                fileList.add(file);
            }
            this.attachmentApi.insertBatch(fileList);
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjyApply");
        ArrayList<String> sender = new ArrayList<String>();
        String createUserId = this.msgUtil.getCreateUserId(applyEntity.getCreateUserCode());
        sender.add(createUserId);
        String formurl = this.baseHost + "cscec5bhn-fbxt-frontend/#/oddapply/card?id=" + applyEntity.getId();
        String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.msgUtil.sendMsg(messageType, sender, "task", subject, content, applyEntity.getId());
        return true;
    }

    @Override
    public CommonResponse<String> pushOddApply(Map<String, String> headers, OddApplyRequest copy) {
        String url = this.wjOddApplyUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }
}

