/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fbxt.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fbxt.grap.service.IRecordService;
import com.ejianc.business.fbxt.odd.Enum.BillStatusEnum;
import com.ejianc.business.fbxt.odd.bean.OddApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoApplyEntity;
import com.ejianc.business.fbxt.odd.bean.OddInfoEntity;
import com.ejianc.business.fbxt.odd.bean.OddRedirectEntity;
import com.ejianc.business.fbxt.odd.mapper.OddMapper;
import com.ejianc.business.fbxt.odd.service.IOddApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoApplyService;
import com.ejianc.business.fbxt.odd.service.IOddInfoService;
import com.ejianc.business.fbxt.odd.service.IOddRedirectService;
import com.ejianc.business.fbxt.odd.service.IOddService;
import com.ejianc.business.fbxt.odd.vo.OddDetailVO;
import com.ejianc.business.fbxt.odd.vo.OddInfoVO;
import com.ejianc.business.fbxt.odd.vo.OddRedirectVO;
import com.ejianc.business.fbxt.odd.vo.OddVO;
import com.ejianc.business.fbxt.odd.vo.sysupl.ApplyRequest;
import com.ejianc.business.fbxt.odd.vo.sysupl.FileRelation;
import com.ejianc.business.fbxt.odd.vo.sysupl.OddWriteBackRequest;
import com.ejianc.business.fbxt.util.HttpTookit;
import com.ejianc.business.fbxt.util.MsgUtil;
import com.ejianc.business.sync.vo.OddSyncVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service(value="oddService")
public class OddServiceImpl
extends BaseServiceImpl<OddMapper, OddEntity>
implements IOddService {
    private static final String ODD_CODE = "HN_ODD_CODE";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOddApplyService oddApplyService;
    @Autowired
    private IOddInfoService oddInfoService;
    @Autowired
    private IOddRedirectService redirectService;
    @Autowired
    private IOddInfoApplyService oddInfoApplyService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDefdocApi defdocApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${openApi.wjTokenUrl}")
    private String wjTokenUrl;
    @Value(value="${openApi.wjOddJobUrl}")
    private String wjOddJobUrl;
    @Value(value="${openApi.wjOddApplyUsedUrl}")
    private String wjOddApplyUsedUrl;
    @Value(value="${openApi.wjOddApplyBatchNoUsedUrl}")
    private String wjOddApplyBatchNoUsedUrl;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private MsgUtil msgUtil;

    @Override
    @Transactional
    public CommonResponse<OddVO> saveOrUpdate(OddVO saveorUpdateVO) {
        QueryParam queryParam;
        CommonResponse orgVo;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OddEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                saveorUpdateVO.setBillCode(null);
            }
            entity = (OddEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(ODD_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            saveorUpdateVO.setOddSource(Integer.valueOf(0));
            entity = (OddEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OddEntity.class));
            operateType = "add";
        }
        CommonResponse cropVo = this.orgApi.getOneById(entity.getCropId());
        if (!cropVo.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != cropVo.getData()) {
            entity.setCropSourceId(((OrgVO)cropVo.getData()).getSourceId());
        }
        if (!(orgVo = this.orgApi.getOneById(entity.getOrgId())).isSuccess()) {
            return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != orgVo.getData()) {
            entity.setOrgSourceId(((OrgVO)orgVo.getData()).getSourceId());
        }
        List oddInfoEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getOddInfoEntities(), OddInfoEntity.class);
        List fileIds = saveorUpdateVO.getFileIds();
        entity.setImportFlag(0);
        super.saveOrUpdate((Object)entity);
        this.recordService.saveOrUpdateBatchRecordList(entity.getRecordList(), entity.getId());
        if (entity.getSourceType() == 0 && entity.getOddStatus() == 1) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            queryParam.getParams().put("oddStatus", new Parameter("ne", (Object)0));
            queryParam.getParams().put("oddApplyId", new Parameter("eq", (Object)entity.getOddApplyId()));
            List oddEntities = super.queryList(queryParam, false);
            if (oddEntities != null && oddEntities.size() > 0) {
                throw new BusinessException("\u8be5\u7528\u5de5\u7533\u8bf7\u5355\u5df2\u88ab\u5f15\u7528");
            }
            OddApplyEntity oddApplyEntity = (OddApplyEntity)((Object)this.oddApplyService.selectById(entity.getOddApplyId()));
            if (oddApplyEntity.getPassFlag() != null && oddApplyEntity.getPassFlag() != -1) {
                String url = this.wjOddApplyUsedUrl;
                ApplyRequest request = new ApplyRequest();
                request.setPkOdd(entity.getId());
                request.setPkOddApply(entity.getOddApplyId());
                request.setIsused(Integer.valueOf(1));
                this.writeBackApplyToSupl(request, url);
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)1);
            updateWrapper.set(OddApplyEntity::getOddId, (Object)entity.getId());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getOddApplyId());
            this.oddApplyService.update((Wrapper)updateWrapper);
        }
        if (fileIds != null && fileIds.size() > 0) {
            this.fileApi.updateAttachRef(entity.getId(), fileIds);
        }
        this.saveDetails(oddInfoEntities, entity.getId(), operateType);
        queryParam = new QueryParam();
        queryParam.getParams().put("oddId", new Parameter("eq", (Object)entity.getId()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
        List dddRedirectEntityes = this.redirectService.queryList(queryParam, false);
        if (dddRedirectEntityes != null && dddRedirectEntityes.size() > 0) {
            entity.setRedirectFlag(1);
            BigDecimal zkmny = new BigDecimal("0");
            for (OddRedirectEntity oddRedirectEntity : dddRedirectEntityes) {
                zkmny = oddRedirectEntity.getMny().add(zkmny);
            }
            entity.setZkmny(zkmny);
        } else {
            entity.setRedirectFlag(0);
        }
        super.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    private void isEnter(List<OddInfoVO> infoVOList) {
        for (OddInfoVO vo : infoVOList) {
            if (vo.getName() == null || vo.getName().length() <= 0) {
                throw new BusinessException("\u7528\u5de5\u9879\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getNum() == null) {
                throw new BusinessException("\u6e05\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getCode() == null || vo.getCode().length() <= 0) {
                throw new BusinessException("\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getInfoUnit() == null || vo.getInfoUnit().length() <= 0) {
                throw new BusinessException("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getPrice() == null) {
                throw new BusinessException("\u65e0\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getBeginTime() == null) {
                throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vo.getEndTime() != null) continue;
            throw new BusinessException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void saveDetails(List<OddInfoEntity> infoList, Long oddId, String operateType) {
        if ("edit".equals(operateType)) {
            this.redirectService.remove((Wrapper)new QueryWrapper().eq((Object)"odd_id", (Object)oddId));
        }
        ArrayList<OddRedirectEntity> saveRedirects = new ArrayList<OddRedirectEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (OddInfoEntity info : infoList) {
            List<OddRedirectEntity> list;
            if ("add".equals(info.getRowState())) {
                info.setOddId(oddId);
                info.setInfoNcFlag(0);
                list = info.getOddRedirectEntities();
                this.oddInfoService.save((Object)info);
                if (list == null || list.size() <= 0) continue;
                for (OddRedirectEntity re : list) {
                    re.setInfoId(info.getId());
                    re.setOddId(oddId);
                    re.setId(null);
                    re.setRedirectNcFlag(0);
                    saveRedirects.add(re);
                }
                continue;
            }
            if ("edit".equals(info.getRowState())) {
                list = info.getOddRedirectEntities();
                this.oddInfoService.updateById((Object)info);
                if (list == null || list.size() <= 0) continue;
                for (OddRedirectEntity re : list) {
                    re.setInfoId(info.getId());
                    re.setOddId(oddId);
                    re.setId(null);
                    re.setRedirectNcFlag(0);
                    saveRedirects.add(re);
                }
                continue;
            }
            if (!"del".equals(info.getRowState())) continue;
            deleteIds.add(info.getId());
        }
        if (saveRedirects.size() > 0) {
            this.redirectService.saveBatch(saveRedirects);
        }
        if (deleteIds.size() > 0) {
            this.oddInfoService.removeByIds(deleteIds, false);
        }
    }

    @Override
    public void del(List<OddVO> vos) {
        List list = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", list));
        List oddEntities = super.queryList(queryParam, false);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (OddEntity entity : oddEntities) {
            if (entity.getSourceType() == 2) {
                throw new BusinessException("\u4f9b\u65b9\u540c\u6b65\u7684\u96f6\u5de5\u5355\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            if (entity.getSourceType() != 0) continue;
            ids.add(entity.getOddApplyId());
        }
        if (ids.size() > 0) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getDr, (Object)0);
            lambda.in(BaseEntity::getId, ids);
            List applyEntities = this.oddApplyService.list((Wrapper)lambda);
            ArrayList<Long> pkOddApplyList = new ArrayList<Long>();
            for (OddApplyEntity applyEntity : applyEntities) {
                if (applyEntity.getPassFlag() == null || applyEntity.getPassFlag() == -1) continue;
                pkOddApplyList.add(applyEntity.getId());
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddApplyEntity::getRegisterFlag, (Object)0);
            updateWrapper.set(OddApplyEntity::getOddId, null);
            updateWrapper.in(BaseEntity::getId, ids);
            this.oddApplyService.update((Wrapper)updateWrapper);
            if (pkOddApplyList.size() > 0) {
                String url = this.wjOddApplyBatchNoUsedUrl;
                ApplyRequest request = new ApplyRequest();
                request.setPkOddApplyList(pkOddApplyList);
                this.writeBackApplyToSupl(request, url);
            }
        }
    }

    @Override
    public OddVO queryDetail(Long id) {
        OddEntity entity = (OddEntity)((Object)this.selectById(id));
        List<OddInfoEntity> infoEntities = entity.getOddInfoEntities();
        OddVO vo = (OddVO)BeanMapper.map((Object)((Object)entity), OddVO.class);
        if (infoEntities != null && infoEntities.size() > 0) {
            List oddInfoVOS = BeanMapper.mapList(infoEntities, OddInfoVO.class);
            QueryParam queryParam = null;
            for (OddInfoVO infovo : oddInfoVOS) {
                queryParam = new QueryParam();
                queryParam.getParams().put("info_id", new Parameter("eq", (Object)infovo.getId()));
                List redirectEntities = this.redirectService.queryList(queryParam, false);
                infovo.setOddRedirectEntities(BeanMapper.mapList((Iterable)redirectEntities, OddRedirectVO.class));
            }
            vo.setOddInfoEntities(oddInfoVOS);
        }
        return vo;
    }

    @Override
    public List<OddDetailVO> queryDetailsList(Page<OddDetailVO> page, QueryWrapper queryWrapper) {
        return ((OddMapper)this.baseMapper).queryDetailsList(page, queryWrapper);
    }

    @Override
    public OddDetailVO queryRedirect(Long infoId) {
        return ((OddMapper)this.baseMapper).queryRedirect(infoId);
    }

    @Override
    public CommonResponse<String> settleNc(OddSyncVo vo) {
        QueryParam queryParam;
        QueryParam queryParam2;
        List yinfo = vo.getYinfo();
        List ninfo = vo.getNinfo();
        List yredirect = vo.getYredirect();
        List nredirect = vo.getNredirect();
        if (yinfo != null && yinfo.size() > 0) {
            LambdaUpdateWrapper yupdateWrapper = new LambdaUpdateWrapper();
            yupdateWrapper.set(OddInfoEntity::getInfoNcFlag, (Object)1);
            yupdateWrapper.in(BaseEntity::getId, (Collection)yinfo);
            this.oddInfoService.update((Wrapper)yupdateWrapper);
        }
        if (ninfo != null && ninfo.size() > 0) {
            LambdaUpdateWrapper nupdateWrapper = new LambdaUpdateWrapper();
            nupdateWrapper.set(OddInfoEntity::getInfoNcFlag, (Object)0);
            nupdateWrapper.in(BaseEntity::getId, (Collection)ninfo);
            this.oddInfoService.update((Wrapper)nupdateWrapper);
        }
        if (yredirect != null && yredirect.size() > 0) {
            LambdaUpdateWrapper tupdateWrapper = new LambdaUpdateWrapper();
            tupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, (Object)1);
            tupdateWrapper.in(BaseEntity::getId, (Collection)yredirect);
            this.redirectService.update((Wrapper)tupdateWrapper);
        }
        if (nredirect != null && nredirect.size() > 0) {
            LambdaUpdateWrapper fupdateWrapper = new LambdaUpdateWrapper();
            fupdateWrapper.set(OddRedirectEntity::getRedirectNcFlag, (Object)0);
            fupdateWrapper.in(BaseEntity::getId, (Collection)nredirect);
            this.redirectService.update((Wrapper)fupdateWrapper);
        }
        HashSet<Long> yids = new HashSet<Long>();
        if (yinfo != null && yinfo.size() > 0) {
            queryParam2 = new QueryParam();
            queryParam2.getParams().put("id", new Parameter("in", (Object)yinfo));
            List oddInfos = this.oddInfoService.queryList(queryParam2, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    yids.add(infoEntity.getOddId());
                }
            }
        }
        if (yredirect != null && yredirect.size() > 0) {
            queryParam2 = new QueryParam();
            queryParam2.getParams().put("id", new Parameter("in", (Object)yredirect));
            List redirects = this.redirectService.queryList(queryParam2, false);
            if (redirects != null && redirects.size() > 0) {
                for (Object redirectEntity : redirects) {
                    yids.add(((OddRedirectEntity)((Object)redirectEntity)).getOddId());
                }
            }
        }
        if (yids != null && yids.size() > 0) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OddEntity::getSettleNcFlag, (Object)1);
            updateWrapper.in(BaseEntity::getId, yids);
            super.update((Wrapper)updateWrapper);
        }
        HashSet<Long> nids = new HashSet<Long>();
        if (ninfo != null && ninfo.size() > 0) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", (Object)ninfo));
            List oddInfos = this.oddInfoService.queryList(queryParam, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity infoEntity : oddInfos) {
                    nids.add(infoEntity.getOddId());
                }
            }
        }
        if (nredirect != null && nredirect.size() > 0) {
            queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", (Object)nredirect));
            List redirects = this.redirectService.queryList(queryParam, false);
            if (redirects != null && redirects.size() > 0) {
                for (OddRedirectEntity redirectEntity : redirects) {
                    nids.add(redirectEntity.getOddId());
                }
            }
        }
        if (nids != null && nids.size() > 0) {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            QueryParam queryParam3 = new QueryParam();
            queryParam3.getParams().put("oddId", new Parameter("in", nids));
            List oddInfos = this.oddInfoService.queryList(queryParam3, false);
            List redirects = this.redirectService.queryList(queryParam3, false);
            if (oddInfos != null && oddInfos.size() > 0) {
                for (OddInfoEntity oi : oddInfos) {
                    if (!map.containsKey(oi.getOddId())) {
                        map.put(oi.getOddId(), 0);
                    }
                    if (oi.getInfoNcFlag() != 1) continue;
                    map.put(oi.getOddId(), (Integer)map.get(oi.getOddId()) + 1);
                }
            }
            if (redirects != null && redirects.size() > 0) {
                for (Object re : redirects) {
                    if (!map.containsKey(((OddRedirectEntity)((Object)re)).getOddId())) {
                        map.put(((OddRedirectEntity)((Object)re)).getOddId(), 0);
                    }
                    if (((OddRedirectEntity)((Object)re)).getRedirectNcFlag() != 1) continue;
                    map.put(((OddRedirectEntity)((Object)re)).getOddId(), (Integer)map.get(((OddRedirectEntity)((Object)re)).getOddId()) + 1);
                }
            }
            ArrayList<Long> oddids = new ArrayList<Long>();
            for (Long key : map.keySet()) {
                if ((Integer)map.get(key) != 0) continue;
                oddids.add(key);
            }
            if (oddids != null && oddids.size() > 0) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(OddEntity::getSettleNcFlag, (Object)0);
                updateWrapper.in(BaseEntity::getId, oddids);
                super.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @Override
    public Boolean suplInsert(com.ejianc.business.fbxt.odd.vo.sysupl.OddVO request) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String billType = "BT210804000000002";
        OddApplyEntity applyEntity = (OddApplyEntity)((Object)this.oddApplyService.selectById(request.getPkOddApply()));
        OddEntity entity = (OddEntity)((Object)BeanMapper.map((Object)((Object)applyEntity), OddEntity.class));
        entity.setId(null);
        entity.setBillCode(request.getOddCode());
        try {
            entity.setCreateDate(sdf.parse(request.getCreateDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        entity.setUseMny(request.getPricesum());
        entity.setReviewMny(request.getSumcheck());
        entity.setSourceType(2);
        entity.setOddApplyId(request.getPkOddApply());
        entity.setOddApplyBillCode(applyEntity.getBillCode());
        entity.setOddStatus(1);
        entity.setBillState(0);
        entity.setRedirectFlag(request.getRedirectStatus());
        entity.setCreateName(request.getName());
        entity.setSettleNcFlag(0);
        entity.setOddSource(0);
        entity.setImportFlag(0);
        entity.setSourceId(request.getPkOdd());
        entity.setZkmny(request.getSumredirect());
        super.saveOrUpdate((Object)entity);
        List oddInfoList = request.getOddInfoList();
        if (oddInfoList != null && oddInfoList.size() > 0) {
            ArrayList<OddInfoEntity> oddInfoEntities = new ArrayList<OddInfoEntity>();
            for (com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO vo : oddInfoList) {
                AttachmentVO file;
                OddInfoEntity oddInfoEntity = this.mapInfo(vo, entity.getId());
                oddInfoEntities.add(oddInfoEntity);
                List befFileList = vo.getBefFileList();
                List aftFileList = vo.getAftFileList();
                ArrayList<AttachmentVO> fileList = new ArrayList<AttachmentVO>();
                if (befFileList != null && befFileList.size() > 0) {
                    for (FileRelation f : befFileList) {
                        file = new AttachmentVO();
                        file.setBillType(billType);
                        file.setSourceId(entity.getId());
                        file.setSourceType("before_" + oddInfoEntity.getFileType());
                        file.setFileName(f.getFileName());
                        file.setFilePath("suplfile/" + f.getFilePath());
                        file.setUploadUserName(null);
                        file.setFileSize(Long.valueOf(10123L));
                        fileList.add(file);
                    }
                }
                if (aftFileList != null && aftFileList.size() > 0) {
                    for (FileRelation f : aftFileList) {
                        file = new AttachmentVO();
                        file.setBillType(billType);
                        file.setSourceId(entity.getId());
                        file.setSourceType("after_" + oddInfoEntity.getFileType());
                        file.setFileName(f.getFileName());
                        file.setFilePath("suplfile/" + f.getFilePath());
                        file.setUploadUserName(null);
                        file.setFileSize(Long.valueOf(10123L));
                        fileList.add(file);
                    }
                }
                if (fileList.size() <= 0) continue;
                this.attachmentApi.insertBatch(fileList);
            }
            this.oddInfoService.saveOrUpdateBatch(oddInfoEntities);
        }
        this.writeBackApply(entity.getId(), entity.getOddApplyId(), true);
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjyOdd");
        String subject = "\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011\u63d0\u4ea4\u7684\u3010\u96f6\u661f\u7528\u5de5\u5ba1\u6279\u5355_" + entity.getBillCode() + "_" + sdf.format(new Date()) + "\u3011\u9700\u8981\u786e\u8ba4\u6216\u9a73\u56de";
        ArrayList<String> sender = new ArrayList<String>();
        String createUserId = this.msgUtil.getCreateUserId(applyEntity.getCreateUserCode());
        sender.add(createUserId);
        String formurl = this.baseHost + "cscec5bhn-fbxt-frontend/#/odd/card?id=" + entity.getId();
        String content = subject + "<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.msgUtil.sendMsg(messageType, sender, "task", subject, content, applyEntity.getId());
        return true;
    }

    @Override
    public Boolean confirmSupply(OddVO request, Integer oddStatus) {
        OddEntity odd = (OddEntity)((Object)super.selectById((Serializable)request.getId()));
        if (BillStatusEnum.\u786e\u8ba4\u9a73\u56de.getCode() == oddStatus) {
            odd.setConfirmer(request.getConfirmer());
            odd.setConfirmerName(request.getConfirmerName());
            odd.setConfirmerNote(request.getConfirmerNote());
            this.writeBackApply(odd.getId(), odd.getOddApplyId(), false);
            super.removeById((Serializable)request.getId());
            this.sendMsg(odd, oddStatus);
        } else {
            odd.setConfirmer(request.getConfirmer());
            odd.setConfirmerName(request.getConfirmerName());
            odd.setConfirmerNote(request.getConfirmerNote());
            super.saveOrUpdate((Object)odd);
        }
        return true;
    }

    private OddInfoEntity mapInfo(com.ejianc.business.fbxt.odd.vo.sysupl.OddInfoVO vo, Long oddId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        OddInfoEntity res = new OddInfoEntity();
        OddInfoApplyEntity oddInfoApplyEntity = (OddInfoApplyEntity)((Object)this.oddInfoApplyService.selectById(vo.getPkApplyInfo()));
        res.setId(null);
        res.setOddId(oddId);
        res.setInfoApplyId(vo.getPkApplyInfo());
        res.setName(vo.getInfoName());
        res.setNum(vo.getInfoAmount());
        res.setApplyNum(vo.getApplyAmount());
        res.setPrice(vo.getUnitPrice());
        res.setMny(vo.getSumPrice());
        res.setCode(vo.getInfoCode());
        res.setInfoUnit(vo.getInfoUnit());
        res.setReviewNum(vo.getInfoAmountCheck());
        res.setReviewPrice(vo.getUnitPriceCheck());
        res.setReviewMny(vo.getSumPriceCheck());
        res.setSourceType(oddInfoApplyEntity.getSourceType());
        res.setSourceId(oddInfoApplyEntity.getSourceId());
        try {
            res.setBeginTime(sdf.parse(vo.getBeginTime()));
            res.setEndTime(sdf.parse(vo.getEndTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        res.setZkcontract(null);
        res.setZkcorpname(null);
        res.setSumRedirectMny(BigDecimal.ZERO);
        res.setFileType(String.valueOf(IdWorker.getId()));
        res.setInfoNcFlag(0);
        return res;
    }

    private void writeBackApply(Long pkOdd, Long pkOddApply, boolean isUsed) {
        ApplyRequest request = new ApplyRequest();
        request.setPkOddApply(pkOddApply);
        if (isUsed) {
            request.setPkOdd(pkOdd);
        } else {
            request.setIsused(Integer.valueOf(0));
        }
        this.oddApplyService.applyUsed(request);
    }

    private void writeBackApplyToSupl(ApplyRequest request, String url) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.oddApplyUsed(headers, request, url);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    @Override
    public void sendMsg(OddEntity odd, Integer oddStatus) {
        OddWriteBackRequest request = new OddWriteBackRequest();
        request.setPkOdd(odd.getSourceId());
        request.setSourceId(odd.getId());
        request.setOddStatus(oddStatus);
        request.setConfirmer(odd.getConfirmer());
        request.setConfirmerName(odd.getConfirmerName());
        request.setConfirmerNote(odd.getConfirmerNote());
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.pushOddJob(headers, request);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                throw new BusinessException("\u7532\u65b9\u7cfb\u7edf\u62a5\u9519\uff0c\u56de\u6eda\u6570\u636e");
            }
        } else {
            throw new BusinessException("\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
        }
    }

    @Override
    public Map<Long, String> queryDefDoc(String useTypeDefCode) {
        CommonResponse listCommonResponse = this.defdocApi.queryDetailListByDefdocCode(useTypeDefCode, null);
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            HashMap<Long, String> docMap = new HashMap<Long, String>();
            for (Map map : data) {
                docMap.put(Long.parseLong(map.get("id").toString()), map.get("name").toString());
            }
            return docMap;
        }
        throw new BusinessException("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25!");
    }

    @Override
    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6token  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            this.logger.info("------------  redisTemplate\u91cc\u6709token  ------------" + this.redisTemplate.opsForValue().get((Object)"X-Open-Token"));
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = this.wjTokenUrl;
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u7cfb\u7edf\u63a8\u9001\u4f9b\u65b9\u65f6\uff0c\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> pushOddJob(Map<String, String> headers, OddWriteBackRequest copy) {
        String url = this.wjOddJobUrl;
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }

    public CommonResponse<String> oddApplyUsed(Map<String, String> headers, ApplyRequest copy, String url) {
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)copy).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)copy).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
    }
}

